/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.io.Encoding;
import nu.validator.htmlparser.io.HtmlInputStreamReader;
import nu.validator.htmlparser.test.UntilHashInputStream;
import org.xml.sax.SAXException;

public class EncodingTester {
    private final InputStream aggregateStream;
    private final StringBuilder builder = new StringBuilder();

    public EncodingTester(InputStream aggregateStream) {
        this.aggregateStream = aggregateStream;
    }

    private void runTests() throws IOException, SAXException {
        while (this.runTest()) {
        }
    }

    private boolean runTest() throws IOException, SAXException {
        if (this.skipLabel()) {
            return false;
        }
        UntilHashInputStream stream = new UntilHashInputStream(this.aggregateStream);
        HtmlInputStreamReader reader = new HtmlInputStreamReader((InputStream)stream, null, null, null, Heuristics.NONE);
        Charset charset = reader.getCharset();
        stream.close();
        if (this.skipLabel()) {
            System.err.println("Premature end of test data.");
            return false;
        }
        this.builder.setLength(0);
        block4: while (true) {
            int b = this.aggregateStream.read();
            switch (b) {
                case 10: {
                    break block4;
                }
                case -1: {
                    System.err.println("Premature end of test data.");
                    return false;
                }
                default: {
                    this.builder.append((char)b);
                    continue block4;
                }
            }
            break;
        }
        String sniffed = charset.name();
        String expected = Encoding.forName(this.builder.toString()).newDecoder().charset().name();
        if (expected.equalsIgnoreCase(sniffed)) {
            System.err.println("Success.");
        } else {
            System.err.println("Failure. Expected: " + expected + " got " + sniffed + ".");
            System.err.println(stream);
        }
        return true;
    }

    private boolean skipLabel() throws IOException {
        int b = this.aggregateStream.read();
        if (b == -1) {
            return true;
        }
        do {
            if ((b = this.aggregateStream.read()) != -1) continue;
            return true;
        } while (b != 10);
        return false;
    }

    public static void main(String[] args) throws IOException, SAXException {
        int i = 0;
        while (i < args.length) {
            EncodingTester tester = new EncodingTester(new FileInputStream(args[i]));
            tester.runTests();
            ++i;
        }
    }
}

