/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONBoolean;
import com.sdicons.json.model.JSONNull;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.Tokenizer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSONArrayTokenHandler
implements TokenHandler,
ErrorHandler {
    private static final JSONString DOCTYPE = new JSONString("DOCTYPE");
    private static final JSONString START_TAG = new JSONString("StartTag");
    private static final JSONString END_TAG = new JSONString("EndTag");
    private static final JSONString COMMENT = new JSONString("Comment");
    private static final JSONString CHARACTER = new JSONString("Character");
    private static final JSONString PARSE_ERROR = new JSONString("ParseError");
    private static final char[] REPLACEMENT_CHARACTER = new char[]{'\ufffd'};
    private final StringBuilder builder = new StringBuilder();
    private JSONArray array = null;
    private int contentModelFlag;
    private String contentModelElement;

    public void setContentModelFlag(int contentModelFlag, String contentModelElement) {
        this.contentModelFlag = contentModelFlag;
        this.contentModelElement = contentModelElement;
    }

    @Override
    public void characters(char[] buf, int start, int length) throws SAXException {
        this.builder.append(buf, start, length);
    }

    private void flushCharacters() {
        if (this.builder.length() > 0) {
            JSONArray token = new JSONArray();
            token.getValue().add(CHARACTER);
            token.getValue().add(new JSONString(this.builder.toString()));
            this.array.getValue().add(token);
            this.builder.setLength(0);
        }
    }

    @Override
    public void comment(char[] buf, int start, int length) throws SAXException {
        this.flushCharacters();
        JSONArray token = new JSONArray();
        token.getValue().add(COMMENT);
        token.getValue().add(new JSONString(new String(buf, start, length)));
        this.array.getValue().add(token);
    }

    @Override
    public void doctype(String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) throws SAXException {
        this.flushCharacters();
        JSONArray token = new JSONArray();
        token.getValue().add(DOCTYPE);
        token.getValue().add(new JSONString(name));
        token.getValue().add(publicIdentifier == null ? JSONNull.NULL : new JSONString(publicIdentifier));
        token.getValue().add(systemIdentifier == null ? JSONNull.NULL : new JSONString(systemIdentifier));
        token.getValue().add(new JSONBoolean(!forceQuirks));
        this.array.getValue().add(token);
    }

    @Override
    public void endTag(ElementName eltName) throws SAXException {
        String name = eltName.name;
        this.flushCharacters();
        JSONArray token = new JSONArray();
        token.getValue().add(END_TAG);
        token.getValue().add(new JSONString(name));
        this.array.getValue().add(token);
    }

    @Override
    public void eof() throws SAXException {
        this.flushCharacters();
    }

    @Override
    public void startTokenization(Tokenizer self) throws SAXException {
        this.array = new JSONArray();
        if (this.contentModelElement != null) {
            self.setStateAndEndTagExpectation(this.contentModelFlag, this.contentModelElement);
        }
    }

    @Override
    public void startTag(ElementName eltName, HtmlAttributes attributes, boolean selfClosing) throws SAXException {
        String name = eltName.name;
        this.flushCharacters();
        JSONArray token = new JSONArray();
        token.getValue().add(START_TAG);
        token.getValue().add(new JSONString(name));
        JSONObject attrs = new JSONObject();
        int i = 0;
        while (i < attributes.getLength()) {
            attrs.getValue().put(attributes.getQName(i), new JSONString(attributes.getValue(i)));
            ++i;
        }
        token.getValue().add(attrs);
        if (selfClosing) {
            token.getValue().add(JSONBoolean.TRUE);
        }
        this.array.getValue().add(token);
    }

    @Override
    public boolean wantsComments() throws SAXException {
        return true;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.flushCharacters();
        this.array.getValue().add(PARSE_ERROR);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new RuntimeException("Should never happen.");
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
    }

    public JSONArray getArray() {
        return this.array;
    }

    @Override
    public void endTokenization() throws SAXException {
    }

    @Override
    public void zeroOriginatingReplacementCharacter() throws SAXException {
        this.builder.append(REPLACEMENT_CHARACTER, 0, 1);
    }

    @Override
    public boolean cdataSectionAllowed() throws SAXException {
        return false;
    }
}

