/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.test;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.parser.JSONParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.ErrorReportingTokenizer;
import nu.validator.htmlparser.io.Driver;
import nu.validator.htmlparser.test.JSONArrayTokenHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TokenizerTester {
    private static JSONString PLAINTEXT = new JSONString("PLAINTEXT state");
    private static JSONString PCDATA = new JSONString("DATA state");
    private static JSONString RCDATA = new JSONString("RCDATA state");
    private static JSONString RAWTEXT = new JSONString("RAWTEXT state");
    private JSONArray tests;
    private final JSONArrayTokenHandler tokenHandler = new JSONArrayTokenHandler();
    private final Driver driver = new Driver(new ErrorReportingTokenizer(this.tokenHandler));
    private final Writer writer;

    private static boolean jsonDeepEquals(JSONValue one, JSONValue other) {
        if (one.isSimple()) {
            return one.equals(other);
        }
        if (one.isArray()) {
            if (other.isArray()) {
                JSONArray oneArr = (JSONArray)one;
                JSONArray otherArr = (JSONArray)other;
                return oneArr.getValue().equals(otherArr.getValue());
            }
            return false;
        }
        if (one.isObject()) {
            if (other.isObject()) {
                JSONObject oneObject = (JSONObject)one;
                JSONObject otherObject = (JSONObject)other;
                return oneObject.getValue().equals(otherObject.getValue());
            }
            return false;
        }
        throw new RuntimeException("Should never happen.");
    }

    private TokenizerTester(InputStream stream) throws TokenStreamException, RecognitionException, UnsupportedEncodingException {
        this.driver.setCommentPolicy(XmlViolationPolicy.ALLOW);
        this.driver.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        this.driver.setContentSpacePolicy(XmlViolationPolicy.ALLOW);
        this.driver.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.driver.setXmlnsPolicy(XmlViolationPolicy.ALLOW);
        this.driver.setErrorHandler(this.tokenHandler);
        this.writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        JSONParser jsonParser = new JSONParser((Reader)new InputStreamReader(stream, "UTF-8"));
        JSONObject obj = (JSONObject)jsonParser.nextValue();
        this.tests = (JSONArray)obj.get("tests");
        if (this.tests == null) {
            this.tests = (JSONArray)obj.get("xmlViolationTests");
            this.driver.setCommentPolicy(XmlViolationPolicy.ALTER_INFOSET);
            this.driver.setContentNonXmlCharPolicy(XmlViolationPolicy.ALTER_INFOSET);
            this.driver.setNamePolicy(XmlViolationPolicy.ALTER_INFOSET);
            this.driver.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        }
    }

    private void runTests() throws SAXException, IOException {
        for (JSONValue val : this.tests.getValue()) {
            this.runTest((JSONObject)val);
        }
        this.writer.flush();
    }

    private void runTest(JSONObject test) throws SAXException, IOException {
        String inputString = ((JSONString)test.get("input")).getValue();
        JSONArray expectedTokens = (JSONArray)test.get("output");
        String description = ((JSONString)test.get("description")).getValue();
        JSONString lastStartTagJSON = (JSONString)test.get("lastStartTag");
        String lastStartTag = lastStartTagJSON == null ? null : lastStartTagJSON.getValue();
        JSONArray contentModelFlags = (JSONArray)test.get("initialStates");
        if (contentModelFlags == null) {
            this.runTestInner(inputString, expectedTokens, description, 0, null);
        } else {
            for (JSONValue value : contentModelFlags.getValue()) {
                if (PCDATA.equals((Object)value)) {
                    this.runTestInner(inputString, expectedTokens, description, 0, lastStartTag);
                    continue;
                }
                if (RAWTEXT.equals((Object)value)) {
                    this.runTestInner(inputString, expectedTokens, description, 3, lastStartTag);
                    continue;
                }
                if (RCDATA.equals((Object)value)) {
                    this.runTestInner(inputString, expectedTokens, description, 1, lastStartTag);
                    continue;
                }
                if (PLAINTEXT.equals((Object)value)) {
                    this.runTestInner(inputString, expectedTokens, description, 8, lastStartTag);
                    continue;
                }
                throw new RuntimeException("Broken test data.");
            }
        }
    }

    private void runTestInner(String inputString, JSONArray expectedTokens, String description, int contentModelFlag, String contentModelElement) throws SAXException, IOException {
        this.tokenHandler.setContentModelFlag(contentModelFlag, contentModelElement);
        InputSource is = new InputSource(new StringReader(inputString));
        try {
            this.driver.tokenize(is);
            JSONArray actualTokens = this.tokenHandler.getArray();
            if (TokenizerTester.jsonDeepEquals((JSONValue)actualTokens, (JSONValue)expectedTokens)) {
                this.writer.write("Success\n");
            } else {
                this.writer.write("Failure\n");
                this.writer.write(description);
                this.writer.write("\nInput:\n");
                this.writer.write(inputString);
                this.writer.write("\nExpected tokens:\n");
                this.writer.write(expectedTokens.render(false));
                this.writer.write("\nActual tokens:\n");
                this.writer.write(actualTokens.render(false));
                this.writer.write("\n");
            }
        }
        catch (Throwable t) {
            this.writer.write("Failure\n");
            this.writer.write(description);
            this.writer.write("\nInput:\n");
            this.writer.write(inputString);
            this.writer.write("\n");
            t.printStackTrace(new PrintWriter(this.writer, false));
        }
    }

    public static void main(String[] args) throws TokenStreamException, RecognitionException, SAXException, IOException {
        int i = 0;
        while (i < args.length) {
            TokenizerTester tester = new TokenizerTester(new FileInputStream(args[i]));
            tester.runTests();
            ++i;
        }
    }
}

