/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelClose;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelEOF;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.connection.SshMsgChannelFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelOpen;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelRequest;
import com.sshtools.j2ssh.connection.SshMsgChannelSuccess;
import com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.sshtools.j2ssh.connection.SshMsgGlobalRequest;
import com.sshtools.j2ssh.connection.SshMsgRequestFailure;
import com.sshtools.j2ssh.connection.SshMsgRequestSuccess;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionProtocol
extends AsyncService {
    private static Log log = LogFactory.getLog((Class)ConnectionProtocol.class);
    private HashSet reusableChannels = new HashSet();
    private Map activeChannels = new HashMap();
    private Map allowedChannels = new HashMap();
    private Map globalRequests = new HashMap();
    private long nextChannelId = 0L;

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String string, ChannelFactory channelFactory) throws IOException {
        this.allowedChannels.put(string, channelFactory);
    }

    public void removeChannelFactory(String string) {
        this.allowedChannels.remove(string);
    }

    public boolean containsChannelFactory(String string) {
        return this.allowedChannels.containsKey(string);
    }

    public void allowGlobalRequest(String string, GlobalRequestHandler globalRequestHandler) {
        this.globalRequests.put(string, globalRequestHandler);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getChannelId() {
        Map map = this.activeChannels;
        synchronized (map) {
            if (this.reusableChannels.size() <= 0) {
                return new Long(this.nextChannelId++);
            }
            return (Long)this.reusableChannels.iterator().next();
        }
    }

    public synchronized boolean openChannel(Channel channel, ChannelEventListener channelEventListener) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long l = this.getChannelId();
            SshMsgChannelOpen sshMsgChannelOpen = new SshMsgChannelOpen(channel.getChannelType(), l, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(sshMsgChannelOpen, this);
            int[] nArray = new int[]{91, 92};
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                if (sshMessage.getMessageId() == 91) {
                    SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = (SshMsgChannelOpenConfirmation)sshMessage;
                    this.activeChannels.put(l, channel);
                    log.debug((Object)"Initiating channel");
                    channel.init(this, l, sshMsgChannelOpenConfirmation.getSenderChannel(), sshMsgChannelOpenConfirmation.getInitialWindowSize(), sshMsgChannelOpenConfirmation.getMaximumPacketSize(), channelEventListener);
                    channel.open();
                    log.info((Object)("Channel " + String.valueOf(channel.getLocalChannelId()) + " is open [" + channel.getName() + "]"));
                    return true;
                }
                channel.getState().setValue(3);
                return false;
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                throw new IOException(messageStoreEOFException.getMessage());
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
    }

    protected void onStop() {
        log.info((Object)"Closing all active channels");
        try {
            Iterator iterator = this.activeChannels.values().iterator();
            while (iterator.hasNext()) {
                Channel channel = (Channel)iterator.next();
                if (channel == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing " + channel.getName() + " id=" + String.valueOf(channel.getLocalChannelId())));
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeChannels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendChannelData(Channel channel, byte[] byArray) throws IOException {
        ChannelState channelState = channel.getState();
        synchronized (channelState) {
            int n;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending " + String.valueOf(byArray.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId())));
            }
            ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
            for (int i = 0; i < byArray.length; i += n) {
                int n2 = byArray.length - i;
                long l = channelDataWindow.getWindowSpace() < channel.getRemotePacketSize() && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : channel.getRemotePacketSize();
                n = l < (long)n2 ? (int)l : n2;
                channel.remoteWindow.consumeWindowSpace(n);
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, i, byArray2, 0, n);
                SshMsgChannelData sshMsgChannelData = new SshMsgChannelData(channel.getRemoteChannelId(), byArray2);
                this.transport.sendMessage(sshMsgChannelData, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            if (!this.activeChannels.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel " + String.valueOf(channel.getLocalChannelId()));
            }
            log.info((Object)("Local computer has set channel " + String.valueOf(channel.getLocalChannelId()) + " to EOF [" + channel.getName() + "]"));
            SshMsgChannelEOF sshMsgChannelEOF = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(sshMsgChannelEOF, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int n, byte[] byArray) throws IOException {
        int n2;
        channel.getRemoteWindow().consumeWindowSpace(byArray.length);
        ChannelDataWindow channelDataWindow = channel.getRemoteWindow();
        for (int i = 0; i < byArray.length; i += n2) {
            int n3 = byArray.length - i;
            long l = channelDataWindow.getWindowSpace() < channel.getRemotePacketSize() && channelDataWindow.getWindowSpace() > 0L ? channelDataWindow.getWindowSpace() : channel.getRemotePacketSize();
            n2 = l < (long)n3 ? (int)l : n3;
            channel.remoteWindow.consumeWindowSpace(n2);
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, i, byArray2, 0, n2);
            SshMsgChannelExtendedData sshMsgChannelExtendedData = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), n, byArray2);
            this.transport.sendMessage(sshMsgChannelExtendedData, this);
        }
    }

    public synchronized boolean sendChannelRequest(Channel channel, String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        log.info((Object)("Sending " + string + " request for the " + channel.getChannelType() + " channel"));
        SshMsgChannelRequest sshMsgChannelRequest = new SshMsgChannelRequest(channel.getRemoteChannelId(), string, bl, byArray);
        this.transport.sendMessage(sshMsgChannelRequest, this);
        if (bl) {
            int[] nArray = new int[]{99, 100};
            log.info((Object)"Waiting for channel request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 99: {
                        log.info((Object)"Channel request succeeded");
                        bl2 = true;
                        break;
                    }
                    case 100: {
                        log.info((Object)"Channel request failed");
                        bl2 = false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return bl2;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    public void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess sshMsgChannelSuccess = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelSuccess, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long l) throws IOException {
        log.debug((Object)("Increasing window size by " + String.valueOf(l) + " bytes"));
        SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), l);
        this.transport.sendMessage(sshMsgChannelWindowAdjust, this);
    }

    public synchronized byte[] sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        boolean bl2 = true;
        SshMsgGlobalRequest sshMsgGlobalRequest = new SshMsgGlobalRequest(string, true, byArray);
        this.transport.sendMessage(sshMsgGlobalRequest, this);
        if (bl) {
            int[] nArray = new int[]{81, 82};
            log.debug((Object)"Waiting for global request reply");
            try {
                SshMessage sshMessage = this.messageStore.getMessage(nArray);
                switch (sshMessage.getMessageId()) {
                    case 81: {
                        log.debug((Object)"Global request succeeded");
                        return ((SshMsgRequestSuccess)sshMessage).getRequestData();
                    }
                    case 82: {
                        log.debug((Object)"Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return null;
    }

    protected int[] getAsyncMessageFilter() {
        int[] nArray = new int[10];
        nArray[0] = 80;
        nArray[3] = 90;
        nArray[4] = 97;
        nArray[5] = 96;
        nArray[6] = 95;
        nArray[7] = 94;
        nArray[8] = 98;
        nArray[9] = 93;
        return nArray;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose sshMsgChannelClose = new SshMsgChannelClose(channel.getRemoteChannelId());
        log.info((Object)("Local computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]"));
        this.transport.sendMessage(sshMsgChannelClose, this);
    }

    protected void onGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug((Object)("Processing " + string + " global request"));
        if (!this.globalRequests.containsKey(string)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler globalRequestHandler = (GlobalRequestHandler)this.globalRequests.get(string);
            GlobalRequestResponse globalRequestResponse = globalRequestHandler.processGlobalRequest(string, byArray);
            if (bl) {
                if (globalRequestResponse.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(globalRequestResponse.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    protected void onMessageReceived(SshMessage sshMessage) throws IOException {
        switch (sshMessage.getMessageId()) {
            case 80: {
                this.onMsgGlobalRequest((SshMsgGlobalRequest)sshMessage);
                break;
            }
            case 90: {
                this.onMsgChannelOpen((SshMsgChannelOpen)sshMessage);
                break;
            }
            case 97: {
                this.onMsgChannelClose((SshMsgChannelClose)sshMessage);
                break;
            }
            case 96: {
                this.onMsgChannelEOF((SshMsgChannelEOF)sshMessage);
                break;
            }
            case 94: {
                this.onMsgChannelData((SshMsgChannelData)sshMessage);
                break;
            }
            case 95: {
                this.onMsgChannelExtendedData((SshMsgChannelExtendedData)sshMessage);
                break;
            }
            case 98: {
                this.onMsgChannelRequest((SshMsgChannelRequest)sshMessage);
                break;
            }
            case 93: {
                this.onMsgChannelWindowAdjust((SshMsgChannelWindowAdjust)sshMessage);
                break;
            }
            default: {
                log.debug((Object)"Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    protected void onServiceAccept() {
    }

    protected void onServiceInit(int n) throws IOException {
        log.info((Object)"Registering connection protocol messages");
        this.messageStore.registerMessage(91, SshMsgChannelOpenConfirmation.class);
        this.messageStore.registerMessage(92, SshMsgChannelOpenFailure.class);
        this.messageStore.registerMessage(90, SshMsgChannelOpen.class);
        this.messageStore.registerMessage(97, SshMsgChannelClose.class);
        this.messageStore.registerMessage(96, SshMsgChannelEOF.class);
        this.messageStore.registerMessage(94, SshMsgChannelData.class);
        this.messageStore.registerMessage(95, SshMsgChannelExtendedData.class);
        this.messageStore.registerMessage(100, SshMsgChannelFailure.class);
        this.messageStore.registerMessage(98, SshMsgChannelRequest.class);
        this.messageStore.registerMessage(99, SshMsgChannelSuccess.class);
        this.messageStore.registerMessage(93, SshMsgChannelWindowAdjust.class);
        this.messageStore.registerMessage(80, SshMsgGlobalRequest.class);
        this.messageStore.registerMessage(82, SshMsgRequestFailure.class);
        this.messageStore.registerMessage(81, SshMsgRequestSuccess.class);
    }

    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure sshMsgChannelFailure = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(sshMsgChannelFailure, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation sshMsgChannelOpenConfirmation = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(sshMsgChannelOpenConfirmation, this);
    }

    protected void sendChannelOpenFailure(long l, long l2, String string, String string2) throws IOException {
        SshMsgChannelOpenFailure sshMsgChannelOpenFailure = new SshMsgChannelOpenFailure(l, l2, string, string2);
        this.transport.sendMessage(sshMsgChannelOpenFailure, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure sshMsgRequestFailure = new SshMsgRequestFailure();
        this.transport.sendMessage(sshMsgRequestFailure, this);
    }

    protected void sendGlobalRequestSuccess(byte[] byArray) throws IOException {
        SshMsgRequestSuccess sshMsgRequestSuccess = new SshMsgRequestSuccess(byArray);
        this.transport.sendMessage(sshMsgRequestSuccess, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(long l) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long l2 = new Long(l);
            if (!this.activeChannels.containsKey(l2)) {
                throw new IOException("Non existent channel " + l2.toString() + " requested");
            }
            return (Channel)this.activeChannels.get(l2);
        }
    }

    private void onMsgChannelClose(SshMsgChannelClose sshMsgChannelClose) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelClose.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel " + String.valueOf(sshMsgChannelClose.getRecipientChannel()));
        }
        log.info((Object)("Remote computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]"));
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void onMsgChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + String.valueOf(sshMsgChannelData.getChannelData().length) + " bytes of data for channel id " + String.valueOf(sshMsgChannelData.getRecipientChannel())));
        }
        Channel channel = this.getChannel(sshMsgChannelData.getRecipientChannel());
        channel.processChannelData(sshMsgChannelData);
    }

    private void onMsgChannelEOF(SshMsgChannelEOF sshMsgChannelEOF) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelEOF.getRecipientChannel());
        try {
            log.info((Object)("Remote computer has set channel " + String.valueOf(sshMsgChannelEOF.getRecipientChannel()) + " to EOF [" + channel.getName() + "]"));
            channel.setRemoteEOF();
        }
        catch (IOException iOException) {
            log.info((Object)"Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void onMsgChannelExtendedData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelExtendedData.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.getLocalWindow().consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
        channel.processChannelData(sshMsgChannelExtendedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgChannelOpen(SshMsgChannelOpen sshMsgChannelOpen) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info((Object)("Request for " + sshMsgChannelOpen.getChannelType() + " channel recieved"));
            ChannelFactory channelFactory = (ChannelFactory)this.allowedChannels.get(sshMsgChannelOpen.getChannelType());
            if (channelFactory == null) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, "The channel type is not supported", "");
                log.info((Object)("Request for channel type " + sshMsgChannelOpen.getChannelType() + " refused"));
                return;
            }
            try {
                log.info((Object)("Creating channel " + sshMsgChannelOpen.getChannelType()));
                Channel channel = channelFactory.createChannel(sshMsgChannelOpen.getChannelType(), sshMsgChannelOpen.getChannelData());
                log.info((Object)"Initiating channel");
                Long l = this.getChannelId();
                channel.init(this, l, sshMsgChannelOpen.getSenderChannelId(), sshMsgChannelOpen.getInitialWindowSize(), sshMsgChannelOpen.getMaximumPacketSize());
                this.activeChannels.put(l, channel);
                log.info((Object)"Sending channel open confirmation");
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException invalidChannelException) {
                this.sendChannelOpenFailure(sshMsgChannelOpen.getSenderChannelId(), 2L, invalidChannelException.getMessage(), "");
            }
        }
    }

    private void onMsgChannelRequest(SshMsgChannelRequest sshMsgChannelRequest) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelRequest.getRecipientChannel());
        if (channel == null) {
            log.warn((Object)"Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(sshMsgChannelRequest.getRequestType(), sshMsgChannelRequest.getWantReply(), sshMsgChannelRequest.getChannelData());
    }

    private void onMsgChannelWindowAdjust(SshMsgChannelWindowAdjust sshMsgChannelWindowAdjust) throws IOException {
        Channel channel = this.getChannel(sshMsgChannelWindowAdjust.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for non existent channel " + String.valueOf(sshMsgChannelWindowAdjust.getRecipientChannel()));
        }
        channel.getRemoteWindow().increaseWindowSpace(sshMsgChannelWindowAdjust.getBytesToAdd());
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(sshMsgChannelWindowAdjust.getBytesToAdd()) + " bytes added to remote window"));
            log.debug((Object)("Remote window space is " + String.valueOf(channel.getRemoteWindow().getWindowSpace())));
        }
    }

    private void onMsgGlobalRequest(SshMsgGlobalRequest sshMsgGlobalRequest) throws IOException {
        this.onGlobalRequest(sshMsgGlobalRequest.getRequestName(), sshMsgGlobalRequest.getWantReply(), sshMsgGlobalRequest.getRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(Channel channel) {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info((Object)("Freeing channel " + String.valueOf(channel.getLocalChannelId()) + " [" + channel.getName() + "]"));
            Long l = new Long(channel.getLocalChannelId());
            this.activeChannels.remove(l);
        }
    }
}

