/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.OutputStream;

public class SftpFileOutputStream
extends OutputStream {
    SftpFile file;
    UnsignedInteger64 position = new UnsignedInteger64("0");

    public SftpFileOutputStream(SftpFile paramSftpFile) throws IOException {
        if (paramSftpFile.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (paramSftpFile.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.file = paramSftpFile;
    }

    public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws IOException {
        int j;
        int max = (int)this.file.getSFTPSubsystem().maximumPacketSize();
        for (int i = 0; i < paramInt2; i += j) {
            Long availableWindowSpace = this.file.getSFTPSubsystem().availableWindowSpace();
            int available = availableWindowSpace.compareTo(Long.valueOf(max)) < 0 ? availableWindowSpace.intValue() : max;
            j = available < paramInt2 - i ? available : paramInt2 - i;
            this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, paramArrayOfByte, paramInt1 + i, j);
            this.position = UnsignedInteger64.add(this.position, j);
        }
    }

    public void write(int paramInt) throws IOException {
        byte[] arrayOfByte = new byte[]{(byte)paramInt};
        this.file.getSFTPSubsystem().writeFile(this.file.getHandle(), this.position, arrayOfByte, 0, 1);
        this.position = UnsignedInteger64.add(this.position, 1);
    }

    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws IOException {
        if (this.file.getHandle() != null) {
            this.close();
        }
    }
}

