/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgDebug;
import com.sshtools.j2ssh.transport.SshMsgDisconnect;
import com.sshtools.j2ssh.transport.SshMsgIgnore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgNewKeys;
import com.sshtools.j2ssh.transport.SshMsgUnimplemented;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.TransportProtocolInputStream;
import com.sshtools.j2ssh.transport.TransportProtocolOutputStream;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Log log = LogFactory.getLog((Class)TransportProtocolCommon.class);
    private static int nextThreadNo = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static String SOFTWARE_VERSION_COMMENTS = "http://www.sshtools.com " + ConfigurationLoader.getVersionString("J2SSH", "j2ssh.properties");
    private int threadNo = nextThreadNo++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean sendIgnore = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] exchangeHash = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector eventHandlers = new Vector();
    private List messageStack = new ArrayList();
    private Map messageNotifications = new HashMap();
    private Object kexLock = new Object();
    private Object keyLock = new Object();
    TransportProvider provider;
    private SshThread thread;
    private long kexTimeout = 3600000L;
    private long kexTransferLimitKB = 0x100000L;
    private long startTime = System.currentTimeMillis();
    private long transferredKB = 0L;
    private long lastTriggeredKB = 0L;
    protected TransportProtocolInputStream sshIn;
    protected TransportProtocolOutputStream sshOut;
    private int remoteEOL = 1;
    private Vector messageStores = new Vector();

    public int getConnectionId() {
        return this.threadNo;
    }

    public int getRemoteEOL() {
        return this.remoteEOL;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disconnect: " + string));
        }
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(string);
            this.sendDisconnect(11, string);
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    public void setSendIgnore(boolean bl) {
        this.sendIgnore = bl;
    }

    public void setKexTimeout(long l) throws TransportProtocolException {
        if (l < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.kexTimeout = l * 1000L;
    }

    public void setKexTransferLimit(long l) throws TransportProtocolException {
        if (l < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.kexTransferLimitKB = l;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.getNumBytesTransfered();
    }

    public long getIncomingByteCount() {
        return this.sshIn.getNumBytesTransfered();
    }

    public void addEventHandler(TransportProtocolEventHandler transportProtocolEventHandler) {
        if (transportProtocolEventHandler != null) {
            this.eventHandlers.add(transportProtocolEventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.state.setValue(2);
            log.info((Object)"Registering transport protocol messages with inputstream");
            this.algorithmsOut = new TransportProtocolAlgorithmSync();
            this.algorithmsIn = new TransportProtocolAlgorithmSync();
            this.sshIn = new TransportProtocolInputStream(this, this.provider.getInputStream(), this.algorithmsIn);
            this.sshOut = new TransportProtocolOutputStream(this.provider.getOutputStream(), this, this.algorithmsOut);
            this.messageStore.registerMessage(1, SshMsgDisconnect.class);
            this.messageStore.registerMessage(2, SshMsgIgnore.class);
            this.messageStore.registerMessage(3, SshMsgUnimplemented.class);
            this.messageStore.registerMessage(4, SshMsgDebug.class);
            this.messageStore.registerMessage(20, SshMsgKexInit.class);
            this.messageStore.registerMessage(21, SshMsgNewKeys.class);
            this.registerTransportMessages();
            List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                sshKeyExchange.init(this);
                this.kexs.put(string, sshKeyExchange);
            }
            this.setLocalIdent();
            this.negotiateVersion();
            this.startBinaryPacketProtocol();
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                this.state.setLastError((IOException)throwable);
            }
            if (this.state.getValue() != 5) {
                log.error((Object)"The Transport Protocol thread failed", throwable);
                this.stop();
            }
        }
        finally {
            this.thread = null;
        }
        log.debug((Object)"The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(SshMessage sshMessage, Object object) throws IOException {
        if (log.isDebugEnabled()) {
            log.info((Object)("Sending " + sshMessage.getMessageName()));
        }
        int n = this.state.getValue();
        if (object instanceof SshKeyExchange || object instanceof TransportProtocolCommon || n == 4) {
            this.sshOut.sendMessage(sshMessage);
            if (n == 4 && this.sendIgnore) {
                byte[] byArray = new byte[1];
                ConfigurationLoader.getRND().nextBytes(byArray);
                byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
                ConfigurationLoader.getRND().nextBytes(byArray2);
                SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending " + sshMsgIgnore.getMessageName()));
                }
                this.sshOut.sendMessage(sshMsgIgnore);
            }
        } else if (n == 3) {
            log.debug((Object)"Adding to message queue whilst in key exchange");
            List list = this.messageStack;
            synchronized (list) {
                this.messageStack.add(sshMessage);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(TransportProvider transportProvider, SshConnectionProperties sshConnectionProperties) throws IOException {
        this.provider = transportProvider;
        this.properties = sshConnectionProperties;
        log.info((Object)"Starting transport protocol");
        this.thread = new SshThread(this, "Transport protocol", true);
        this.thread.start();
        this.onStartTransportProtocol();
    }

    public String getUnderlyingProviderDetail() {
        return this.provider.getProviderDetail();
    }

    public void unregisterMessage(Integer n, SshMessageStore sshMessageStore) throws MessageNotRegisteredException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering message Id " + n.toString()));
        }
        if (!this.messageNotifications.containsKey(n)) {
            throw new MessageNotRegisteredException(n);
        }
        SshMessageStore sshMessageStore2 = (SshMessageStore)this.messageNotifications.get(n);
        if (!sshMessageStore.equals(sshMessageStore2)) {
            throw new MessageNotRegisteredException(n, sshMessageStore);
        }
        this.messageNotifications.remove(n);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange() throws IOException, KeyExchangeException {
        log.info((Object)"Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key exchange algorithm: " + string));
            }
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange);
            this.exchangeHash = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.exchangeHash.length];
                System.arraycopy(this.exchangeHash, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.thread.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys();
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.");
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal((Object)"Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    protected void sendDisconnect(int n, String string) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(n, string, "");
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    protected void sendDisconnect(int n, String string, IOException iOException) {
        this.state.setLastError(iOException);
        this.sendDisconnect(n, string);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        this.sendMessage(this.getLocalKexInit(), this);
        this.state.setValue(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        this.algorithmsOut.lock();
        boolean bl = false;
        try {
            int[] nArray = new int[]{21};
            sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received " + sshMsgNewKeys.getMessageName()));
            }
            bl = true;
            this.completeKeyExchange();
        }
        finally {
            if (!bl) {
                this.algorithmsOut.release();
            }
        }
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeKeyExchange() throws IOException {
        log.info((Object)"Completing key exchange");
        boolean bl = false;
        try {
            log.debug((Object)"Making keys from key exchange output");
            byte[] byArray = this.makeSshKey('C');
            byte[] byArray2 = this.makeSshKey('A');
            byte[] byArray3 = this.makeSshKey('D');
            byte[] byArray4 = this.makeSshKey('B');
            byte[] byArray5 = this.makeSshKey('E');
            byte[] byArray6 = this.makeSshKey('F');
            log.debug((Object)"Creating algorithm objects");
            this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
            this.clientKexInit = null;
            this.serverKexInit = null;
            this.algorithmsOut.release();
            bl = true;
            this.state.setValue(4);
            List list = this.messageStack;
            synchronized (list) {
                Iterator iterator = this.messageStack.iterator();
                log.debug((Object)"Sending queued messages");
                while (iterator.hasNext()) {
                    SshMessage sshMessage = (SshMessage)iterator.next();
                    this.sendMessage(sshMessage, this);
                }
                this.messageStack.clear();
            }
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed");
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded");
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error");
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error");
        }
        finally {
            if (!bl) {
                this.algorithmsOut.release();
            }
        }
    }

    protected List getEventHandlers() {
        return this.eventHandlers;
    }

    protected String determineAlgorithm(List list, List list2) throws AlgorithmNotAgreedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Determine Algorithm");
            log.debug((Object)("Client Algorithms: " + list.toString()));
            log.debug((Object)("Server Algorithms: " + list2.toString()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string.equals(string2)) continue;
                log.debug((Object)("Returning " + string));
                return string;
            }
        }
        throw new AlgorithmNotAgreedException("Could not agree algorithm");
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        block7: while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received " + sshMessage.getMessageName()));
            }
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.onMsgKexInit((SshMsgKexInit)sshMessage);
                    continue block7;
                }
                case 1: {
                    this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                    continue block7;
                }
                case 2: {
                    this.onMsgIgnore((SshMsgIgnore)sshMessage);
                    continue block7;
                }
                case 3: {
                    this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                    continue block7;
                }
                case 4: {
                    this.onMsgDebug((SshMsgDebug)sshMessage);
                    continue block7;
                }
            }
            this.onMessageReceived(sshMessage);
        }
    }

    protected final void stop() {
        this.onDisconnect();
        Iterator iterator = this.eventHandlers.iterator();
        while (iterator.hasNext()) {
            TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
            transportProtocolEventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        iterator = this.messageStores.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            try {
                sshMessageStore.close();
            }
            catch (Exception exception) {}
        }
        this.messageStores.clear();
        this.messageStore = null;
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] makeSshKey(char c) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[20];
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putByte((byte)c);
            hash.putBytes(this.sessionIdentifier);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putBytes(byArray);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported");
        }
        catch (IOException iOException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data");
        }
    }

    private void negotiateVersion() throws IOException {
        String string;
        String string2 = "";
        log.info((Object)"Negotiating protocol version");
        log.debug((Object)("Local identification: " + this.getLocalId()));
        String string3 = this.getLocalId() + "\r\n";
        this.provider.getOutputStream().write(string3.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 255;
        while (!string2.startsWith("SSH-") && stringBuffer.length() < n) {
            char c;
            while ((c = (char)this.provider.getInputStream().read()) != '\n' && stringBuffer.length() < n) {
                stringBuffer.append(c);
            }
            string2 = stringBuffer.toString();
            this.remoteEOL = string2.endsWith("\r") ? 1 : 2;
            log.debug((Object)("EOL is guessed at " + (this.remoteEOL == 1 ? "CR+LF" : "LF")));
            string2 = string2.trim();
        }
        int n2 = string2.indexOf("-");
        int n3 = string2.indexOf("-", n2 + 1);
        this.setRemoteIdent(string2.trim());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remote identification: " + this.getRemoteId()));
        }
        if (!(string = string2.substring(n2 + 1, n3)).equals(PROTOCOL_VERSION) && !string.equals("1.99")) {
            log.fatal((Object)"The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        log.info((Object)"Protocol negotiation complete");
    }

    private void onMsgDebug(SshMsgDebug sshMsgDebug) {
        log.debug((Object)sshMsgDebug.getMessage());
    }

    private void onMsgDisconnect(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.info((Object)("The remote computer disconnected: " + sshMsgDisconnect.getDescription()));
        this.state.setValue(5);
        this.state.setDisconnectReason(sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void onMsgIgnore(SshMsgIgnore sshMsgIgnore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SSH_MSG_IGNORE with " + String.valueOf(sshMsgIgnore.getData().length()) + " bytes of data"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgKexInit(SshMsgKexInit sshMsgKexInit) throws IOException {
        log.debug((Object)"Received remote key exchange init message");
        log.debug((Object)sshMsgKexInit.toString());
        Object object = this.kexLock;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgNewKeys(SshMsgNewKeys sshMsgNewKeys) throws IOException {
        log.debug((Object)"Received New Keys");
        Boolean bl = this.completeOnNewKeys;
        synchronized (bl) {
            if (this.completeOnNewKeys.booleanValue()) {
                this.algorithmsOut.lock();
                this.completeKeyExchange();
            } else {
                this.completeOnNewKeys = new Boolean(true);
            }
        }
    }

    private void onMsgUnimplemented(SshMsgUnimplemented sshMsgUnimplemented) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The message with sequence no " + sshMsgUnimplemented.getSequenceNo() + " was reported as unimplemented by the remote end."));
        }
    }

    public SshMessage readMessage(int[] nArray) throws IOException {
        byte[] byArray = null;
        block6: while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            boolean bl = false;
            while (!bl) {
                byArray = this.sshIn.readMessage();
                bl = true;
            }
            Integer n = SshMessage.getMessageId(byArray);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                if (this.messageStore.isRegisteredMessage(n)) {
                    return this.messageStore.createMessage(byArray);
                }
                SshMessageStore sshMessageStore = this.getMessageStore(n);
                sshMessage = sshMessageStore.createMessage(byArray);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Processing " + sshMessage.getMessageName()));
                }
                return sshMessage;
            }
            if (this.messageStore.isRegisteredMessage(n)) {
                sshMessage = this.messageStore.createMessage(byArray);
                switch (n) {
                    case 1: {
                        this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                        continue block6;
                    }
                    case 2: {
                        this.onMsgIgnore((SshMsgIgnore)sshMessage);
                        continue block6;
                    }
                    case 3: {
                        this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                        continue block6;
                    }
                    case 4: {
                        this.onMsgDebug((SshMsgDebug)sshMessage);
                        continue block6;
                    }
                }
                throw new IOException("Unexpected transport protocol message");
            }
            throw new IOException("Unexpected message received");
        }
        throw new IOException("The transport protocol disconnected");
    }

    protected SshMessage processMessages() throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            long l = System.currentTimeMillis();
            this.transferredKB = this.sshIn.getNumBytesTransfered() / 1024L + this.sshOut.getNumBytesTransfered() / 1024L;
            long l2 = this.transferredKB - this.lastTriggeredKB;
            if (l - this.startTime > this.kexTimeout || l2 > this.kexTransferLimitKB) {
                this.startTime = l;
                this.lastTriggeredKB = this.transferredKB;
                if (log.isDebugEnabled()) {
                    log.info((Object)"rekey");
                }
                this.sendKeyExchangeInit();
            }
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.readMessage();
                    bl = true;
                }
                catch (InterruptedIOException interruptedIOException) {
                    log.info((Object)"Possible timeout on transport inputstream");
                    Iterator iterator = this.eventHandlers.iterator();
                    while (iterator.hasNext()) {
                        TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
                        transportProtocolEventHandler.onSocketTimeout(this);
                    }
                }
            }
            Integer n = SshMessage.getMessageId(byArray);
            if (!this.messageStore.isRegisteredMessage(n)) {
                SshMessage sshMessage;
                try {
                    SshMessageStore sshMessageStore = this.getMessageStore(n);
                    sshMessage = sshMessageStore.createMessage(byArray);
                    if (log.isDebugEnabled()) {
                        log.info((Object)("Received " + sshMessage.getMessageName()));
                    }
                    sshMessageStore.addMessage(sshMessage);
                }
                catch (MessageNotRegisteredException messageNotRegisteredException) {
                    log.info((Object)("Unimplemented message received " + String.valueOf(n)));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.getSequenceNo());
                    this.sendMessage(sshMessage, this);
                }
                continue;
            }
            return this.messageStore.createMessage(byArray);
        }
        throw new IOException("The transport protocol has disconnected");
    }

    public void addMessageStore(SshMessageStore sshMessageStore) throws MessageAlreadyRegisteredException {
        this.messageStores.add(sshMessageStore);
    }

    private SshMessageStore getMessageStore(Integer n) throws MessageNotRegisteredException {
        Iterator iterator = this.messageStores.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            if (!sshMessageStore.isRegisteredMessage(n)) continue;
            return sshMessageStore;
        }
        throw new MessageNotRegisteredException(n);
    }

    public void removeMessageStore(SshMessageStore sshMessageStore) {
        this.messageStores.remove(sshMessageStore);
    }
}

