/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.sitescan.data.audit.factor.pages;

import com.agilemind.commons.application.modules.audit.AuditStatusType;
import com.agilemind.commons.application.modules.io.searchengine.data.SearchEngineFactor;
import com.agilemind.commons.io.searchengine.analyzers.SearchEngineFactorsList;
import com.agilemind.commons.io.searchengine.analyzers.data.FactorType;
import com.agilemind.commons.io.searchengine.robots.data.RobotsResult;
import com.agilemind.sitescan.data.audit.factor.pages.FactorDependPagesAuditFactor;
import com.agilemind.sitescan.data.audit.factor.pages.PagesAuditResult;
import com.agilemind.websiteauditor.data.WebsiteAuditorPage;
import java.util.ArrayList;
import java.util.List;

public class PagesRestrictedFromIndexingAuditFactor
extends FactorDependPagesAuditFactor {
    public PagesRestrictedFromIndexingAuditFactor() {
        super(SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
    }

    @Override
    public PagesAuditResult getResult(List<WebsiteAuditorPage> list) {
        int n2 = FactorDependPagesAuditFactor.c;
        int n3 = 0;
        ArrayList<WebsiteAuditorPage> arrayList = new ArrayList<WebsiteAuditorPage>();
        for (WebsiteAuditorPage websiteAuditorPage : list) {
            RobotsResult robotsResult;
            SearchEngineFactor searchEngineFactor = websiteAuditorPage.getPopularityMap().getFactor((FactorType)SearchEngineFactorsList.ROBOTS_FACTOR_TYPE);
            if (searchEngineFactor == null && n2 == 0 || (robotsResult = (RobotsResult)searchEngineFactor.getFactorValue()) == null && n2 == 0) continue;
            RobotsResult.RobotsValue robotsValue = robotsResult.getStatus();
            if (robotsValue == RobotsResult.RobotsValue.DISALLOW || robotsValue == RobotsResult.RobotsValue.PARTIALLY_DISALLOW) {
                arrayList.add(websiteAuditorPage);
                if (robotsValue == RobotsResult.RobotsValue.DISALLOW) {
                    ++n3;
                }
            }
            if (n2 == 0) continue;
        }
        return new PagesAuditResult(this.a(list.size(), arrayList.size(), n3), arrayList);
    }

    private AuditStatusType a(int n2, int n3, int n4) {
        if (n3 == 0) {
            return AuditStatusType.OK;
        }
        if (n2 == n4) {
            return AuditStatusType.ERROR;
        }
        if (100.0 / (double)n2 * (double)n4 > 90.0) {
            return AuditStatusType.WARNING;
        }
        return AuditStatusType.INFO;
    }
}

