/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.Util;

public final class CssCascadingOrder {
    ArrayList<CssProperty> propertyData;
    int propertyCount;

    public CssProperty order(CssProperty property, StyleSheet style, CssSelectors selector) {
        CssStyle s;
        this.propertyData = new ArrayList();
        CssProperty newProp = property;
        Util.verbose("CASCADING ORDER " + property.getPropertyName() + " in " + selector);
        for (CssSelectors context : style.getRules().values()) {
            Util.verbose("######## test with " + context + " and " + selector);
            if (!context.canApply(selector)) continue;
            CssProperty prop = property.getPropertyInStyle(context.getStyle(), false);
            Util.verbose("%%%%%%%%%%%%%%%%% Found " + context);
            if (prop == null) continue;
            this.addProperty(prop);
        }
        if (this.propertyData.isEmpty()) {
            if (selector.getNext() != null && property.inherited()) {
                Util.verbose("Found nothing ... try the next " + selector.getNext());
                s = style.getStyle(selector.getNext());
                newProp = property.getPropertyInStyle(s, true);
            }
        } else {
            Util.verbose("@@@@@@@@@@@@@@ FOUND " + this.propertyData.size() + " properties");
            newProp = this.getProperty(selector);
            if (property.isSoftlyInherited() && selector.getNext() != null) {
                s = style.getStyle(selector.getNext());
                newProp = property.getPropertyInStyle(s, true);
            }
        }
        newProp = newProp.duplicate();
        newProp.setSelectors(selector);
        return newProp;
    }

    private CssProperty getProperty(CssSelectors selector) {
        int end;
        int propertyCount = this.propertyData.size();
        if (propertyCount == 1) {
            return this.propertyData.get(0);
        }
        CssProperty[] propertyArray = new CssProperty[propertyCount];
        this.propertyData.toArray(propertyArray);
        Arrays.sort(propertyArray, 0, propertyCount, new CompareExplicitWeight());
        int old = propertyArray[0].getExplicitWeight();
        for (end = 0; end < propertyCount && propertyArray[end].getExplicitWeight() == old; ++end) {
        }
        Arrays.sort(propertyArray, 0, end, new CompareSpecificity());
        old = propertyArray[0].getSelectors().getSpecificity();
        for (end = 0; end < propertyCount && propertyArray[end].getSelectors().getSpecificity() == old; ++end) {
        }
        Arrays.sort(propertyArray, 0, end, new CompareOrderSpecified());
        return propertyArray[0];
    }

    private void addProperty(CssProperty property) {
        this.propertyData.add(property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompareOrderSpecified
    implements Comparator<CssProperty> {
        CompareOrderSpecified() {
        }

        @Override
        public final int compare(CssProperty property1, CssProperty property2) {
            long val1 = property1.getOrderSpecified();
            long val2 = property2.getOrderSpecified();
            return (int)(val1 - val2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompareSpecificity
    implements Comparator<CssProperty> {
        CompareSpecificity() {
        }

        @Override
        public final int compare(CssProperty property1, CssProperty property2) {
            int val1 = property1.getSelectors().getSpecificity();
            int val2 = property2.getSelectors().getSpecificity();
            return val1 - val2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompareExplicitWeight
    implements Comparator<CssProperty> {
        CompareExplicitWeight() {
        }

        @Override
        public final int compare(CssProperty property1, CssProperty property2) {
            int val1 = property1.getExplicitWeight();
            int val2 = property2.getExplicitWeight();
            return val1 - val2;
        }
    }
}

