/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssStyleRule {
    private String indent;
    private String selectors;
    private ArrayList<CssProperty> properties;

    public CssStyleRule(String indent, String selectors, ArrayList<CssProperty> properties, boolean important) {
        this.selectors = selectors;
        this.properties = properties;
        this.indent = indent;
    }

    public String getSelectors() {
        return this.selectors;
    }

    public String getSelectorsEscaped() {
        return Messages.escapeString(this.selectors);
    }

    public ArrayList<CssProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.selectors != null) {
            ret.append(this.selectors);
            ret.append(" {\n");
        }
        for (CssProperty property : this.properties) {
            ret.append(this.indent);
            ret.append("   ");
            ret.append(property.getPropertyName());
            ret.append(" : ");
            ret.append(property.toString());
            if (property.getImportant()) {
                ret.append(" !important");
            }
            ret.append(";\n");
        }
        if (this.selectors != null) {
            ret.append(this.indent);
            ret.append("}\n\n");
        }
        return ret.toString();
    }

    public String toStringEscaped() {
        return Messages.escapeString(this.toString());
    }
}

