/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.util.UnicodeURL;
import java.io.IOException;
import java.io.Reader;
import org.w3c.css.css.HTMLParserStyleSheetHandler;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.css.XMLStyleSheetHandler;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.Util;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public final class DocumentParser {
    public static MimeType wap;
    private StyleSheet style;
    private UnicodeURL htmlURL;
    private Exception exception;
    private ApplContext ac;

    public DocumentParser(ApplContext ac, Reader reader) throws Exception {
        this(ac, reader, "urn:unknown", null);
    }

    public DocumentParser(ApplContext ac, Reader reader, String urlString, MimeType mediatype) throws Exception {
        this.htmlURL = HTTPURL.getURL(urlString);
        this.ac = ac;
        String media = ac.getMedium();
        if (mediatype == null) {
            mediatype = MimeType.TEXT_CSS;
        }
        if (mediatype.match(MimeType.TEXT_CSS) == 4) {
            StyleSheetParser csshandler = new StyleSheetParser();
            csshandler.parseStyleSheet(ac, reader, this.htmlURL);
            this.style = csshandler.getStyleSheet();
        } else if (mediatype.match(MimeType.TEXT_HTML) == 4) {
            HTMLParserStyleSheetHandler htmlhandler = new HTMLParserStyleSheetHandler(this.htmlURL, ac);
            htmlhandler.parse(reader);
            this.style = htmlhandler.getStyleSheet();
            if (this.style != null) {
                this.style.setType("text/html");
            }
        } else if (mediatype.toString().endsWith("+xml") || mediatype.match(MimeType.APPLICATION_XML) == 4) {
            XMLStyleSheetHandler xmlhandler = new XMLStyleSheetHandler(this.htmlURL, ac);
            xmlhandler.parse(reader);
            this.style = xmlhandler.getStyleSheet();
            if (this.style != null) {
                this.style.setType("text/xml");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DocumentParser(ApplContext ac, String urlString) throws Exception {
        String cType;
        this.htmlURL = HTTPURL.getURL(urlString);
        this.ac = ac;
        urlString = this.htmlURL.toString();
        String urlLower = urlString.toLowerCase();
        String media = ac.getMedium();
        String urlProtocol = this.htmlURL.getProtocol();
        if (!"http".equals(urlProtocol) && !"https".equals(urlProtocol)) {
            if (urlLower.endsWith(".css")) {
                StyleSheetParser parser = new StyleSheetParser();
                parser.parseURL(ac, this.htmlURL, null, null, media, 3);
                this.style = parser.getStyleSheet();
                return;
            } else if (urlLower.endsWith(".html") || urlLower.endsWith(".htm") || urlLower.endsWith(".shtml") || urlLower.endsWith("/")) {
                HTMLParserStyleSheetHandler handler = new HTMLParserStyleSheetHandler(this.htmlURL, ac);
                handler.parse(this.htmlURL);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/html");
                return;
            } else {
                if (!urlLower.endsWith(".xhtml") && !urlLower.endsWith(".xml")) throw new Exception("Unknown file");
                XMLStyleSheetHandler handler = new XMLStyleSheetHandler(this.htmlURL, ac);
                handler.parse(this.htmlURL);
                this.style = handler.getStyleSheet();
                if (this.style == null) return;
                this.style.setType("text/xml");
            }
            return;
        }
        PageReaderContent content = null;
        boolean isXML = false;
        String credential = ac.getCredential();
        content = HTTPURL.getPageReaderContent(this.htmlURL, ac);
        this.htmlURL = content.getRequestURL();
        String httpCL = (String)content.getParams().get("Content-Location");
        if (httpCL != null) {
            this.htmlURL = HTTPURL.getURL(this.htmlURL.getIDNURL(), httpCL);
        }
        if ((cType = content.getContentType()) == null) {
            cType = "unknown/unknown";
        }
        MimeType contentType = null;
        try {
            contentType = new MimeType(cType);
        }
        catch (MimeTypeFormatException ex) {
            contentType = MimeType.TEXT_HTML;
        }
        if (Util.onDebug) {
            System.err.println("[DEBUG] content type is [" + contentType + ']');
        }
        if (contentType.match(MimeType.TEXT_HTML) == 4) {
            HTMLParserStyleSheetHandler handler = new HTMLParserStyleSheetHandler(this.htmlURL, ac);
            handler.parse(urlString, content);
            this.style = handler.getStyleSheet();
            if (this.style == null) return;
            this.style.setType("text/html");
            return;
        } else if (contentType.match(MimeType.TEXT_CSS) == 4) {
            StyleSheetParser parser = new StyleSheetParser();
            parser.parseURL(ac, this.htmlURL, null, null, media, 3);
            this.style = parser.getStyleSheet();
            return;
        } else {
            if (contentType.match(MimeType.TEXT_XML) != 4 && contentType.match(MimeType.APPLICATION_XHTML_XML) != 4 && contentType.match(wap) != 4) throw new IOException("Unknown mime type : " + contentType);
            XMLStyleSheetHandler handler = new XMLStyleSheetHandler(this.htmlURL, ac);
            handler.parse(urlString, content);
            this.style = handler.getStyleSheet();
            if (this.style == null) return;
            this.style.setType("text/xml");
            return;
        }
    }

    public StyleSheet getStyleSheet() {
        return this.style;
    }

    static {
        try {
            wap = new MimeType("application/vnd.wap.xhtml+xml");
        }
        catch (MimeTypeFormatException mex) {
            wap = null;
        }
    }
}

