/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.w3c.css.css.CssCascadingOrder;
import org.w3c.css.css.CssRuleList;
import org.w3c.css.css.CssStyleRule;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Warnings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet {
    private CssCascadingOrder cascading;
    private HashMap<String, CssSelectors> rules;
    private Errors errors;
    private Warnings warnings;
    private String type;
    private ArrayList<CssRuleList> atRuleList;
    private boolean doNotAddRule;
    private boolean doNotAddAtRule;
    private static final boolean debug = false;
    String selectortext;
    boolean important;
    ArrayList<CssProperty> properties;
    String indent = new String();
    public String charset;

    public StyleSheet() {
        this.rules = new HashMap();
        this.errors = new Errors();
        this.warnings = new Warnings();
        this.cascading = new CssCascadingOrder();
        this.atRuleList = new ArrayList();
    }

    public void setWarningLevel(int warningLevel) {
        this.warnings.setWarningLevel(warningLevel);
    }

    public CssStyle getStyle(CssSelectors context) {
        if (this.getContext(context) != null) {
            CssSelectors realContext = this.getContext(context);
            CssStyle style = realContext.getStyle();
            style.setStyleSheet(this);
            style.setSelector(realContext);
            return style;
        }
        this.rules.put(context.toString(), context);
        context.getStyle().setStyleSheet(this);
        context.getStyle().setSelector(context);
        return context.getStyle();
    }

    public void addProperty(CssSelectors selector, CssProperty property) {
        this.getContext(selector).addProperty(property, this.warnings);
    }

    public void remove(CssSelectors selector) {
        this.rules.remove(selector);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            return "text/css";
        }
        return this.type;
    }

    public void addErrors(Errors errors) {
        if (errors.getErrorCount() != 0) {
            this.getErrors().addErrors(errors);
        }
    }

    public void addWarnings(Warnings warnings) {
        if (warnings.getWarningCount() != 0) {
            this.getWarnings().addWarnings(warnings);
        }
    }

    public final Errors getErrors() {
        return this.errors;
    }

    public final Warnings getWarnings() {
        return this.warnings;
    }

    public final HashMap<String, CssSelectors> getRules() {
        return this.rules;
    }

    public final CssProperty CascadingOrder(CssProperty property, StyleSheet style, CssSelectors selector) {
        return this.cascading.order(property, style, selector);
    }

    public void findConflicts(ApplContext ac) {
        HashMap<String, CssSelectors> rules = this.getRules();
        Object[] all = new CssSelectors[rules.size()];
        all = rules.values().toArray(all);
        Arrays.sort(all);
        for (Object selector : all) {
            ((CssSelectors)selector).markAsFinal();
        }
        for (Object selector : all) {
            ((CssSelectors)selector).findConflicts(ac, this.warnings, (CssSelectors[])all);
        }
    }

    protected CssSelectors getContext(CssSelectors selector) {
        if (this.rules.containsKey(selector.toString())) {
            return this.rules.get(selector.toString());
        }
        if (selector.getNext() != null) {
            CssSelectors next = this.getContext(selector.getNext());
            selector.setNext(next);
        }
        this.rules.put(selector.toString(), selector);
        return selector;
    }

    public void addCharSet(String charset) {
        this.charset = charset;
    }

    public void newAtRule(AtRule atRule) {
        CssRuleList rulelist = new CssRuleList();
        rulelist.addAtRule(atRule);
        this.atRuleList.add(rulelist);
        this.indent = "   ";
    }

    public void endOfAtRule() {
        if (!this.doNotAddAtRule) {
            CssRuleList rulelist = new CssRuleList();
            this.atRuleList.add(rulelist);
        }
        this.important = false;
        this.selectortext = "";
        this.indent = "";
        this.doNotAddAtRule = false;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public void setSelectorList(ArrayList<CssSelectors> selectors) {
        StringBuilder sb = new StringBuilder();
        for (CssSelectors s : selectors) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s.toString());
        }
        this.selectortext = sb.toString();
    }

    public void setProperty(ArrayList<CssProperty> properties) {
        this.properties = properties;
    }

    public void endOfRule() {
        if (!this.doNotAddRule) {
            CssStyleRule stylerule = new CssStyleRule(this.indent, this.selectortext, this.properties, this.important);
            CssRuleList rulelist = !this.atRuleList.isEmpty() ? this.atRuleList.remove(this.atRuleList.size() - 1) : new CssRuleList();
            rulelist.addStyleRule(stylerule);
            this.atRuleList.add(rulelist);
        }
        this.selectortext = "";
        this.doNotAddRule = false;
    }

    public void removeThisRule() {
        this.doNotAddRule = true;
    }

    public void removeThisAtRule() {
        this.doNotAddAtRule = true;
    }

    public ArrayList<CssRuleList> newGetRules() {
        return this.atRuleList;
    }
}

