/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.w3c.css.media.AtRuleMedia;
import org.w3c.css.media.Media;
import org.w3c.css.media.MediaFeature;
import org.w3c.css.parser.AtRule;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.WarningParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssPropertyFactory
implements Cloneable {
    private Utf8Properties properties;
    private static String[] SORTEDPROFILES = PropertiesLoader.getProfiles();

    public CssPropertyFactory getClone() {
        try {
            return (CssPropertyFactory)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public CssPropertyFactory(String profile) {
        this.properties = PropertiesLoader.getProfile(profile);
        if (this.properties == null) {
            throw new NullPointerException();
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private ArrayList<String> getMediaList(String media) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(media, ",");
        while (tok.hasMoreTokens()) {
            String medium = tok.nextToken();
            medium = medium.trim();
            list.add(medium);
        }
        return list;
    }

    public synchronized MediaFeature createMediaFeature(ApplContext ac, AtRule atRule, String feature, CssExpression expression) throws Exception {
        String classname;
        String modifier = null;
        int dashpos = feature.indexOf(45);
        feature = feature.toLowerCase();
        if (dashpos != -1) {
            if (dashpos == 0) {
                try {
                    AtRuleMedia atRuleMedia = (AtRuleMedia)atRule;
                    throw new InvalidParamException("noexistence-media", feature, atRuleMedia.getCurrentMedia(), ac);
                }
                catch (ClassCastException cce) {
                    throw new InvalidParamException("noexistence", feature, "not media @rule", ac);
                }
            }
            modifier = feature.substring(0, dashpos);
            if (modifier.equals("min") || modifier.equals("max")) {
                feature = feature.substring(dashpos + 1);
            } else {
                modifier = null;
            }
        }
        if ((classname = this.properties.getProperty("mediafeature." + feature.toLowerCase())) == null) {
            try {
                AtRuleMedia atRuleMedia = (AtRuleMedia)atRule;
                throw new InvalidParamException("noexistence-media", feature, atRuleMedia.getCurrentMedia(), ac);
            }
            catch (ClassCastException cce) {
                throw new InvalidParamException("noexistence", feature, "not media @rule", ac);
            }
        }
        try {
            Class expressionclass = CssExpression.class;
            if (expression != null) {
                expressionclass = expression.getClass();
            }
            Class[] parametersType = new Class[]{ac.getClass(), String.class, expressionclass};
            Constructor<?> constructor = Class.forName(classname).getConstructor(parametersType);
            Object[] parameters = new Object[]{ac, modifier, expression};
            return (MediaFeature)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Exception ex = (Exception)e.getTargetException();
            throw ex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized CssProperty createProperty(ApplContext ac, AtRule atRule, String property, CssExpression expression) throws Exception {
        String classname = null;
        String media = null;
        if (ac.getTreatVendorExtensionsAsWarnings()) {
            if (this.isVendorExtension(property)) {
                throw new WarningParamException("vendor-extension", property);
            }
            if (expression.hasVendorExtensions()) {
                throw new WarningParamException("vendor-extension", expression.toStringFromStart());
            }
        }
        try {
            AtRuleMedia atRuleMedia = (AtRuleMedia)atRule;
            for (Media m : atRuleMedia.getMediaList()) {
                if (m.getNot()) continue;
                media = m.getMedia();
                break;
            }
        }
        catch (ClassCastException cce) {
            media = "all";
        }
        classname = this.setClassName(atRule, media, ac, property);
        if (classname == null) {
            ArrayList<String> pfsOk = new ArrayList<String>();
            String spec = ac.getPropertyKey();
            for (String p : SORTEDPROFILES) {
                if (p.equals(spec) || !PropertiesLoader.getProfile(p).containsKey(property)) continue;
                pfsOk.add(p);
            }
            if (pfsOk.size() <= 0) throw new InvalidParamException("noexistence-at-all", property, ac);
            if (ac.getCssProfile() != CssProfile.NONE) throw new InvalidParamException("noexistence", new String[]{property, ac.getMsg().getString(ac.getPropertyKey()), pfsOk.toString()}, ac);
            String latestVersion = (String)pfsOk.get(pfsOk.size() - 1);
            CssVersion v = CssVersion.resolve(ac, latestVersion);
            if (v.compareTo(ac.getCssVersion()) > 0) {
                ac.getFrame().addWarning("noexistence", new String[]{property, ac.getMsg().getString(ac.getPropertyKey()), pfsOk.toString()});
                ac.setCssVersion(v);
            }
            classname = this.setClassName(atRule, media, ac, property);
        }
        CssIdent initial = CssIdent.getIdent("initial");
        try {
            Object[] parameters;
            Constructor<?> constructor;
            Class[] parametersType;
            if (ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0 && expression.getCount() == 1 && expression.getValue().equals(initial)) {
                parametersType = new Class[]{};
                constructor = Class.forName(classname).getConstructor(parametersType);
                parameters = new Object[]{};
                return (CssProperty)constructor.newInstance(parameters);
            }
            parametersType = new Class[]{ac.getClass(), expression.getClass(), Boolean.TYPE};
            constructor = Class.forName(classname).getConstructor(parametersType);
            parameters = new Object[]{ac, expression, Boolean.TRUE};
            return (CssProperty)constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Exception ex = (Exception)e.getTargetException();
            throw ex;
        }
    }

    private String setClassName(AtRule atRule, String media, ApplContext ac, String property) {
        String className;
        String prefix = atRule.lookupPrefix();
        if (prefix.length() == 0 || atRule instanceof AtRuleMedia) {
            className = PropertiesLoader.getProfile(ac.getPropertyKey()).getProperty(property);
            if (className != null && media != null && !media.equals("all")) {
                String propMedia = PropertiesLoader.mediaProperties.getProperty(property);
                if (propMedia == null) {
                    return className;
                }
                ArrayList<String> list = this.getMediaList(media);
                for (String medium : list) {
                    if (propMedia.indexOf(medium.toLowerCase()) != -1 || propMedia.equals("all")) continue;
                    ac.getFrame().addWarning("noexistence-media", new String[]{property, medium + " (" + propMedia + ")"});
                }
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('@').append(atRule.keyword()).append('.').append(property);
            className = PropertiesLoader.getProfile(ac.getPropertyKey()).getProperty(sb.toString());
        }
        return className;
    }

    private boolean isVendorExtension(String property) {
        return property.length() > 0 && (property.charAt(0) == '-' || property.charAt(0) == '_');
    }
}

