/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssBackground;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundPosition
extends CssProperty {
    private static final CssIdent center;
    private static final CssIdent top;
    private static final CssIdent bottom;
    private static final CssIdent left;
    private static final CssIdent right;
    private static final CssPercentage defaultPercent0;
    private static final CssPercentage defaultPercent50;
    private static final CssPercentage defaultPercent100;
    public CssValue value;

    public CssBackgroundPosition() {
        this.value = new CssBackgroundPositionValue();
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", ac);
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.value;
    }

    public final String getPropertyName() {
        return "background-position";
    }

    public boolean isSoftlyInherited() {
        return inherit == this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackground cssBackground = ((Css1Style)style).cssBackground;
        if (cssBackground.position != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.position = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundPosition();
        }
        return ((Css1Style)style).cssBackground.position;
    }

    public boolean equals(CssProperty property) {
        return property != null && property instanceof CssBackgroundPosition && this.value.equals(((CssBackgroundPosition)property).value);
    }

    public boolean isDefault() {
        return false;
    }

    public static CssPercentage identToPercent(CssIdent ident) {
        if (center.equals(ident)) {
            return defaultPercent50;
        }
        if (top.equals(ident) || left.equals(ident)) {
            return defaultPercent0;
        }
        if (bottom.equals(ident) || right.equals(ident)) {
            return defaultPercent100;
        }
        return defaultPercent0;
    }

    public static boolean isHorizontal(CssIdent ident) {
        return left.equals(ident) || right.equals(ident);
    }

    public static boolean isVertical(CssIdent ident) {
        return top.equals(ident) || bottom.equals(ident);
    }

    static /* synthetic */ CssPercentage access$000() {
        return defaultPercent0;
    }

    static {
        top = CssIdent.getIdent("top");
        bottom = CssIdent.getIdent("bottom");
        left = CssIdent.getIdent("left");
        right = CssIdent.getIdent("right");
        center = CssIdent.getIdent("center");
        defaultPercent0 = new CssPercentage(0);
        defaultPercent50 = new CssPercentage(50);
        defaultPercent100 = new CssPercentage(100);
    }

    public class CssBackgroundPositionValue
    extends CssValueList {
        public CssValue vertical = null;
        public CssValue horizontal = null;
        public CssValue vertical_offset = null;
        public CssValue horizontal_offset = null;
        public CssValue val_vertical = CssBackgroundPosition.access$000();
        public CssValue val_horizontal = CssBackgroundPosition.access$000();

        public boolean equals(CssBackgroundPositionValue v) {
            if (!this.val_vertical.equals(v.val_vertical)) {
                return false;
            }
            if (this.vertical_offset != null ? !this.vertical_offset.equals(v.vertical_offset) : v.vertical_offset != null) {
                return false;
            }
            if (!this.val_horizontal.equals(v.val_horizontal)) {
                return false;
            }
            return !(this.horizontal_offset != null ? !this.horizontal_offset.equals(v.horizontal_offset) : v.horizontal_offset != null);
        }
    }
}

