/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css21;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssVoiceFamily
extends org.w3c.css.properties.css.CssVoiceFamily {
    public static final CssIdent[] genericVoices;

    static CssIdent getGenericVoiceName(CssIdent ident) {
        for (CssIdent id : genericVoices) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssVoiceFamily() {
    }

    public CssVoiceFamily(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            char op = expression.getOperator();
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 1: {
                    String s = val.toString();
                    values.add(val);
                    break;
                }
                case 0: {
                    ArrayList<CssIdent> idval = new ArrayList<CssIdent>();
                    idval.add((CssIdent)val);
                    while (op == ' ' && expression.getRemainingCount() > 1) {
                        expression.next();
                        op = expression.getOperator();
                        val = expression.getValue();
                        if (val.getType() == 0) {
                            idval.add((CssIdent)val);
                            continue;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    this.checkExpression(ac, values, idval, check2);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        this.value = values.size() > 1 ? new CssLayerList(values) : (CssValue)values.get(0);
        this.checkValues(ac, values);
    }

    public CssVoiceFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private void checkExpression(ApplContext ac, ArrayList<CssValue> curval, ArrayList<CssIdent> values, boolean check2) {
        CssIdent val;
        if (values.size() > 1) {
            StringBuilder sb = new StringBuilder();
            boolean addSpace = false;
            for (CssIdent id : values) {
                if (addSpace) {
                    sb.append(' ');
                } else {
                    addSpace = true;
                }
                sb.append(id);
            }
            ac.getFrame().addWarning("with-space", 1);
            val = new CssIdent(sb.toString());
        } else {
            val = values.get(0);
            if (null != CssVoiceFamily.getGenericVoiceName(val)) {
                this.hasGenericVoiceFamily = true;
            }
            if (inherit.equals(val)) {
                val = inherit;
            }
        }
        curval.add(val);
    }

    private void checkValues(ApplContext ac, ArrayList<CssValue> values) throws InvalidParamException {
        if (values.size() > 1) {
            for (CssValue val : values) {
                if (!inherit.equals(val)) continue;
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        if (inherit != this.value && !this.hasGenericVoiceFamily) {
            ac.getFrame().addWarning("no-generic-family", this.getPropertyName());
        }
    }

    static {
        String[] _genericVoices = new String[]{"male", "female", "child"};
        genericVoices = new CssIdent[_genericVoices.length];
        int i = 0;
        for (String s : _genericVoices) {
            CssVoiceFamily.genericVoices[i++] = CssIdent.getIdent(s);
        }
    }
}

