/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssAzimuth
extends org.w3c.css.properties.css.CssAzimuth {
    CssIdent identValue;
    CssAngle angleValue;
    boolean isBehind;
    private static int[] hash_values;
    private static final String[] azValues;
    private static CssIdent behind;
    private static CssIdent leftwards;
    private static CssIdent rightwards;
    private static CssIdent[] singleValues;

    public CssAzimuth() {
        this.identValue = initial;
    }

    private boolean checkIdent(CssIdent ident) {
        int hash = ident.hashCode();
        for (int azHash : hash_values) {
            if (azHash != hash) continue;
            return true;
        }
        return false;
    }

    public CssAzimuth(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        this.setByUser();
        ac.getFrame().addWarning("deprecatedproperty", this.getPropertyName());
        switch (val.getType()) {
            case 5: 
            case 7: {
                if (check2 && expression.getCount() > 1) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                this.angleValue = val.getAngle();
                expression.next();
                break;
            }
            case 0: {
                int count = expression.getCount();
                CssIdent ident = (CssIdent)val;
                char op = expression.getOperator();
                for (CssIdent singleId : singleValues) {
                    if (!singleId.equals(ident)) continue;
                    if (count > 1 && check2) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.identValue = singleId;
                    expression.next();
                    return;
                }
                if (behind.equals(ident)) {
                    this.isBehind = true;
                } else if (this.checkIdent(ident)) {
                    this.identValue = ident;
                } else {
                    throw new InvalidParamException("unrecognize", ac);
                }
                expression.next();
                if (expression.getCount() <= 1) break;
                val = expression.getValue();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val, ac);
                }
                ident = (CssIdent)val;
                if (op != ' ') {
                    throw new InvalidParamException("operator", val, this.getPropertyName(), ac);
                }
                if (behind.equals(ident)) {
                    if (this.isBehind) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.isBehind = true;
                    expression.next();
                } else if (this.checkIdent(ident)) {
                    if (!this.isBehind) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.identValue = ident;
                } else {
                    throw new InvalidParamException("unrecognize", ac);
                }
                expression.next();
                break;
            }
            default: {
                throw new InvalidParamException("value", val, ac);
            }
        }
    }

    public CssAzimuth(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        if (this.identValue != null) {
            return this.identValue;
        }
        return this.angleValue;
    }

    public boolean isSoftlyInherited() {
        return inherit.equals(this.identValue);
    }

    public String toString() {
        if (this.isBehind) {
            StringBuilder sb = new StringBuilder();
            sb.append(behind);
            if (this.identValue != null) {
                sb.append(' ').append(this.identValue);
            }
            return sb.toString();
        }
        if (this.identValue != null) {
            return this.identValue.toString();
        }
        return this.angleValue.toString();
    }

    public boolean equals(CssProperty property) {
        try {
            CssAzimuth other = (CssAzimuth)property;
            return other.isBehind == this.isBehind && (this.identValue != null && this.identValue.equals(other.identValue) || this.identValue == null && other.identValue == null) && (this.angleValue != null && this.angleValue.equals(other.angleValue) || this.angleValue == null && other.angleValue == null);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    static {
        azValues = new String[]{"left-side", "far-left", "left", "center-left", "center", "center-right", "right", "far-right", "right-side"};
        hash_values = new int[azValues.length];
        for (int i = 0; i < azValues.length; ++i) {
            CssAzimuth.hash_values[i] = azValues[i].hashCode();
        }
        behind = new CssIdent("behind");
        leftwards = new CssIdent("leftwards");
        rightwards = new CssIdent("rightwards");
        singleValues = new CssIdent[3];
        CssAzimuth.singleValues[0] = inherit;
        CssAzimuth.singleValues[1] = leftwards;
        CssAzimuth.singleValues[2] = rightwards;
    }
}

