/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssBackgroundPosition;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackgroundPosition
extends org.w3c.css.properties.css.CssBackgroundPosition {
    public static CssIdent[] allowed_values;
    public static CssIdent center;
    public static CssIdent top;
    public static CssIdent bottom;
    public static CssIdent left;
    public static CssIdent right;
    private static CssPercentage defaultPercent0;
    private static CssPercentage defaultPercent50;
    private static CssPercentage defaultPercent100;

    public static boolean isMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return true;
        }
        return false;
    }

    public static CssIdent getMatchingIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssBackgroundPosition() {
        this.value = new CssBackgroundPosition.CssBackgroundPositionValue();
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValueList b_val = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (b_val == null) {
                b_val = new CssBackgroundPosition.CssBackgroundPositionValue();
            }
            b_val.add(val);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                this.check((CssBackgroundPosition.CssBackgroundPositionValue)b_val, ac);
                values.add(b_val);
                b_val = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (b_val != null) {
            this.check((CssBackgroundPosition.CssBackgroundPositionValue)b_val, ac);
            values.add(b_val);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    public CssBackgroundPosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public boolean isDefault() {
        if (!(this.value instanceof CssBackgroundPosition.CssBackgroundPositionValue)) {
            return false;
        }
        CssBackgroundPosition.CssBackgroundPositionValue v = (CssBackgroundPosition.CssBackgroundPositionValue)this.value;
        return v.val_vertical == defaultPercent0 && v.val_horizontal == defaultPercent0 && v.vertical_offset == null && v.horizontal_offset == null;
    }

    public void check(CssBackgroundPosition.CssBackgroundPositionValue v, ApplContext ac) throws InvalidParamException {
        int nb_keyword = 0;
        int nb_percentage = 0;
        int nb_length = 0;
        int nb_values = v.value.size();
        if (nb_values > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block23: for (CssValue aValue : v.value) {
            switch (aValue.getType()) {
                case 5: {
                    CssLength l = aValue.getLength();
                }
                case 6: {
                    ++nb_length;
                    continue block23;
                }
                case 4: {
                    ++nb_percentage;
                    continue block23;
                }
                case 0: {
                    ++nb_keyword;
                    continue block23;
                }
            }
            throw new InvalidParamException("unrecognize", aValue, ac);
        }
        if (nb_keyword > 2 || nb_length > 2 || nb_percentage > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        block6 : switch (nb_keyword) {
            case 0: {
                switch (nb_values) {
                    case 1: {
                        v.horizontal = (CssValue)v.value.get(0);
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        v.val_vertical = defaultPercent50;
                        break block6;
                    }
                    case 2: {
                        v.horizontal = (CssValue)v.value.get(0);
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        v.vertical = (CssValue)v.value.get(1);
                        if (v.vertical.getType() == 5) {
                            v.vertical = defaultPercent0;
                        }
                        v.val_vertical = v.vertical;
                        break block6;
                    }
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            case 1: {
                switch (nb_values) {
                    case 1: {
                        CssIdent ident = (CssIdent)v.value.get(0);
                        v.val_vertical = defaultPercent50;
                        v.val_horizontal = defaultPercent50;
                        ident = CssBackgroundPosition.getMatchingIdent(ident);
                        if (ident != null) {
                            if (CssBackgroundPosition.isVertical(ident)) {
                                v.vertical = ident;
                                v.val_vertical = CssBackgroundPosition.identToPercent(ident);
                                break block6;
                            }
                            v.horizontal = ident;
                            v.val_horizontal = CssBackgroundPosition.identToPercent(ident);
                            break block6;
                        }
                        throw new InvalidParamException("unrecognize", ident, this.getPropertyName(), ac);
                    }
                    case 2: {
                        CssIdent ident;
                        CssValue val0 = (CssValue)v.value.get(0);
                        if (val0.getType() == 0) {
                            ident = CssBackgroundPosition.getMatchingIdent((CssIdent)val0);
                            if (ident == null) {
                                throw new InvalidParamException("unrecognize", ident, this.getPropertyName(), ac);
                            }
                            if (CssBackgroundPosition.isVertical(ident)) {
                                throw new InvalidParamException("incompatible", ident, v.value.get(1), ac);
                            }
                            v.horizontal = ident;
                            v.val_horizontal = CssBackgroundPosition.identToPercent(ident);
                            v.vertical = (CssValue)v.value.get(1);
                            if (v.vertical.getType() == 5) {
                                v.vertical = defaultPercent0;
                            }
                            v.val_vertical = v.vertical;
                            break block6;
                        }
                        CssValue value1 = (CssValue)v.value.get(1);
                        if (value1.getType() != 0) {
                            throw new InvalidParamException("unrecognize", value1, this.getPropertyName(), ac);
                        }
                        ident = CssBackgroundPosition.getMatchingIdent((CssIdent)value1);
                        if (ident == null) {
                            throw new InvalidParamException("unrecognize", ident, this.getPropertyName(), ac);
                        }
                        if (CssBackgroundPosition.isHorizontal(ident)) {
                            throw new InvalidParamException("incompatible", val0, value1, ac);
                        }
                        v.vertical = ident;
                        v.val_vertical = CssBackgroundPosition.identToPercent(ident);
                        v.horizontal = val0;
                        if (v.horizontal.getType() == 5) {
                            v.horizontal = defaultPercent0;
                        }
                        v.val_horizontal = v.horizontal;
                        break block6;
                    }
                }
                throw new InvalidParamException("unrecognize", ac);
            }
            default: {
                boolean got_ident = false;
                CssIdent id1 = null;
                CssIdent id2 = null;
                CssValue off1 = null;
                CssValue off2 = null;
                for (CssValue aValue : v.value) {
                    switch (aValue.getType()) {
                        case 0: {
                            aValue = CssBackgroundPosition.getMatchingIdent((CssIdent)aValue);
                            if (aValue == null) {
                                throw new InvalidParamException("unrecognize", aValue, this.getPropertyName(), ac);
                            }
                            got_ident = true;
                            if (id1 == null) {
                                id1 = (CssIdent)aValue;
                                break;
                            }
                            id2 = (CssIdent)aValue;
                            if ((!CssBackgroundPosition.isVertical(id1) || !CssBackgroundPosition.isVertical(id2)) && (!CssBackgroundPosition.isHorizontal(id1) || !CssBackgroundPosition.isHorizontal(id2))) break;
                            throw new InvalidParamException("incompatible", id1, id2, ac);
                        }
                        case 5: {
                            aValue = aValue.getPercentage();
                        }
                        case 4: 
                        case 6: {
                            if (!got_ident) {
                                throw new InvalidParamException("unrecognize", aValue, this.getPropertyName(), ac);
                            }
                            if (id2 == null) {
                                off1 = aValue;
                            } else {
                                off2 = aValue;
                            }
                            got_ident = false;
                            break;
                        }
                    }
                }
                if (CssBackgroundPosition.isVertical(id1) || CssBackgroundPosition.isHorizontal(id2)) {
                    if (off1 != null && !CssBackgroundPosition.isVertical(id1) || off2 != null && !CssBackgroundPosition.isHorizontal(id2)) {
                        throw new InvalidParamException("incompatible", id1, id2, ac);
                    }
                    v.horizontal = id2;
                    v.val_horizontal = CssBackgroundPosition.identToPercent(id2);
                    v.horizontal_offset = off2;
                    v.vertical = id1;
                    v.val_vertical = CssBackgroundPosition.identToPercent(id1);
                    v.vertical_offset = off1;
                    break;
                }
                if (off2 != null && !CssBackgroundPosition.isVertical(id2) || off1 != null && !CssBackgroundPosition.isHorizontal(id1)) {
                    throw new InvalidParamException("incompatible", id1, id2, ac);
                }
                v.horizontal = id1;
                v.val_horizontal = CssBackgroundPosition.identToPercent(id1);
                v.horizontal_offset = off1;
                v.vertical = id2;
                v.val_vertical = CssBackgroundPosition.identToPercent(id2);
                v.vertical_offset = off2;
            }
        }
    }

    public static CssPercentage identToPercent(CssIdent ident) {
        if (center.equals(ident)) {
            return defaultPercent50;
        }
        if (top.equals(ident) || left.equals(ident)) {
            return defaultPercent0;
        }
        if (bottom.equals(ident) || right.equals(ident)) {
            return defaultPercent100;
        }
        return defaultPercent0;
    }

    public static boolean isHorizontal(CssIdent ident) {
        return left.equals(ident) || right.equals(ident);
    }

    public static boolean isVertical(CssIdent ident) {
        return top.equals(ident) || bottom.equals(ident);
    }

    public static CssValue checkSyntax(CssExpression expression, ApplContext ac, String caller) throws InvalidParamException {
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        int nb_values = expression.getCount();
        int nb_keyword = 0;
        int nb_percentage = 0;
        int nb_length = 0;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 5: {
                    CssLength l = val.getLength();
                }
                case 6: {
                    ++nb_length;
                    break;
                }
                case 4: {
                    ++nb_percentage;
                    break;
                }
                case 0: {
                    ++nb_keyword;
                    break;
                }
                default: {
                    throw new InvalidParamException("unrecognize", val, ac);
                }
            }
            v.add(val);
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        CssValueList ret = new CssValueList(v);
        if (nb_keyword > 2 || nb_length > 2 || nb_percentage > 2) {
            throw new InvalidParamException("value", ret, caller, ac);
        }
        block6 : switch (nb_keyword) {
            case 0: {
                if (nb_keyword <= 2) break;
                throw new InvalidParamException("value", ret, caller, ac);
            }
            case 1: {
                switch (nb_values) {
                    case 1: {
                        if (CssBackgroundPosition.getMatchingIdent((CssIdent)v.get(0)) != null) break block6;
                        throw new InvalidParamException("value", v.get(0), caller, ac);
                    }
                    case 2: {
                        CssValue val0 = v.get(0);
                        if (val0.getType() == 0) {
                            CssIdent ident = CssBackgroundPosition.getMatchingIdent((CssIdent)val0);
                            if (ident == null) {
                                throw new InvalidParamException("value", val0, caller, ac);
                            }
                            if (!CssBackgroundPosition.isVertical(ident)) break block6;
                            throw new InvalidParamException("incompatible", ident, v.get(1), ac);
                        }
                        CssValue value1 = v.get(1);
                        if (value1.getType() != 0) {
                            throw new InvalidParamException("value", value1, caller, ac);
                        }
                        CssIdent ident = CssBackgroundPosition.getMatchingIdent((CssIdent)value1);
                        if (ident == null) {
                            throw new InvalidParamException("value", value1, caller, ac);
                        }
                        if (!CssBackgroundPosition.isHorizontal(ident)) break block6;
                        throw new InvalidParamException("incompatible", val0, value1, ac);
                    }
                    default: {
                        throw new InvalidParamException("value", ret, caller, ac);
                    }
                }
            }
            default: {
                boolean got_ident = false;
                CssIdent id1 = null;
                CssIdent id2 = null;
                CssValue off1 = null;
                CssValue off2 = null;
                for (CssValue aValue : v) {
                    switch (aValue.getType()) {
                        case 0: {
                            if (CssBackgroundPosition.getMatchingIdent((CssIdent)aValue) == null) {
                                throw new InvalidParamException("value", aValue, caller, ac);
                            }
                            got_ident = true;
                            if (id1 == null) {
                                id1 = (CssIdent)aValue;
                                break;
                            }
                            id2 = (CssIdent)aValue;
                            if ((!CssBackgroundPosition.isVertical(id1) || !CssBackgroundPosition.isVertical(id2)) && (!CssBackgroundPosition.isHorizontal(id1) || !CssBackgroundPosition.isHorizontal(id2))) break;
                            throw new InvalidParamException("incompatible", id1, id2, ac);
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            if (!got_ident) {
                                throw new InvalidParamException("unrecognize", aValue, caller, ac);
                            }
                            if (id2 == null) {
                                off1 = aValue;
                            } else {
                                off2 = aValue;
                            }
                            got_ident = false;
                            break;
                        }
                    }
                }
                if (CssBackgroundPosition.isVertical(id1) || CssBackgroundPosition.isHorizontal(id2)) {
                    if ((off1 == null || CssBackgroundPosition.isVertical(id1)) && (off2 == null || CssBackgroundPosition.isHorizontal(id2))) break;
                    throw new InvalidParamException("incompatible", id1, id2, ac);
                }
                if ((off2 == null || CssBackgroundPosition.isVertical(id2)) && (off1 == null || CssBackgroundPosition.isHorizontal(id1))) break;
                throw new InvalidParamException("incompatible", id1, id2, ac);
            }
        }
        return ret;
    }

    static {
        top = CssIdent.getIdent("top");
        bottom = CssIdent.getIdent("bottom");
        left = CssIdent.getIdent("left");
        right = CssIdent.getIdent("right");
        center = CssIdent.getIdent("center");
        allowed_values = new CssIdent[5];
        CssBackgroundPosition.allowed_values[0] = top;
        CssBackgroundPosition.allowed_values[1] = bottom;
        CssBackgroundPosition.allowed_values[2] = left;
        CssBackgroundPosition.allowed_values[3] = right;
        CssBackgroundPosition.allowed_values[4] = center;
        defaultPercent0 = new CssPercentage(0);
        defaultPercent50 = new CssPercentage(50);
        defaultPercent100 = new CssPercentage(100);
    }
}

