/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssFlexDirection;
import org.w3c.css.properties.css3.CssFlexWrap;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFlexFlow
extends org.w3c.css.properties.css.CssFlexFlow {
    private CssFlexDirection flexDirection;
    private CssFlexWrap flexWrap;

    public CssFlexFlow() {
        this.value = initial;
        this.flexDirection = new CssFlexDirection();
        this.flexWrap = new CssFlexWrap();
    }

    public CssFlexFlow(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssIdent directionVal = null;
        CssIdent wrapVal = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 0: {
                    CssIdent ident = (CssIdent)val;
                    if (inherit.equals(ident)) {
                        this.value = inherit;
                        if (expression.getCount() <= 1) break;
                        throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                    }
                    if (directionVal == null && (directionVal = CssFlexDirection.getAllowedIdent(ident)) != null || wrapVal == null && (wrapVal = CssFlexWrap.getAllowedIdent(ident)) != null) break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            expression.next();
        }
        this.flexDirection = new CssFlexDirection();
        this.flexWrap = new CssFlexWrap();
        if (this.value == inherit) {
            this.flexDirection.value = inherit;
            this.flexWrap.value = inherit;
        } else {
            CssValueList v = new CssValueList();
            if (directionVal != null) {
                v.add(directionVal);
                this.flexDirection.value = directionVal;
            }
            if (wrapVal != null) {
                v.add(wrapVal);
                this.flexWrap.value = wrapVal;
            }
            this.value = v;
        }
    }

    public CssFlexFlow(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.flexDirection.addToStyle(ac, style);
        this.flexWrap.addToStyle(ac, style);
    }
}

