/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class CssOpacity
extends org.w3c.css.properties.css.CssOpacity {
    public CssOpacity() {
        this.value = initial;
    }

    public CssOpacity(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssValue val = expression.getValue();
        switch (val.getType()) {
            case 5: {
                CssNumber number = val.getNumber();
                number.setFloatValue(this.clampedValue(ac, number.getValue()));
                this.value = number;
                break;
            }
            case 0: {
                if (inherit.equals(val)) {
                    this.value = inherit;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssOpacity(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private float clampedValue(ApplContext ac, float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(opacity));
            return opacity < 0.0f ? 0.0f : 1.0f;
        }
        return opacity;
    }

    public boolean isDefault() {
        if (this.value.getType() == 5) {
            try {
                return this.value.getNumber().getValue() == 1.0f;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return this.value == initial;
    }
}

