/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.Css2Style;
import org.w3c.css.properties.css3.CssOverflowX;
import org.w3c.css.properties.css3.CssOverflowY;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssOverflow
extends org.w3c.css.properties.css.CssOverflow {
    CssOverflowX cssOverflowX;
    CssOverflowY cssOverflowY;
    public static final CssIdent[] allowed_values;

    public static final CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssOverflow() {
        this.value = initial;
        this.cssOverflowX = new CssOverflowX();
        this.cssOverflowY = new CssOverflowY();
    }

    public CssOverflow(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        this.cssOverflowX = new CssOverflowX();
        this.cssOverflowY = new CssOverflowY();
        switch (expression.getCount()) {
            case 1: {
                this.cssOverflowX.value = this.value = CssOverflow.checkOverflowAxis(ac, expression, check2, this);
                this.cssOverflowY.value = this.value;
                break;
            }
            case 2: {
                ArrayList<CssValue> v = new ArrayList<CssValue>();
                char op = expression.getOperator();
                CssValue val = CssOverflow.checkOverflowAxis(ac, expression, false, this);
                if (val == inherit) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                v.add(val);
                this.cssOverflowX.value = val;
                if (op != ' ') {
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                val = CssOverflow.checkOverflowAxis(ac, expression, false, this);
                if (val == inherit) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                v.add(val);
                this.cssOverflowY.value = val;
                this.value = new CssValueList(v);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
    }

    public CssOverflow(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((Css2Style)style).cssOverflow != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((Css2Style)style).cssOverflow = this;
        this.cssOverflowX.addToStyle(ac, style);
        this.cssOverflowY.addToStyle(ac, style);
    }

    static CssValue checkOverflowAxis(ApplContext ac, CssExpression expression, boolean check2, CssProperty caller) throws InvalidParamException {
        CssIdent value;
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val, caller.getPropertyName(), ac);
        }
        CssIdent id = (CssIdent)val;
        if (inherit.equals(id)) {
            value = inherit;
        } else {
            value = CssOverflow.getAllowedIdent(id);
            if (value == null) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        expression.next();
        return value;
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        this.cssOverflowX.setInfo(line, source);
        this.cssOverflowY.setInfo(line, source);
    }

    public void setImportant() {
        super.setImportant();
        this.cssOverflowX.setImportant();
        this.cssOverflowY.setImportant();
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        this.cssOverflowX.setSelectors(selector);
        this.cssOverflowY.setSelectors(selector);
    }

    static {
        String[] _allowed_values = new String[]{"visible", "hidden", "scroll", "auto", "no-display", "no-content"};
        int i = 0;
        allowed_values = new CssIdent[_allowed_values.length];
        for (String s : _allowed_values) {
            CssOverflow.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

