/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.properties.css3.CssTextEmphasisColor;
import org.w3c.css.properties.css3.CssTextEmphasisStyle;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextEmphasis
extends org.w3c.css.properties.css.CssTextEmphasis {
    CssTextEmphasisColor colorValue = new CssTextEmphasisColor();
    CssTextEmphasisStyle styleValue = new CssTextEmphasisStyle();

    public CssTextEmphasis() {
        this.value = initial;
    }

    public CssTextEmphasis(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        org.w3c.css.values.CssColor color = null;
        CssExpression styleExp = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 1: {
                    if (styleExp == null) {
                        styleExp = new CssExpression();
                    }
                    styleExp.addValue(val);
                    expression.next();
                    break;
                }
                case 0: {
                    CssIdent ident = (CssIdent)val;
                    if (inherit.equals(ident)) {
                        if (expression.getCount() > 1) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        this.value = inherit;
                        expression.next();
                        return;
                    }
                    CssIdent id = CssTextEmphasisStyle.getAllowedValue(ident);
                    if (id != null) {
                        if (styleExp == null) {
                            styleExp = new CssExpression();
                        }
                        styleExp.addValue(val);
                        expression.next();
                        break;
                    }
                }
                default: {
                    if (color != null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssColor c = new CssColor(ac, expression, false);
                    color = c.getColor();
                    if (styleExp == null || expression.getRemainingCount() == 0 || color == null) break;
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (styleExp != null) {
            this.styleValue = new CssTextEmphasisStyle(ac, styleExp, check2);
            this.value = this.styleValue.value;
        }
        if (color != null) {
            this.colorValue.value = color;
            if (styleExp == null) {
                this.value = color;
            } else {
                ArrayList<CssValue> v = new ArrayList<CssValue>(2);
                v.add(this.styleValue.value);
                v.add(color);
                this.value = new CssValueList(v);
            }
        }
    }

    public CssTextEmphasis(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.colorValue.addToStyle(ac, style);
        this.styleValue.addToStyle(ac, style);
    }
}

