/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.svg;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.svg.SVGBasicStyle;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class ColorInterpolation
extends CssProperty {
    CssValue interp;
    ApplContext ac;
    CssIdent auto = new CssIdent("auto");
    CssIdent sRGB = new CssIdent("sRGB");
    CssIdent linearRGB = new CssIdent("linearRGB");

    public ColorInterpolation() {
    }

    public ColorInterpolation(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.ac = ac;
        this.setByUser();
        CssValue val = expression.getValue();
        if (val.equals(inherit)) {
            this.interp = inherit;
            expression.next();
        } else if (val.equals(this.sRGB)) {
            this.interp = this.sRGB;
            expression.next();
        } else if (val.equals(this.linearRGB)) {
            this.interp = this.linearRGB;
            expression.next();
        } else if (val.equals(this.auto)) {
            this.interp = this.auto;
            expression.next();
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
    }

    public ColorInterpolation(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (((SVGBasicStyle)style).colorInterpolation != null) {
            style.addRedefinitionWarning(ac, this);
        }
        ((SVGBasicStyle)style).colorInterpolation = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((SVGBasicStyle)style).getColorInterpolation();
        }
        return ((SVGBasicStyle)style).colorInterpolation;
    }

    public boolean equals(CssProperty property) {
        return property instanceof ColorInterpolation && this.interp.equals(((ColorInterpolation)property).interp);
    }

    public String getPropertyName() {
        return "color-interpolation";
    }

    public Object get() {
        return this.interp;
    }

    public boolean isSoftlyInherited() {
        return this.interp.equals(inherit);
    }

    public String toString() {
        return this.interp.toString();
    }

    public boolean isDefault() {
        return this.interp == this.sRGB;
    }
}

