/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors;

import java.util.ArrayList;
import org.w3c.css.selectors.AdjacentSiblingSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.GeneralSiblingSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.PseudoClassSelector;
import org.w3c.css.selectors.PseudoElementSelector;
import org.w3c.css.selectors.PseudoFunctionSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorsList {
    private ArrayList<Selector> selectors;
    private ApplContext ac;
    private int specificity;
    private String stringrep = null;

    public SelectorsList() {
        this.selectors = new ArrayList();
    }

    public SelectorsList(ApplContext ac) {
        this.ac = ac;
        this.selectors = new ArrayList();
    }

    public ArrayList<Selector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(ArrayList<Selector> selectors) {
        this.selectors = selectors;
        this.stringrep = null;
    }

    public Selector getSelector(int index) {
        return this.selectors.get(index);
    }

    public int size() {
        return this.selectors.size();
    }

    public void addSelector(Selector selector) throws InvalidParamException {
        Selector last;
        if (this.selectors.size() > 0 && (last = this.selectors.get(this.selectors.size() - 1)) instanceof PseudoElementSelector) {
            throw new InvalidParamException("pseudo-element", selector, this.ac.getMsg().getString(this.ac.getCssVersionString()), this.ac);
        }
        this.selectors.add(selector);
        this.stringrep = null;
    }

    public void addAttribute(AttributeSelector attribute) throws InvalidParamException {
        this.addSelector(attribute);
    }

    public void addUniversal(UniversalSelector universal) throws InvalidParamException {
        this.addSelector(universal);
    }

    public void addType(TypeSelector type) throws InvalidParamException {
        this.addSelector(type);
    }

    public void addDescendant(DescendantSelector descendant) throws InvalidParamException {
        this.addSelector(descendant);
    }

    public void addChild(ChildSelector child) throws InvalidParamException {
        this.addSelector(child);
    }

    public void addPseudoClass(PseudoClassSelector pc) throws InvalidParamException {
        this.addSelector(pc);
    }

    public void addPseudoElement(PseudoElementSelector pe) throws InvalidParamException {
        this.addSelector(pe);
    }

    public void addPseudoFunction(PseudoFunctionSelector pf) throws InvalidParamException {
        this.addSelector(pf);
    }

    public void addAdjacentSibling(AdjacentSiblingSelector adjacent) throws InvalidParamException {
        this.addSelector(adjacent);
    }

    public void addGeneralSibling(GeneralSiblingSelector sibling) throws InvalidParamException {
        this.addSelector(sibling);
    }

    public void addClass(ClassSelector cs) throws InvalidParamException {
        this.addSelector(cs);
    }

    public void addId(IdSelector id) throws InvalidParamException {
        this.addSelector(id);
    }

    public String toString() {
        if (this.stringrep != null) {
            return this.stringrep;
        }
        StringBuilder res = new StringBuilder();
        for (Selector selector : this.selectors) {
            res.append(selector);
        }
        this.stringrep = res.toString();
        return this.stringrep;
    }

    public boolean isToStringCached() {
        return this.stringrep != null;
    }

    public String toStringEscaped() {
        return Messages.escapeString(this.toString());
    }

    public void setSpecificity(int specificity) {
        this.specificity = specificity;
    }

    public int getSpecificity() {
        int a = 0;
        int b = 0;
        int c = 0;
        for (int i = 0; i < this.size(); ++i) {
            Selector s = this.getSelector(i);
            if (s instanceof IdSelector) {
                ++a;
                continue;
            }
            if (s instanceof ClassSelector || s instanceof PseudoClassSelector) {
                ++b;
                continue;
            }
            if (s instanceof TypeSelector || s instanceof AttributeSelector) {
                ++c;
                continue;
            }
            if (!(s instanceof PseudoFunctionSelector)) continue;
            this.specificity += ((PseudoFunctionSelector)s).getSpecificity();
        }
        this.specificity += a * 100 + b * 10 + c;
        return this.specificity;
    }

    public static void main(String[] args) {
        SelectorsList s = new SelectorsList();
        try {
            s.addType(new TypeSelector("E"));
            s.addAttribute(new AttributeExact("foo", "warning"));
            s.addChild(new ChildSelector());
            s.addType(new TypeSelector("F"));
            s.addAttribute(new AttributeBegin("lang", "en"));
            s.addAttribute(new AttributeAny("bar"));
            s.addAdjacentSibling(new AdjacentSiblingSelector());
            s.addType(new TypeSelector("G"));
            s.addId(new IdSelector("id"));
            s.addAttribute(new AttributeAny("blop"));
            s.addDescendant(new DescendantSelector());
            s.addType(new TypeSelector("H"));
            System.out.println(s);
        }
        catch (InvalidParamException e) {
            System.err.println(e.getMessage());
        }
    }
}

