/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.util.ApplContext;

public class AttributeBegin
extends AttributeSelector {
    private String value;

    public AttributeBegin(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean canApply(Selector other) {
        if (other instanceof AttributeAny) {
            return true;
        }
        if (other instanceof AttributeExact) {
            String v = ((AttributeExact)other).getValue();
            int index = v.indexOf(45);
            if (index > 0) {
                v = v.substring(0, index);
            }
            return this.value.equals(v);
        }
        if (other instanceof AttributeOneOf) {
            return true;
        }
        if (other instanceof AttributeBegin) {
            return this.value.equals(((AttributeBegin)other).value);
        }
        return false;
    }

    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        String name = this.getName();
        if (name.equals(attr.getName())) {
            if (attr instanceof AttributeExact) {
                ((AttributeExact)attr).applyAttribute(ac, this);
            } else if (attr instanceof AttributeBegin) {
                String val = ((AttributeBegin)attr).getValue();
                if (!(val.equals(this.value) || this.value.startsWith(val + '-') || val.startsWith(this.value + '-'))) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeStart) {
                String val = ((AttributeStart)attr).getValue();
                if (!(val.equals(this.value) || this.value.startsWith(val) || val.startsWith(this.value + '-'))) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            } else if (attr instanceof AttributeOneOf) {
                ((AttributeOneOf)attr).applyAttribute(ac, this);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName()).append("|=\"").append(this.value).append("\"]");
        return sb.toString();
    }
}

