/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import com.agilemind.commons.io.pagereader.PageReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.css.parser.Frame;
import org.w3c.css.util.CssProfile;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.FakeFile;
import org.w3c.css.util.Messages;
import org.w3c.css.util.UnicodeInputStream;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptCharsetList;
import org.w3c.www.http.HttpFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplContext {
    public static Charset defaultCharset;
    public static Charset utf8Charset;
    private PageReader pageReader;
    private HashMap<URL, Charset> uricharsets = null;
    private HashMap<URL, HashMap<String, String>> namespaces = null;
    public static String defaultPrefix;
    public static String noPrefix;
    private ArrayList<URL> linkedmedia = new ArrayList();
    String credential = null;
    String lang;
    Messages msgs;
    Frame frame;
    CssVersion version = CssVersion.getDefault();
    CssProfile profile = CssProfile.NONE;
    String input;
    Class cssselectorstyle;
    int origin = -1;
    String medium;
    private String link;
    int warningLevel = 0;
    boolean treatVendorExtensionsAsWarnings = false;
    boolean followlinks = true;
    FakeFile fakefile = null;
    String faketext = null;
    URL fakeurl = null;
    URL referrer = null;

    public boolean followlinks() {
        return this.followlinks;
    }

    public void setFollowlinks(boolean followlinks) {
        this.followlinks = followlinks;
    }

    public ApplContext(String lang) {
        this.lang = lang;
        this.msgs = new Messages(lang);
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int warningLevel) {
        this.warningLevel = warningLevel;
    }

    public ArrayList<URL> getLinkedURIs() {
        return this.linkedmedia;
    }

    public void addLinkedURI(URL url) {
        if (url != null) {
            this.linkedmedia.add(url);
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        frame.ac = this;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Class getCssSelectorsStyle() {
        return this.cssselectorstyle;
    }

    public void setCssSelectorsStyle(Class s) {
        this.cssselectorstyle = s;
    }

    public Messages getMsg() {
        return this.msgs;
    }

    public String getContentType() {
        return this.msgs != null ? this.msgs.getString("content-type") : null;
    }

    public String getContentLanguage() {
        return this.msgs != null ? this.msgs.getString("content-language") : null;
    }

    public String getContentEncoding() {
        String res = null;
        if (this.msgs != null) {
            res = this.msgs.getString("content-encoding");
            if (res == null) {
                res = this.msgs.getString("output-encoding-name");
            }
            if (res != null) {
                return res;
            }
        }
        return "UTF-8";
    }

    public String getLang() {
        return this.lang;
    }

    public void setCssVersion(String cssversion) {
        this.version = CssVersion.resolve(this, cssversion);
    }

    public void setCssVersion(CssVersion version) {
        this.version = version;
    }

    public String getCssVersionString() {
        return this.version.toString();
    }

    public CssVersion getCssVersion() {
        return this.version;
    }

    public void setProfile(String profile) {
        this.profile = CssProfile.resolve(this, profile);
    }

    public String getPropertyKey() {
        if (this.profile != CssProfile.EMPTY && this.profile != CssProfile.NONE) {
            return this.profile.toString();
        }
        return this.version.toString();
    }

    public CssProfile getCssProfile() {
        return this.profile;
    }

    public String getProfileString() {
        return this.profile.toString();
    }

    public void setCssVersionAndProfile(String spec) {
        if (spec == null || spec.length() == 0) {
            this.version = CssVersion.getDefault();
            this.profile = CssProfile.EMPTY;
        } else {
            String low = spec.toLowerCase();
            this.version = CssVersion.resolve(this, low);
            this.profile = CssProfile.resolve(this, low);
            if (this.profile.equals((Object)CssProfile.ATSCTV)) {
                this.version = CssVersion.CSS2;
            }
        }
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public String getMedium() {
        return this.medium;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String queryString) {
        this.link = queryString;
    }

    public boolean getTreatVendorExtensionsAsWarnings() {
        return this.treatVendorExtensionsAsWarnings;
    }

    public void setTreatVendorExtensionsAsWarnings(boolean treatVendorExtensionsAsWarnings) {
        this.treatVendorExtensionsAsWarnings = treatVendorExtensionsAsWarnings;
    }

    public void setContentEncoding(String acceptCharset) {
        if (acceptCharset != null) {
            HttpAcceptCharsetList charsetList = HttpFactory.parseAcceptCharsetList((String)acceptCharset);
            HttpAcceptCharset[] charsets = (HttpAcceptCharset[])charsetList.getValue();
            String encoding = null;
            double quality = 0.0;
            String biasedcharset = this.getMsg().getString("output-encoding-name");
            for (int i = 0; i < charsets.length && quality < 1.0; ++i) {
                HttpAcceptCharset charset = charsets[i];
                String currentCharset = charset.getCharset();
                if (!this.isCharsetSupported(currentCharset)) continue;
                double currentQuality = charset.getQuality();
                if (biasedcharset != null && !biasedcharset.equalsIgnoreCase(currentCharset)) {
                    currentQuality *= 0.5;
                }
                if (!(currentQuality > quality)) continue;
                quality = currentQuality;
                encoding = charset.getCharset();
            }
            if (encoding != null) {
                this.getMsg().properties.setProperty("content-encoding", encoding);
            } else {
                this.getMsg().properties.remove("content-encoding");
            }
        } else {
            this.getMsg().properties.remove("content-encoding");
        }
    }

    private boolean isCharsetSupported(String charset) {
        if ("*".equals(charset)) {
            return true;
        }
        try {
            return Charset.isSupported(charset);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setCharsetForURL(URL url, String charset) {
        if (this.uricharsets == null) {
            this.uricharsets = new HashMap();
        }
        Charset c = null;
        try {
            c = Charset.forName(charset);
        }
        catch (IllegalCharsetNameException icex) {
        }
        catch (UnsupportedCharsetException ucex) {
            // empty catch block
        }
        if (c != null) {
            this.uricharsets.put(url, c);
        }
    }

    public void setCharsetForURL(URL url, Charset charset) {
        if (this.uricharsets == null) {
            this.uricharsets = new HashMap();
        }
        this.uricharsets.put(url, charset);
    }

    public String getCharsetForURL(URL url) {
        if (this.uricharsets == null) {
            return null;
        }
        Charset c = this.uricharsets.get(url);
        if (c != null) {
            return c.toString();
        }
        return null;
    }

    public Charset getCharsetObjForURL(URL url) {
        if (this.uricharsets == null) {
            return null;
        }
        return this.uricharsets.get(url);
    }

    public void setFakeFile(FakeFile fakefile) {
        this.fakefile = fakefile;
    }

    public void setFakeText(String faketext) {
        this.faketext = faketext;
    }

    public InputStream getFakeInputStream(URL source) throws IOException {
        InputStream is = null;
        if (this.fakefile != null) {
            is = this.fakefile.getInputStream();
        }
        if (this.faketext != null) {
            is = new ByteArrayInputStream(this.faketext.getBytes());
        }
        if (is == null) {
            return null;
        }
        Charset c = this.getCharsetObjForURL(source);
        if (c == null) {
            UnicodeInputStream uis = new UnicodeInputStream(is);
            String guessedCharset = uis.getEncodingFromStream();
            if (guessedCharset != null) {
                this.setCharsetForURL(source, guessedCharset);
            }
            return uis;
        }
        if (utf8Charset.compareTo(c) == 0) {
            return new UnicodeInputStream(is);
        }
        return is;
    }

    public boolean isInputFake() {
        return this.faketext != null || this.fakefile != null;
    }

    public void setFakeURL(String fakeurl) {
        try {
            this.fakeurl = new URL(fakeurl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL getFakeURL() {
        return this.fakeurl;
    }

    public void setNamespace(URL url, String prefix, String nsname) {
        HashMap<String, String> nsdefs;
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix == null || prefix.length() == 0) {
            prefix = defaultPrefix;
        }
        if ((nsdefs = this.namespaces.get(url)) == null) {
            nsdefs = new HashMap();
            nsdefs.put(prefix, nsname);
            this.namespaces.put(url, nsdefs);
        } else {
            nsdefs.put(prefix, nsname);
        }
    }

    public boolean isNamespaceDefined(URL url, String prefix) {
        HashMap<String, String> nsdefs;
        if (prefix == null) {
            return true;
        }
        if (prefix.equals("*")) {
            return true;
        }
        if (prefix.length() == 0) {
            prefix = "*defaultprefix*";
        }
        if ((nsdefs = this.namespaces.get(url)) == null) {
            return false;
        }
        return nsdefs.containsKey(prefix);
    }

    public void setReferrer(URL referrer) {
        this.referrer = referrer;
    }

    public URL getReferrer() {
        return this.referrer;
    }

    public PageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(PageReader pageReader) {
        this.pageReader = pageReader;
    }

    static {
        try {
            defaultCharset = Charset.forName("iso-8859-1");
            utf8Charset = Charset.forName("utf-8");
        }
        catch (Exception ex) {
            defaultCharset = null;
            utf8Charset = null;
        }
        defaultPrefix = "*defaultprefix*";
        noPrefix = "*noprefix*";
    }
}

