/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import com.agilemind.commons.io.pagereader.HttpResponseIOExeption;
import com.agilemind.commons.io.pagereader.PageReader;
import com.agilemind.commons.io.pagereader.PageReaderContent;
import com.agilemind.commons.io.pagereader.PageReaderContentImpl;
import com.agilemind.commons.io.pagereader.ReadURLSettings;
import com.agilemind.commons.util.UnicodeURL;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.UnicodeInputStream;
import org.w3c.css.util.Util;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPURL {
    private HTTPURL() {
    }

    public static String getHTTPStatusCode(int status) {
        switch (status) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 306: {
                return "(Unused)";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 308: {
                return "Permanent Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return Integer.toString(status, 10);
    }

    public static UnicodeURL getURL(String url) throws IOException {
        try {
            return new UnicodeURL(url);
        }
        catch (MalformedURLException e) {
            if (url.indexOf("://") == -1) {
                return new UnicodeURL("http://" + url);
            }
            throw (IOException)e.fillInStackTrace();
        }
    }

    public static UnicodeURL getURL(URL base, String url) throws MalformedURLException {
        return new UnicodeURL(new URL(base, url));
    }

    private static PageReaderContent getConnection(UnicodeURL url, PageReader pageReader, int count) throws IOException {
        return HTTPURL.getConnection(url, pageReader, null, count, null);
    }

    private static void setSSLVerifier(HttpsURLConnection uConn) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            uConn.setSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            // empty catch block
        }
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        uConn.setHostnameVerifier(hv);
    }

    private static PageReaderContent getConnection(UnicodeURL url, PageReader pageReader, URL referrer, int count, ApplContext ac) throws IOException {
        String protocol;
        URL ref;
        if (count > 5) {
            throw new ProtocolException("Server redirected too many times (5)");
        }
        URL uRL = ref = url.getIDNURL().equals(referrer) ? null : referrer;
        if (Util.servlet && !"https".equalsIgnoreCase(protocol = url.getProtocol()) && !"http".equalsIgnoreCase(protocol)) {
            System.err.println("[WARNING] : someone is trying to get the file: " + url);
            throw new FileNotFoundException("import " + url + ": Operation not permitted");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Pragma", "no-cache");
        map.put("Cache-Control", "no-cache, no-store");
        map.put("User-Agent", "Jigsaw/2.3.0 W3C_CSS_Validator_JFouffa/2.0 (See <http://validator.w3.org/services>)");
        HTTPURL.setReferrer(map, url, ref);
        if (ac.getCredential() != null) {
            map.put("Authorization", ac.getCredential());
        }
        if (ac.getLang() != null) {
            if (ac.getLang().indexOf(42) == -1) {
                map.put("Accept-Language", ac.getLang() + ",*");
            } else {
                map.put("Accept-Language", ac.getLang());
            }
        }
        map.put("Accept", "text/css,text/html,text/xml,application/xhtml+xml,application/xml,image/svg+xml,*/*;q=0.1");
        try {
            PageReaderContent content = null;
            try {
                content = HTTPURL.getContent(url, pageReader, map);
                if (content.needRedirect()) {
                    return HTTPURL.getConnection(content.getRedirectUrl(), pageReader, content.getRequestURL().getIDNURL(), count + 1, ac);
                }
                return content;
            }
            catch (HttpResponseIOExeption e) {
                int status = e.getResponseCode();
                Map responseHeaders = e.getHeaderFields();
                if (status == 401) {
                    String realm;
                    List strings = (List)responseHeaders.get("WWW-Authenticate");
                    String string = realm = strings != null && strings.size() > 0 ? (String)strings.get(0) : null;
                    if (realm != null) {
                        throw new ProtocolException(realm);
                    }
                }
                throw e;
            }
        }
        catch (InterruptedException ignore) {
            return new PageReaderContentImpl();
        }
    }

    private static PageReaderContent getContent(UnicodeURL url, PageReader pageReader, HashMap<String, String> map) throws IOException, InterruptedException {
        return pageReader.getContent(url, new ReadURLSettings(map, false));
    }

    public static PageReaderContent getConnection(UnicodeURL url, PageReader pageReader) throws IOException {
        return HTTPURL.getConnection(url, pageReader, 0);
    }

    public static PageReaderContent getPageReaderContent(UnicodeURL url, ApplContext ac) throws IOException {
        return HTTPURL.getConnection(url, ac.getPageReader(), ac.getReferrer(), 0, ac);
    }

    public static UnicodeURL getUnicodeURL(URL url) {
        try {
            return new UnicodeURL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(url.toString() + "\n", e);
        }
    }

    public static InputStream getInputStream(ApplContext ac, URLConnection uco) throws IOException {
        String charset;
        InputStream orig_stream = uco.getInputStream();
        if (orig_stream == null) {
            return orig_stream;
        }
        String encoding = uco.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            orig_stream = new GZIPInputStream(orig_stream);
        }
        if ((charset = HTTPURL.getCharacterEncoding(ac, uco)) == null || charset.regionMatches(true, 0, "utf", 0, 3)) {
            UnicodeInputStream is = new UnicodeInputStream(orig_stream);
            charset = is.getEncodingFromStream();
            if (charset != null) {
                ac.setCharsetForURL(uco.getURL(), charset);
            }
            return is;
        }
        return orig_stream;
    }

    public static String getCharacterEncoding(ApplContext ac, URLConnection uco) {
        MimeType mt;
        String charset = ac.getCharsetForURL(uco.getURL());
        if (charset != null) {
            return charset;
        }
        String mtypestr = uco.getContentType();
        if (mtypestr == null) {
            return mtypestr;
        }
        try {
            mt = new MimeType(mtypestr);
        }
        catch (MimeTypeFormatException mex) {
            return null;
        }
        charset = mt.getParameterValue("charset");
        if (charset != null) {
            ac.setCharsetForURL(uco.getURL(), charset);
        }
        return charset;
    }

    private static void setReferrer(HashMap<String, String> connection, UnicodeURL current, URL referrer) {
        if (referrer == null) {
            return;
        }
        String curProtocol = current.getProtocol();
        String refProtocol = referrer.getProtocol();
        if ("https".equalsIgnoreCase(refProtocol)) {
            if (!"https".equalsIgnoreCase(curProtocol)) {
                return;
            }
            if (!current.getIDNHost().equalsIgnoreCase(referrer.getHost())) {
                return;
            }
        }
        connection.put("Referer", referrer.toExternalForm());
    }

    public static void main(String[] args) throws Exception {
        System.exit(0);
    }
}

