/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.css.util.Utf8Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messages {
    public Utf8Properties<String, String> properties = null;
    public static final ConcurrentHashMap<String, Utf8Properties<String, String>> languages;
    public static final ArrayList<String> languages_name;

    public Messages(String lang) {
        if (lang != null) {
            StringTokenizer lanTok = new StringTokenizer(lang, ",");
            int maxTok = lanTok.countTokens();
            String[] slang = new String[maxTok];
            float[] qlang = new float[maxTok];
            block0: while (lanTok.hasMoreTokens()) {
                String l = lanTok.nextToken().trim().toLowerCase();
                int qualsep = l.indexOf(59);
                float qval = 1.0f;
                if (qualsep != -1) {
                    String p = l.substring(qualsep + 1);
                    l = l.substring(0, qualsep);
                    if (p.startsWith("q=")) {
                        qval = Float.parseFloat(p.substring(2));
                    }
                }
                for (int i = 0; i < maxTok; ++i) {
                    if (slang[i] == null) {
                        slang[i] = l;
                        qlang[i] = qval;
                        continue block0;
                    }
                    if (!(qval > qlang[i])) continue;
                    System.arraycopy(slang, i, slang, i + 1, maxTok - i - 1);
                    System.arraycopy(qlang, i, qlang, i + 1, maxTok - i - 1);
                    slang[i] = l;
                    qlang[i] = qval;
                    continue block0;
                }
            }
            for (int i = 0; i < maxTok; ++i) {
                String l = slang[i];
                this.properties = languages.get(l);
                if (this.properties != null) break;
                int minusIndex = l.indexOf(45);
                if (minusIndex != -1) {
                    l = l.substring(0, minusIndex);
                    this.properties = languages.get(l);
                }
                if (this.properties != null) break;
            }
        }
        if (this.properties == null) {
            this.properties = languages.get("en");
        }
    }

    public String getString(String message) {
        return this.properties.getProperty(message);
    }

    public String getWarningString(String message) {
        return this.getString("warning." + message);
    }

    public String getWarningLevelString(String message) {
        return this.getString("warning." + message + ".level");
    }

    public String getErrorString(String message) {
        return this.getString("error." + message);
    }

    public String getGeneratorString(String message) {
        return this.getString("generator." + message);
    }

    public String getGeneratorString(String message, String param) {
        String str = this.getString("generator." + message);
        int i = str.indexOf("%s");
        if (i >= 0) {
            str = str.substring(0, i) + param + str.substring(i + 2);
        }
        return str;
    }

    public String getServletString(String message) {
        return this.getString("servlet." + message);
    }

    public static String escapeString(String orig) {
        if (orig != null) {
            int len = orig.length();
            StringBuilder ret = new StringBuilder(len + 16);
            block7: for (int i = 0; i < len; ++i) {
                char c = orig.charAt(i);
                switch (c) {
                    case '&': {
                        ret.append("&amp;");
                        continue block7;
                    }
                    case '\'': {
                        ret.append("&#39;");
                        continue block7;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        continue block7;
                    }
                    case '<': {
                        ret.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        ret.append("&gt;");
                        continue block7;
                    }
                    default: {
                        ret.append(c);
                    }
                }
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    public String getString(String message, ArrayList<String> params) {
        if (params == null || params.size() == 0) {
            return this.getString(message);
        }
        String[] msg_parts = this.getString(message).split("%s", -1);
        Iterator<String> param_it = params.iterator();
        StringBuilder sb = new StringBuilder(msg_parts[0]);
        for (int i = 1; i < msg_parts.length; ++i) {
            if (param_it.hasNext()) {
                sb.append(param_it.next());
            }
            sb.append(msg_parts[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Utf8Properties tmp;
        InputStream f;
        languages = new ConcurrentHashMap();
        languages_name = new ArrayList();
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.de");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("de");
                languages.put("de", tmp);
                languages.put("de_DE", tmp);
                languages.put("de_AT", tmp);
                languages.put("de_CH", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties de");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.en");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("en");
                languages.put("en", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties en");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.es");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("es");
                languages.put("es", tmp);
                languages.put("es_ES", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties es");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.fr");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("fr");
                languages.put("fr", tmp);
                languages.put("fr_FR", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties fr");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.ko");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("ko");
                languages.put("ko", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties ko");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.it");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("it");
                languages.put("it", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties it");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.nl");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("nl");
                languages.put("nl", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties nl");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.ja");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("ja");
                languages.put("ja", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties ja");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.pl-PL");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("pl-PL");
                languages.put("pl", tmp);
                languages.put("pl_PL", tmp);
                languages.put("pl-PL", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties pl");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.pt-BR");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("pt-BR");
                languages.put("pt-br", tmp);
                languages.put("pt-BR", tmp);
                languages.put("pt_BR", tmp);
                languages.put("pt", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties pt-br");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.ru");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("ru");
                languages.put("ru", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties ru");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.fa");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("fa");
                languages.put("fa", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties fa");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.sv");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("sv");
                languages.put("sv", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties sv");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.bg");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("bg");
                languages.put("bg", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties bg");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.uk");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("uk");
                languages.put("uk", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties uk");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.cs");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("cs");
                languages.put("cs", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties cs");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.ro");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("ro");
                languages.put("ro", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties ro");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.hu");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("hu");
                languages.put("hu", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties hu");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.el");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("el");
                languages.put("el", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties el");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.hi");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("hi");
                languages.put("hi", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties hi");
            System.err.println("  " + e.toString());
        }
        try {
            f = Messages.class.getResourceAsStream("Messages.properties.zh-cn");
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages_name.add("zh-cn");
                languages.put("zh-cn", tmp);
                languages.put("zh", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties cn");
            System.err.println("  " + e.toString());
        }
    }
}

