/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.HashMap;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssColorCSS1;
import org.w3c.css.values.CssColorCSS2;
import org.w3c.css.values.CssColorCSS21;
import org.w3c.css.values.CssColorCSS3;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HSL;
import org.w3c.css.values.HSLA;
import org.w3c.css.values.RGB;
import org.w3c.css.values.RGBA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssColor
extends CssValue {
    public static final int type = 3;
    Object color = null;
    RGB rgb = null;
    RGBA rgba = null;
    HSL hsl = null;
    HSLA hsla = null;

    @Override
    public final int getType() {
        return 3;
    }

    public CssColor() {
    }

    public CssColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.charAt(0) == '#') {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    @Override
    public Object get() {
        if (this.color != null) {
            return this.color;
        }
        return this.rgb;
    }

    public String toString() {
        if (this.color != null) {
            return this.color.toString();
        }
        if (this.rgba != null) {
            return this.rgba.toString();
        }
        if (this.hsl != null) {
            return this.hsl.toString();
        }
        if (this.hsla != null) {
            return this.hsla.toString();
        }
        return this.rgb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssPercentage percent;
        CssNumber number;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                number = (CssNumber)val;
                this.rgb.setRed(this.clippedIntValue(number.getInt(), ac));
                this.rgb.setPercent(false);
                break;
            }
            case 4: {
                percent = (CssPercentage)val;
                this.rgb.setRed(this.clippedPercentValue(percent.floatValue(), ac));
                this.rgb.setPercent(true);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                this.rgb.setGreen(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                percent = (CssPercentage)val;
                this.rgb.setGreen(this.clippedPercentValue(percent.floatValue(), ac));
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                this.rgb.setBlue(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                percent = (CssPercentage)val;
                this.rgb.setBlue(this.clippedPercentValue(percent.floatValue(), ac));
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int r;
        boolean islong;
        int v = s.length();
        boolean bl = islong = v == 7;
        if (v != 4 && !islong) {
            throw new InvalidParamException("rgb", s, ac);
        }
        int idx = 1;
        if ((r = Character.digit(s.charAt(idx++), 16)) < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            r = (r << 4) + v;
        } else {
            r |= r << 4;
        }
        int g = Character.digit(s.charAt(idx++), 16);
        if (g < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            g = (g << 4) + v;
        } else {
            g |= g << 4;
        }
        int b = Character.digit(s.charAt(idx), 16);
        if (b < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(++idx), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            b = (b << 4) + v;
        } else {
            b |= b << 4;
        }
        this.color = null;
        this.rgb = new RGB(r, g, b);
        this.rgb.output = s;
    }

    protected boolean computeIdentColor(HashMap<String, Object> definitions, String s) {
        Object obj = definitions.get(s);
        if (obj != null) {
            if (obj instanceof RGB) {
                this.color = s;
                this.rgb = (RGB)obj;
            } else if (obj instanceof RGBA) {
                this.color = s;
                this.rgba = (RGBA)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
            }
            return true;
        }
        return false;
    }

    protected void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        switch (ac.getCssVersion()) {
            case CSS1: {
                this.rgb = CssColorCSS1.getRGB(lower_s);
                if (this.rgb == null) {
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS2: {
                this.rgb = CssColorCSS2.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS2.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS21: {
                this.rgb = CssColorCSS21.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS21.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS3: {
                this.rgb = CssColorCSS3.getRGB(lower_s);
                if (this.rgb != null) {
                    this.color = lower_s;
                    break;
                }
                this.rgba = CssColorCSS3.getRGBA(lower_s);
                if (this.rgba != null) {
                    this.color = lower_s;
                    break;
                }
                this.color = CssColorCSS3.getSystem(lower_s);
                if (this.color != null) {
                    ac.getFrame().addWarning("deprecated", s);
                    break;
                }
                throw new InvalidParamException("value", s, "color", ac);
            }
            default: {
                throw new InvalidParamException("value", s, "color", ac);
            }
        }
    }

    @Override
    public boolean equals(Object cssColor) {
        if (!(cssColor instanceof CssColor)) {
            return false;
        }
        CssColor otherColor = (CssColor)cssColor;
        if (this.color != null && otherColor.color != null) {
            return this.color.equals(otherColor.color);
        }
        if (this.rgb != null && otherColor.rgb != null) {
            return this.rgb.equals(otherColor.rgb);
        }
        if (this.rgba != null && otherColor.rgba != null) {
            return this.rgba.equals(otherColor.rgba);
        }
        if (this.hsl != null && otherColor.hsl != null) {
            return this.hsl.equals(otherColor.hsl);
        }
        if (this.hsla != null && otherColor.hsla != null) {
            return this.hsla.equals(otherColor.hsla);
        }
        return false;
    }

    public void setATSCRGBAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.rgba = new RGBA("atsc-rgba");
        this.__setRGBAColor(this.rgba, exp, ac);
    }

    public void setRGBAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("rgba(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.rgba = new RGBA();
        this.__setRGBAColor(this.rgba, exp, ac);
    }

    private void __setRGBAColor(RGBA rgba, CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssPercentage percent;
        CssNumber number;
        this.color = null;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                number = (CssNumber)val;
                rgba.setRed(this.clippedIntValue(number.getInt(), ac));
                rgba.setPercent(false);
                break;
            }
            case 4: {
                percent = (CssPercentage)val;
                rgba.setRed(this.clippedPercentValue(percent.floatValue(), ac));
                rgba.setPercent(true);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                rgba.setGreen(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                percent = (CssPercentage)val;
                rgba.setGreen(this.clippedPercentValue(percent.floatValue(), ac));
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                number = (CssNumber)val;
                rgba.setBlue(this.clippedIntValue(number.getInt(), ac));
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                percent = (CssPercentage)val;
                rgba.setBlue(this.clippedPercentValue(percent.floatValue(), ac));
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        number = (CssNumber)val;
        rgba.setAlpha(this.clippedAlphaValue(number.getValue(), ac));
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
    }

    public void setHSLColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hsl(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hsl = new HSL();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            throw new InvalidParamException("rgb", val, ac);
        }
        CssNumber number = (CssNumber)val;
        this.hsl.setHue(this.angleValue(number.getValue(), ac));
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        CssPercentage percent = (CssPercentage)val;
        this.hsl.setSaturation(this.clippedPercentValue(percent.floatValue(), ac));
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        percent = (CssPercentage)val;
        this.hsl.setLightness(this.clippedPercentValue(percent.floatValue(), ac));
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setHSLAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hsla(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hsla = new HSLA();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            throw new InvalidParamException("rgb", val, ac);
        }
        CssNumber number = (CssNumber)val;
        this.hsla.setHue(this.angleValue(number.getValue(), ac));
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        CssPercentage percent = (CssPercentage)val;
        this.hsla.setSaturation(this.clippedPercentValue(percent.floatValue(), ac));
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        percent = (CssPercentage)val;
        this.hsla.setLightness(this.clippedPercentValue(percent.floatValue(), ac));
        exp.next();
        val = exp.getValue();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 5) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        number = (CssNumber)val;
        this.hsla.setAlpha(this.clippedAlphaValue(number.getValue(), ac));
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    private int clippedIntValue(int rgb, ApplContext ac) {
        if (rgb < 0 || rgb > 255) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(rgb));
            return rgb < 0 ? 0 : 255;
        }
        return rgb;
    }

    private float clippedPercentValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 100.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return (double)p < 0.0 ? 0.0f : 100.0f;
        }
        return p;
    }

    private float clippedAlphaValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 1.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return (float)((double)p < 0.0 ? 0.0 : 1.0);
        }
        return p;
    }

    private float angleValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p >= 360.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
        }
        return p;
    }
}

