/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssUnitsCSS2;
import org.w3c.css.values.CssUnitsCSS21;
import org.w3c.css.values.CssUnitsCSS3;

public class CssFrequency
extends CssCheckableValue {
    public static final int type = 9;
    private BigDecimal value;
    protected String unit;
    protected BigDecimal factor = BigDecimal.ONE;
    private static BigDecimal defaultValue = BigDecimal.ZERO;

    public final int getType() {
        return 9;
    }

    public CssFrequency() {
        this.value = defaultValue;
    }

    public CssFrequency(BigDecimal value) {
        this.value = value;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        String low_s = s.toLowerCase();
        int length = low_s.length();
        int unitIdx = length - 1;
        char c = low_s.charAt(unitIdx);
        while (unitIdx > 0 && c <= 'z' && c >= 'a') {
            c = low_s.charAt(--unitIdx);
        }
        if (unitIdx == length - 1) {
            throw new InvalidParamException("unit", s, ac);
        }
        String unit_str = low_s.substring(++unitIdx, length);
        switch (ac.getCssVersion()) {
            case CSS2: {
                CssUnitsCSS2.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            case CSS21: {
                CssUnitsCSS21.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            case CSS3: {
                CssUnitsCSS3.parseFrequencyUnit(unit_str, this, ac);
                break;
            }
            default: {
                throw new InvalidParamException("unit", s, ac);
            }
        }
        try {
            this.value = new BigDecimal(low_s.substring(0, unitIdx));
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("invalid-number", low_s.substring(0, unitIdx), ac);
        }
    }

    public Object get() {
        return Float.valueOf(this.value.multiply(this.factor).floatValue());
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        if (BigDecimal.ZERO.compareTo(this.value) == 0) {
            return BigDecimal.ZERO.toPlainString();
        }
        return this.value.toPlainString() + this.unit;
    }

    public boolean equals(Object value) {
        return value instanceof CssFrequency && this.value.equals(((CssFrequency)value).value) && this.unit.equals(((CssFrequency)value).unit);
    }

    public void setValue(BigDecimal v) {
        this.value = v;
    }

    public boolean isPositive() {
        return this.value.signum() >= 0;
    }

    public boolean isStrictlyPositive() {
        return this.value.signum() == 1;
    }

    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.value) == 0;
    }

    public void checkPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isPositive()) {
            throw new InvalidParamException("negative-value", this.toString(), property.getPropertyName(), ac);
        }
    }

    public void checkStrictPositiveness(ApplContext ac, CssProperty property) throws InvalidParamException {
        if (!this.isStrictlyPositive()) {
            throw new InvalidParamException("strictly-positive", this.toString(), property.getPropertyName(), ac);
        }
    }

    public void warnPositiveness(ApplContext ac, CssProperty property) {
        if (!this.isPositive()) {
            ac.getFrame().addWarning("negative", this.toString());
        }
    }

    public CssFrequency getFrequency() {
        return this;
    }
}

