/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.UIUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public class Borders {
    private static Border menuBorder;
    private static Border popupBorder;
    private static Border textFieldBorder;
    private static Border tableHeaderBorder;
    private static Border progressBarBorder;
    public static final Border MAIN_TABLE_BORDER;
    public static final Border MAIN_TABLE_BORDER_WITH_FOOTER;

    static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    static Border getMenuBorder() {
        if (menuBorder == null) {
            menuBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        }
        return menuBorder;
    }

    static Border getPopupBorder() {
        if (popupBorder == null) {
            popupBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        }
        return popupBorder;
    }

    static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    static Border getProgressBarBorder() {
        if (progressBarBorder == null) {
            progressBarBorder = new BorderUIResource(new ProgressBarBorder());
        }
        return progressBarBorder;
    }

    static {
        MAIN_TABLE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 15, 15), BorderFactory.createLineBorder(PureLookAndFeel.getCurrentTheme().getPrimaryControl()));
        MAIN_TABLE_BORDER_WITH_FOOTER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15), BorderFactory.createLineBorder(PureLookAndFeel.getCurrentTheme().getPrimaryControl()));
    }

    private static final class ProgressBarBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(2, 2, 2, 2);

        private ProgressBarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean enabled = c.isEnabled();
            g.setColor(enabled ? PureLookAndFeel.getCurrentTheme().getPrimaryControl() : PureLookAndFeel.getCurrentTheme().getInactiveControlTextColor());
            UIUtils.drawRect(g, x, y, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }

    private static final class TextFieldBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(3, 1, 2, 1);

        private TextFieldBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            boolean showFocusBorder;
            boolean editable = c instanceof JTextComponent && c.isEnabled() && ((JTextComponent)c).isEditable();
            boolean enabled = editable || c.isEnabled();
            boolean bl = showFocusBorder = editable && c.isFocusOwner();
            g.setColor(enabled ? (showFocusBorder ? PureLookAndFeel.getCurrentTheme().getFocusColor() : PureLookAndFeel.getCurrentTheme().getPrimaryControl()) : PureLookAndFeel.getCurrentTheme().getPrimaryControl());
            UIUtils.drawRect(g, x, y, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = TextFieldBorder.INSETS.top;
            newInsets.left = TextFieldBorder.INSETS.left;
            newInsets.bottom = TextFieldBorder.INSETS.bottom;
            newInsets.right = TextFieldBorder.INSETS.right;
            return newInsets;
        }
    }

    private static final class MenuBorder
    extends LineBorder
    implements UIResource {
        public MenuBorder() {
            super(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() || model.isSelected()) {
                super.paintBorder(c, g, x, y, w, h);
            }
        }
    }

    private static final class TableHeaderBorder
    implements Border {
        private TableHeaderBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(PureLookAndFeel.getCurrentTheme().getMenuBackground());
            g.drawLine(x + width - 1, y, x + width - 1, y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 5, 0, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static final class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets INSETS = new Insets(6, 1, 6, 1);

        private PopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
            g.drawRect(0, 0, w - 1, h - 1);
            g.setColor(PureLookAndFeel.getCurrentTheme().getMenuBackground());
            g.drawRect(1, 1, w - 3, h - 3);
            g.drawRect(2, 2, w - 5, h - 5);
            g.drawRect(3, 3, w - 7, h - 7);
            g.drawRect(4, 4, w - 9, h - 9);
            g.drawRect(6, 5, w - 11, h - 11);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return INSETS;
        }
    }
}

