/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.AbstractToggleButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.UIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.text.View;

public abstract class PureAbstractToggleButtonUI
extends AbstractToggleButtonUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = UIUtils.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            this.paintButtonPressed(g, b);
            if (this.paintRolloverPressed() && this.adapter.rollover && model.isEnabled()) {
                this.paintRollover((Graphics2D)g, b);
            }
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        Color textColor = model.isSelected() || model.isPressed() ? this.getSelectedTextColor(c) : (this.adapter.rollover ? this.getRolloverTextColor(c) : this.getNormalTextColor(c));
        if (model.isEnabled()) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor);
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                String token = tokenizer.nextToken();
                int x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
        } else {
            int x;
            String token;
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor.brighter());
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
            g.setColor(b.getBackground().darker());
            i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x - 1, nextY - 1);
                ++i;
                nextY += line_height;
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractButton button = (AbstractButton)c;
        if (this.adapter.rollover && button.getModel().isEnabled()) {
            this.paintRollover(g2d, button);
        } else {
            this.paintBackground(g2d, button, this.getNormalColor(c));
            if (this.paintBorderDefault() && button.isBorderPainted()) {
                this.paintBorder(g2d, button);
            }
        }
        this.paint(g, c);
    }

    protected void paintBackground(Graphics2D g2d, AbstractButton button, Paint gradient) {
        if (button.isContentAreaFilled()) {
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, button.getWidth(), button.getHeight());
        }
    }

    protected void paintBorder(Graphics2D g2d, AbstractButton button) {
        g2d.setPaint(PureLookAndFeel.getCurrentTheme().getPrimaryControl());
        g2d.drawRect(0, 0, button.getWidth() - 1, button.getHeight() - 1);
    }

    private void paintRollover(Graphics2D g, AbstractButton b) {
        this.paintBackground(g, b, this.getRolloverColor(b));
        if (this.paintRolloverBorder()) {
            this.paintBorder(g, b);
        }
    }

    protected Color getRolloverTextColor(JComponent c) {
        return c.getForeground();
    }

    protected Color getSelectedTextColor(JComponent c) {
        return Color.WHITE;
    }

    protected Color getNormalTextColor(JComponent c) {
        return c.getForeground();
    }

    protected boolean paintRolloverBorder() {
        return true;
    }

    protected abstract Paint getNormalColor(JComponent var1);

    protected abstract Paint getRolloverColor(JComponent var1);

    protected abstract boolean paintBorderDefault();

    protected abstract boolean paintRolloverPressed();
}

