/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;

public class PureCheckBoxThreeStateUI
extends MetalCheckBoxUI {
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent c) {
        return new PureCheckBoxThreeStateUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Icon iconThree = null;
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            iconThree = UIManager.getIcon("CheckBoxThreeState.icon");
            this.defaults_initialized = true;
        }
        final Icon iconThreeState = iconThree;
        Icon defaultIcon = new Icon(){
            private int ICON_SIDE;
            {
                this.ICON_SIDE = PureCheckBoxThreeStateUI.this.icon.getIconHeight() + 3;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                ButtonModel model = ((AbstractButton)c).getModel();
                Paint fillPaint = model.isPressed() ? new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, y + this.ICON_SIDE - 2, PureLookAndFeel.getCurrentTheme().getGradientLightColor()) : (model.isRollover() ? new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y + this.ICON_SIDE - 2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()) : Color.WHITE);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(fillPaint);
                g2d.fillRect(x, y, this.ICON_SIDE, this.ICON_SIDE);
                ColorUIResource border = PureLookAndFeel.getCurrentTheme().getPrimaryControl();
                g2d.setPaint(border);
                g2d.drawRect(x, y, this.ICON_SIDE, this.ICON_SIDE);
                if (model.isSelected()) {
                    if (model.isPressed() && iconThreeState != null) {
                        iconThreeState.paintIcon(c, g, x + 1 + (this.ICON_SIDE - iconThreeState.getIconWidth()) / 2, y + 1 + (this.ICON_SIDE - iconThreeState.getIconHeight()) / 2);
                    } else {
                        PureCheckBoxThreeStateUI.this.icon.paintIcon(c, g, x + 1 + (this.ICON_SIDE - PureCheckBoxThreeStateUI.this.icon.getIconWidth()) / 2, y + 1 + (this.ICON_SIDE - PureCheckBoxThreeStateUI.this.icon.getIconHeight()) / 2);
                    }
                }
            }

            @Override
            public int getIconWidth() {
                return this.ICON_SIDE + 2;
            }

            @Override
            public int getIconHeight() {
                return this.ICON_SIDE;
            }
        };
        b.setIcon(defaultIcon);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }
}

