/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import sun.awt.AppContext;

public class PureCheckBoxUI
extends MetalRadioButtonUI {
    private static final Object PURE_CHECK_BOX_UI_KEY = new Object();
    private static final String propertyPrefix = "CheckBox.";
    private boolean defaults_initialized = false;
    private Icon disabledIcon;

    public static ComponentUI createUI(JComponent c) {
        AppContext appContext = AppContext.getAppContext();
        PureCheckBoxUI checkboxUI = (PureCheckBoxUI)appContext.get(PURE_CHECK_BOX_UI_KEY);
        if (checkboxUI == null) {
            checkboxUI = new PureCheckBoxUI();
            appContext.put(PURE_CHECK_BOX_UI_KEY, checkboxUI);
        }
        return checkboxUI;
    }

    @Override
    public String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.disabledIcon = UIManager.getIcon(this.getPropertyPrefix() + "disable.icon");
            this.defaults_initialized = true;
        }
        Icon defaultIcon = new Icon(){
            private int ICON_SIDE;
            {
                this.ICON_SIDE = PureCheckBoxUI.this.icon.getIconHeight() + 3;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color border;
                Paint fillPaint;
                ButtonModel model = ((AbstractButton)c).getModel();
                if (model.isPressed()) {
                    fillPaint = new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, y + this.ICON_SIDE - 2, PureLookAndFeel.getCurrentTheme().getGradientLightColor());
                    border = PureLookAndFeel.getCurrentTheme().getFocusColor();
                } else {
                    border = PureLookAndFeel.getCurrentTheme().getPrimaryControl();
                    fillPaint = model.isRollover() ? new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y + this.ICON_SIDE - 2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()) : Color.WHITE;
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(fillPaint);
                g2d.fillRect(x, y, this.ICON_SIDE, this.ICON_SIDE);
                g2d.setPaint(border);
                g2d.drawRect(x, y, this.ICON_SIDE, this.ICON_SIDE);
                if (model.isSelected()) {
                    if (model.isEnabled()) {
                        PureCheckBoxUI.this.icon.paintIcon(c, g, x + 1 + (this.ICON_SIDE - PureCheckBoxUI.this.icon.getIconWidth()) / 2, y + 1 + (this.ICON_SIDE - PureCheckBoxUI.this.icon.getIconHeight()) / 2);
                    } else {
                        PureCheckBoxUI.this.disabledIcon.paintIcon(c, g, x + 1 + (this.ICON_SIDE - PureCheckBoxUI.this.disabledIcon.getIconWidth()) / 2, y + 1 + (this.ICON_SIDE - PureCheckBoxUI.this.disabledIcon.getIconHeight()) / 2);
                    }
                }
            }

            @Override
            public int getIconWidth() {
                return this.ICON_SIDE + 2;
            }

            @Override
            public int getIconHeight() {
                return this.ICON_SIDE;
            }
        };
        b.setIcon(defaultIcon);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }
}

