/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureComboBoxUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class PureComboBoxButton
extends JButton {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private final JList listBox;
    private final CellRendererPane rendererPane;
    private JComboBox comboBox;
    private Icon comboIcon;
    private boolean iconOnly = false;
    private boolean hover;
    private PureComboBoxUI comboboxUI;

    PureComboBoxButton(JComboBox comboBox, Icon comboIcon, boolean iconOnly, CellRendererPane rendererPane, JList listBox, PureComboBoxUI comboboxUI) {
        super("");
        this.comboboxUI = comboboxUI;
        this.setModel(new DefaultButtonModel(){

            @Override
            public void setArmed(boolean armed) {
                super.setArmed(this.isPressed() || armed);
            }
        });
        this.comboBox = comboBox;
        this.comboIcon = comboIcon;
        this.iconOnly = iconOnly;
        this.rendererPane = rendererPane;
        this.listBox = listBox;
        this.setEnabled(comboBox.isEnabled());
        this.setRequestFocusEnabled(comboBox.isEnabled());
        this.setOpaque(false);
        this.setMargin(EMPTY_INSETS);
        this.setUI(new PureComboButtonUI((PureComboBoxUI)comboBox.getUI()));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PureComboBoxButton.this.hover = true;
                PureComboBoxButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PureComboBoxButton.this.hover = false;
                PureComboBoxButton.this.repaint();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return this.comboBox.getPreferredSize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setBackground(this.comboBox.getBackground());
            this.setForeground(this.comboBox.getForeground());
        } else {
            this.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            this.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        if (this.comboIcon != null) {
            int iconTop;
            int iconLeft;
            int iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                iconLeft = (this.getWidth() - iconWidth) / 2;
                iconTop = (this.getHeight() - iconHeight) / 2;
            } else {
                iconLeft = left + (width - 1) - iconWidth - 3;
                iconTop = (this.getHeight() - iconHeight) / 2;
            }
            this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            int x = left;
            int y = top;
            int w = this.getWidth() - left - UIManager.getInt("ScrollBar.width") - 1;
            int h = height;
            Border oldBorder = null;
            if (c instanceof JComponent && !this.isTableCellEditor()) {
                JComponent component = (JComponent)c;
                if (c instanceof BasicComboBoxRenderer.UIResource) {
                    oldBorder = component.getBorder();
                    component.setBorder(EMPTY_BORDER);
                }
                Insets rendererInsets = component.getInsets();
                Insets editorInsets = UIManager.getInsets("ComboBox.editorInsets");
                int offsetTop = Math.max(0, editorInsets.top - rendererInsets.top);
                int offsetBottom = Math.max(0, editorInsets.bottom - rendererInsets.bottom);
                y += offsetTop;
                h -= offsetTop + offsetBottom;
            }
            c.setFont(UIManager.getFont("ComboBox.font"));
            this.configureColors(c);
            c.setBackground(new Color(0, 0, 0, 0));
            boolean shouldValidate = c instanceof JPanel;
            this.rendererPane.paintComponent(g, c, this, x, y, w, h, shouldValidate);
            if (oldBorder != null) {
                ((JComponent)c).setBorder(oldBorder);
            }
        }
    }

    private void configureColors(Component c) {
        if (this.model.isArmed() && this.model.isPressed()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("Button.select"));
            }
            c.setForeground(this.comboBox.getForeground());
        } else if (!this.comboBox.isEnabled()) {
            if (this.isOpaque()) {
                c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
            }
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
        } else {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        }
    }

    private boolean isTableCellEditor() {
        return true;
    }

    public void setIconOnly(boolean editable) {
        this.iconOnly = editable;
    }

    class PureComboButtonUI
    extends BasicButtonUI {
        private PureComboBoxUI comboBoxUI;

        private PureComboButtonUI(PureComboBoxUI comboBoxUI) {
            this.comboBoxUI = comboBoxUI;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Graphics2D g2d = (Graphics2D)g;
            int height = c.getHeight();
            int width = c.getWidth();
            ButtonModel model1 = ((AbstractButton)c).getModel();
            GradientPaint fillPaint = model1.isPressed() ? new GradientPaint(0.0f, 1.0f, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, height - 2, PureLookAndFeel.getCurrentTheme().getGradientLightColor()) : (PureComboBoxButton.this.hover && PureComboBoxButton.this.comboBox.isEnabled() ? new GradientPaint(0.0f, 1.0f, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, height - 2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()) : StyleConstants.createButtonGradientNormal(1.0f, height - 2));
            g2d.setPaint(fillPaint);
            g2d.fillRect(0, 0, width, height);
            Color borderColor = !model1.isPressed() && PureComboBoxButton.this.comboboxUI.isHasFocus() ? PureLookAndFeel.getCurrentTheme().getFocusColor() : PureLookAndFeel.getCurrentTheme().getPrimaryControl();
            g2d.setPaint(borderColor);
            g2d.drawLine(0, 0, c.getWidth() - 1, 0);
            g2d.drawLine(c.getWidth() - 1, 0, c.getWidth() - 1, c.getHeight() - 1);
            g2d.drawLine(c.getWidth() - 1, c.getHeight() - 1, 0, c.getHeight() - 1);
            if (!PureComboBoxButton.this.comboBox.isEditable()) {
                g2d.drawLine(0, c.getHeight() - 1, 0, 0);
            }
        }
    }
}

