/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureComboBoxButton;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import com.agilemind.utils.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class PureComboBoxUI
extends MetalComboBoxUI {
    static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static Class phantomLafClass;
    public static final int ITEM_X_OFFSET = 3;
    private boolean tableCellEditor;
    private PropertyChangeListener propertyChangeListener;
    Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(PureComboBoxUI ui) {
            int si = PureComboBoxUI.this.listBox.getSelectedIndex();
            if (si < PureComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                PureComboBoxUI.this.listBox.setSelectedIndex(si + 1);
                PureComboBoxUI.this.listBox.ensureIndexIsVisible(si + 1);
            }
            PureComboBoxUI.this.comboBox.repaint();
        }
    };
    Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(PureComboBoxUI ui) {
            int si = PureComboBoxUI.this.listBox.getSelectedIndex();
            if (si > 0) {
                PureComboBoxUI.this.listBox.setSelectedIndex(si - 1);
                PureComboBoxUI.this.listBox.ensureIndexIsVisible(si - 1);
            }
            PureComboBoxUI.this.comboBox.repaint();
        }
    };
    static Action triggerSelectionAction;

    public static ComponentUI createUI(JComponent b) {
        PureComboBoxUI.ensurePhantomHasPureUI();
        return new PureComboBoxUI();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new PureComboBoxEditor();
    }

    private static void ensurePhantomHasPureUI() {
        TextUI ui = PHANTOM.getUI();
        Class<?> lafClass = UIManager.getLookAndFeel().getClass();
        if (phantomLafClass != lafClass || !(ui instanceof MetalTextFieldUI)) {
            phantomLafClass = lafClass;
            PHANTOM.updateUI();
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tableCellEditor = this.isTableCellEditor();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new TableCellEditorPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected JButton createArrowButton() {
        return new PureComboBoxButton(this.comboBox, StyleConstants.arrowDown, this.comboBox.isEditable(), this.currentValuePane, this.listBox, this);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new PureComboBoxLayoutManager();
    }

    @Override
    protected ComboPopup createPopup() {
        return new PureComboPopup(this.comboBox);
    }

    protected ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource renderer = new BasicComboBoxRenderer.UIResource();
        renderer.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return renderer;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        size.height += insets.top + insets.bottom;
        if (this.comboBox.isEditable()) {
            Insets editorBorderInsets = UIManager.getInsets("ComboBox.editorBorderInsets");
            size.width += editorBorderInsets.left + editorBorderInsets.right;
            ++size.width;
        } else if (this.arrowButton != null) {
            Insets arrowButtonInsets = this.arrowButton.getInsets();
            size.width += arrowButtonInsets.left;
        }
        int buttonWidth = PureComboBoxUI.getEditableButtonWidth();
        size.width += insets.left + insets.right + buttonWidth + 20;
        ListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer instanceof JComponent) {
            JComponent component = (JComponent)((Object)renderer);
            Insets rendererInsets = component.getInsets();
            Insets editorInsets = UIManager.getInsets("ComboBox.editorInsets");
            int offsetLeft = Math.max(0, editorInsets.left - rendererInsets.left);
            int offsetRight = Math.max(0, editorInsets.right - rendererInsets.right);
            size.width += offsetLeft + offsetRight;
        }
        Dimension textFieldSize = PHANTOM.getMinimumSize();
        size.height = Math.max(textFieldSize.height, size.height);
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonWidth = PureComboBoxUI.getEditableButtonWidth();
        if (this.arrowButton != null) {
            buttonWidth = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonWidth), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonWidth, insets.top, width - (insets.left + insets.right + buttonWidth), height - (insets.top + insets.bottom));
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            if (this.isToolBarComboBox(c)) {
                c.setOpaque(false);
            }
        }
        this.paint(g, c);
    }

    protected boolean isToolBarComboBox(JComponent c) {
        Container parent = c.getParent();
        return parent != null && (parent instanceof JToolBar || parent.getParent() instanceof JToolBar);
    }

    static int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    private static boolean isTableCellEditor(JComboBox comboBox) {
        return Boolean.TRUE.equals(comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new PurePropertyChangeListener();
    }

    boolean isHasFocus() {
        return this.hasFocus;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (UIUtils.isMacOS()) {
            ActionMap actionMap = this.comboBox.getActionMap();
            actionMap.put("aquaSelectNext", this.highlightNextAction);
            actionMap.put("aquaSelectPrevious", this.highlightPreviousAction);
            actionMap.put("aquaEnterPressed", triggerSelectionAction);
        }
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    protected static void triggerSelectionEvent(JComboBox comboBox, ActionEvent e) {
        if (!comboBox.isEnabled()) {
            return;
        }
        PureComboBoxUI aquaUi = (PureComboBoxUI)comboBox.getUI();
        if (aquaUi.getPopup().getList().getSelectedIndex() < 0) {
            comboBox.setPopupVisible(false);
        }
        if (PureComboBoxUI.isTableCellEditor(comboBox)) {
            comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
            return;
        }
        if (comboBox.isPopupVisible()) {
            comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
            comboBox.setPopupVisible(false);
            return;
        }
        JRootPane root = SwingUtilities.getRootPane(comboBox);
        if (root == null) {
            return;
        }
        InputMap im = root.getInputMap(2);
        ActionMap am = root.getActionMap();
        if (im == null || am == null) {
            return;
        }
        Object obj = im.get(KeyStroke.getKeyStroke(10, 0));
        if (obj == null) {
            return;
        }
        Action action = am.get(obj);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
    }

    static {
        triggerSelectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PureComboBoxUI.triggerSelectionEvent((JComboBox)e.getSource(), e);
            }
        };
    }

    abstract class ComboBoxAction
    extends AbstractAction {
        ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PureComboBoxUI.this.comboBox.isEnabled() || !PureComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (PureComboBoxUI.this.comboBox.isPopupVisible()) {
                PureComboBoxUI ui = (PureComboBoxUI)PureComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(ui);
            } else {
                PureComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(PureComboBoxUI var1);
    }

    private class PureComboBoxEditorTextField
    extends JTextField {
        public PureComboBoxEditorTextField() {
            super("", 9);
            if (UIUtils.isMacOS()) {
                InputMap inputMap = this.getInputMap();
                inputMap.put(KeyStroke.getKeyStroke("DOWN"), PureComboBoxUI.this.highlightNextAction);
                inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), PureComboBoxUI.this.highlightNextAction);
                inputMap.put(KeyStroke.getKeyStroke("UP"), PureComboBoxUI.this.highlightPreviousAction);
                inputMap.put(KeyStroke.getKeyStroke("KP_UP"), PureComboBoxUI.this.highlightPreviousAction);
                final Action action = this.getActionMap().get("notify-field-accept");
                inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (PureComboBoxUI.this.popup.isVisible()) {
                            PureComboBoxUI.triggerSelectionEvent(PureComboBoxUI.this.comboBox, e);
                            if (PureComboBoxUI.this.editor instanceof PureComboBoxEditorTextField) {
                                ((PureComboBoxEditorTextField)PureComboBoxUI.this.editor).selectAll();
                            }
                        } else {
                            action.actionPerformed(e);
                        }
                    }
                });
            }
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.height += 4;
            return pref;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            min.height += 4;
            return min;
        }
    }

    public class PureComboBoxEditor
    extends BasicComboBoxEditor {
        public PureComboBoxEditor() {
            this.editor = new PureComboBoxEditorTextField();
        }
    }

    private final class TableCellEditorPropertyChangeHandler
    implements PropertyChangeListener {
        private TableCellEditorPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PureComboBoxUI.this.tableCellEditor = PureComboBoxUI.this.isTableCellEditor();
            if (PureComboBoxUI.this.comboBox.getRenderer() == null || PureComboBoxUI.this.comboBox.getRenderer() instanceof UIResource) {
                PureComboBoxUI.this.comboBox.setRenderer(PureComboBoxUI.this.createRenderer());
            }
            if (PureComboBoxUI.this.comboBox.getEditor() == null || PureComboBoxUI.this.comboBox.getEditor() instanceof UIResource) {
                PureComboBoxUI.this.comboBox.setEditor(PureComboBoxUI.this.createEditor());
            }
        }
    }

    private static final class PureComboPopup
    extends BasicComboPopup {
        private PureComboPopup(JComboBox combo) {
            super(combo);
            this.setBackground(UIManager.getColor("MenuItem.background"));
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
            this.list.setFixedCellHeight(20);
            this.list.setUI(new BasicListUI(){

                protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer cellRenderer, ListModel dataModel, ListSelectionModel selModel, int leadIndex) {
                    Object value = dataModel.getElementAt(row);
                    boolean cellHasFocus = this.list.hasFocus() && row == leadIndex;
                    boolean isSelected = selModel.isSelectedIndex(row);
                    Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, row, isSelected, cellHasFocus);
                    int cx = rowBounds.x;
                    int cy = rowBounds.y;
                    int cw = rowBounds.width;
                    int ch = rowBounds.height;
                    this.rendererPane.paintComponent(g, rendererComponent, this.list, cx + 3, cy - 1, cw, ch + 1, true);
                    if (isSelected) {
                        g.setColor(rendererComponent.getBackground());
                        g.fillRect(cx, cy, 3, ch);
                    }
                }
            });
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle defaultBounds = super.computePopupBounds(px, py, pw, ph += 2);
            int height = defaultBounds.height;
            if (height % 20 != 0) {
                defaultBounds.height = height = height - defaultBounds.height % 20 + 20;
            }
            return defaultBounds;
        }

        @Override
        protected void configurePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(new LineBorder(PureLookAndFeel.getCurrentTheme().getPrimaryControl(), 1));
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }
    }

    private final class PurePropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private PurePropertyChangeListener() {
            super(PureComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                PureComboBoxButton button = (PureComboBoxButton)PureComboBoxUI.this.arrowButton;
                button.setIconOnly(PureComboBoxUI.this.comboBox.isEditable());
                PureComboBoxUI.this.comboBox.repaint();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                PureComboBoxUI.this.arrowButton.setBackground(color);
                PureComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                PureComboBoxUI.this.arrowButton.setForeground(color);
                PureComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    private final class PureComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private PureComboBoxLayoutManager() {
            super(PureComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            if (!cb.isEditable()) {
                Insets insets = cb.getInsets();
                PureComboBoxUI.this.arrowButton.setBounds(0 + insets.left, 0 + insets.top, cb.getWidth() - insets.left - insets.right, cb.getHeight() - insets.top - insets.bottom);
                return;
            }
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = PureComboBoxUI.this.getInsets();
            int buttonWidth = PureComboBoxUI.getEditableButtonWidth();
            int buttonHeight = height - (insets.top + insets.bottom);
            if (PureComboBoxUI.this.arrowButton != null) {
                if (cb.getComponentOrientation().isLeftToRight()) {
                    PureComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonWidth), insets.top, buttonWidth, buttonHeight);
                } else {
                    PureComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonWidth, buttonHeight);
                }
            }
            if (PureComboBoxUI.this.editor != null) {
                PureComboBoxUI.this.editor.setBounds(PureComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

