/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.AbstractToggleButtonUI;
import com.agilemind.plaf.PureLinkButtonUI;
import com.agilemind.utils.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.text.View;

public class PureLinkToggleButtonUI
extends AbstractToggleButtonUI {
    @Override
    public void update(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = UIUtils.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        Color textColor = model.isSelected() || model.isPressed() || this.adapter.rollover ? PureLinkButtonUI.GREEN_TEXT : c.getForeground();
        if (model.isEnabled()) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor);
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                String token = tokenizer.nextToken();
                int x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
            this.paintTextLine(g, c, textRect);
        } else {
            int x;
            String token;
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            int line_height = fm.getHeight();
            int nextY = textRect.y + fm.getAscent();
            g.setColor(textColor.brighter());
            int i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x, nextY);
                ++i;
                nextY += line_height;
            }
            g.setColor(b.getBackground().darker());
            i = 0;
            while (i <= tokenizer.countTokens()) {
                token = tokenizer.nextToken();
                x = textRect.x + (textRect.width - fm.stringWidth(token)) / 2;
                UIUtils.drawStringUnderlineCharAt(c, g, token, mnemonicIndex, x - 1, nextY - 1);
                ++i;
                nextY += line_height;
            }
        }
    }

    private void paintTextLine(Graphics g, JComponent c, Rectangle textRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        if (!model.isSelected() && !model.isPressed()) {
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int y = textRect.y + fm.getAscent() + 1;
            Line2D.Double underlineLine = new Line2D.Double(textRect.x, y, textRect.x + textRect.width + 3, y);
            Color foreground = this.adapter.isRollover() ? PureLinkButtonUI.GREEN_TEXT : b.getForeground();
            g.setColor(foreground);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f));
            g2.draw(underlineLine);
        }
    }
}

