/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.Borders;
import com.agilemind.plaf.LookAndFeelProxy;
import com.agilemind.plaf.PureTableCorner;
import com.agilemind.plaf.scheme.ColorScheme;
import com.agilemind.utils.MenuItemRenderer;
import com.agilemind.utils.ShadowPopupFactory;
import com.agilemind.utils.StyleConstants;
import com.agilemind.utils.UIUtils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import sun.swing.ImageIconUIResource;

public class PureLookAndFeel
extends LookAndFeelProxy {
    public static final Integer TABLE_ROW_HEIGHT = 24;
    private static ColorScheme currentTheme = ColorScheme.DEFAULT;

    public PureLookAndFeel() {
        String targetClassName = UIUtils.isMacOS() ? UIManager.getSystemLookAndFeelClassName() : "javax.swing.plaf.metal.MetalLookAndFeel";
        try {
            this.setTarget((LookAndFeel)Class.forName(targetClassName).newInstance());
        }
        catch (Exception e) {
            throw new InternalError("Unable to instanciate target Look and Feel \"" + targetClassName + "\". " + e.getMessage());
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    @Override
    public String getDescription() {
        return "Cross-platform Java Pure LookAndFeel";
    }

    @Override
    public String getName() {
        return "PureLookAndFeel";
    }

    @Override
    public String getID() {
        return this.target.getID();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return super.isNativeLookAndFeel();
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return super.isSupportedLookAndFeel();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = this.target.getDefaults();
        this.initClassDefaults(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        return table;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String barUI;
        String uiClassNamePrefix = "com.agilemind.plaf.Pure";
        String menuBarUI = UIUtils.isMacOS() ? ((barUI = table.getString("MenuBarUI")) != null ? barUI : "com.apple.laf.AquaMenuBarUI") : "com.agilemind.plaf.PureMenuBarUI";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.agilemind.plaf.PureButtonUI", "CheckBoxMenuItemUI", "com.agilemind.plaf.PureCheckBoxMenuItemUI", "CheckBoxUI", "com.agilemind.plaf.PureCheckBoxUI", "CheckBoxThreeStateUI", "com.agilemind.plaf.PureCheckBoxThreeStateUI", "ComboBoxUI", "com.agilemind.plaf.PureComboBoxUI", "MenuUI", "com.agilemind.plaf.PureMenuUI", "MenuBarUI", menuBarUI, "MenuItemUI", "com.agilemind.plaf.PureMenuItemUI", "OptionPaneUI", "com.agilemind.plaf.PureOptionPaneUI", "PopupMenuSeparatorUI", "com.agilemind.plaf.PurePopupMenuSeparatorUI", "RadioButtonUI", "com.agilemind.plaf.PureRadioButtonUI", "RadioButtonMenuItemUI", "com.agilemind.plaf.PureRadioButtonMenuItemUI", "ScrollBarUI", "com.agilemind.plaf.PureScrollBarUI", "SliderUI", "com.agilemind.plaf.PureSliderUI", "SplitPaneUI", "com.agilemind.plaf.PureSplitPaneUI", "TabbedPaneUI", "com.agilemind.plaf.PureTabbedPaneUI", "TableHeaderUI", "com.agilemind.plaf.PureTableHeaderUI", "TableUI", "com.agilemind.plaf.PureTableUI", "TextFieldUI", "com.agilemind.plaf.PureTextFieldUI", "ToolTipUI", "com.agilemind.plaf.PureTooltipUI", "SpinnerUI", "com.agilemind.plaf.PureSpinnerUI", "SeparatorUI", "com.agilemind.plaf.PureSeparatorUI", "ToggleButtonUI", "com.agilemind.plaf.PureToggleButtonUI", "TreeUI", "com.agilemind.plaf.PureTreeUI", "ProgressBarUI", "com.agilemind.plaf.PureProgressBarUI", "PasswordFieldUI", "com.agilemind.plaf.PurePasswordFieldUI", "CustomFileChooserUI", "com.agilemind.commons.gui.filechooser.CustomFileChooserUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        ColorUIResource acceleratorForeground = currentTheme.getAcceleratorForeground();
        ColorUIResource acceleratorSelectedForeground = currentTheme.getAcceleratorSelectedForeground();
        ColorUIResource primaryControl = currentTheme.getPrimaryControl();
        ColorUIResource control = new ColorUIResource(currentTheme.getControl());
        ColorUIResource controlHighlight = currentTheme.getAcceleratorSelectedForeground();
        ColorUIResource controlTextColor = currentTheme.getAcceleratorForeground();
        ColorUIResource menuBackground = new ColorUIResource(currentTheme.getControl());
        ColorUIResource menuSelectedForeground = currentTheme.getAcceleratorSelectedForeground();
        InsetsUIResource tabbedPaneTabInsets = new InsetsUIResource(5, 14, 5, 14);
        Color textHighlight = currentTheme.getFocusColor();
        ColorUIResource textHighlightText = currentTheme.getAcceleratorSelectedForeground();
        Color textInactiveText = currentTheme.getInactiveControlTextColor();
        Border textFieldBorder = Borders.getTextFieldBorder();
        Border progressBarBorder = Borders.getProgressBarBorder();
        BorderUIResource.LineBorderUIResource scrollPaneBorder = new BorderUIResource.LineBorderUIResource(currentTheme.getPrimaryControl());
        InsetsUIResource textInsets = new InsetsUIResource(1, 5, 1, 5);
        Border toggleButtonBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        Border tableCellBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Object[] defaults = new Object[]{"Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.borderPaintsFocus", Boolean.TRUE, "Button.textIconGap", 0, "Button.font", StyleConstants.getButtonTextFont(table.getFont("Button.font")), "Button.border", toggleButtonBorder, "ComboBox.background", currentTheme.getBackgroundColor(), "ComboBox.disabledForeground", textInactiveText, "ComboBox.editorInsets", new InsetsUIResource(1, 1, 1, 1), "ComboBox.editorBorderInsets", new InsetsUIResource(1, 1, 1, 1), "ComboBox.font", StyleConstants.getControlTextFont(table, "ComboBox.font"), "ComboBox.selectionBackground", currentTheme.getFocusColor(), "CheckBox.background", currentTheme.getBackgroundColor(), "CheckBox.foreground", controlTextColor, "CheckBox.focus", currentTheme.getFocusColor(), "CheckBox.font", StyleConstants.getControlTextFont(table, "CheckBox.font"), "CheckBox.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/checkBox.png"), "CheckBox.disable.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/checkBoxDisable.png"), "CheckBoxThreeState.icon", PureLookAndFeel.makeIcon(this.getClass(), "icons/CheckBoxThreeState.png"), "CheckBoxMenuItem.acceleratorForeground", acceleratorForeground, "CheckBoxMenuItem.acceleratorSelectionForeground", textHighlightText, "CheckBoxMenuItem.background", new ColorUIResource(PureLookAndFeel.getCurrentTheme().getMenuBackground()), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", StyleConstants.getCheckBoxMenuItemIcon(), "CheckBoxMenuItem.font", StyleConstants.getControlTextFont(table, "CheckBoxMenuItem.font"), "CheckBoxMenuItem.foreground", controlTextColor, "CheckBoxMenuItem.selectionForeground", menuSelectedForeground, "CheckBoxMenuItem.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "EditorPane.selectionBackground", textHighlight, "EditorPane.inactiveForeground", textInactiveText, "EditorPane.selectionForeground", textHighlightText, "FileView.computerIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/computer.png"), "FileView.directoryIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory.png"), "FileView.fileIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/fileIcon.png"), "FileView.floppyDriveIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/floppyDrive.png"), "FileView.hardDriveIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/hardDrive.png"), "FileView.computerIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/computer32.png"), "FileView.directoryIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory32.png"), "FileView.fileIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/fileIcon32.png"), "FileView.floppyDriveIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/floppyDrive32.png"), "FileView.hardDriveIcon32", PureLookAndFeel.makeIcon(this.getClass(), "icons/hardDrive32.png"), "FileChooser.homeFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/homeFolder.png"), "FileChooser.newFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/newFolder.png"), "FileChooser.upFolderIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/upFolder.png"), "FileChooser.listViewIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/listView.png"), "FileChooser.detailsViewIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/detailsView.png"), "FilterComboBox.background", StyleConstants.DARK_BACKGROUND, "FilterComboBox.listBackground", StyleConstants.DARK_MENU_BACKGROUND, "FilterComboBox.listBorder", BorderFactory.createEmptyBorder(10, 10, 10, 10), "FilterComboBox.foreground", StyleConstants.TEXT_COLOR, "FilterComboBox.textFieldBorder", BorderFactory.createEmptyBorder(2, 2, 2, 2), "FilterComboBox.disabledForeground", textInactiveText, "FilterComboBox.editorInsets", new InsetsUIResource(0, 0, 0, 0), "FilterComboBox.editorBorderInsets", new InsetsUIResource(0, 0, 0, 0), "FilterComboBox.border", new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0), "FilterComboBox.font", StyleConstants.getControlTextFont(table, "ComboBox.font"), "FilterComboBox.selectionBackground", StyleConstants.DARK_BACKGROUND2, "FilterComboBox.selectionForeground", Color.WHITE, "FilterComboBox.selectedItemForeground", StyleConstants.TEXT_SELECTED_COLOR, "FilterComboBox.scrollBarTrackBackground", new Color(62, 62, 62), "FilterComboBox.scrollBarThumbBackground", new Color(109, 109, 109), "FilterComboBox.fixedCellHeight", 25, "FormattedTextField.border", textFieldBorder, "FormattedTextField.foreground", controlTextColor, "FormattedTextField.inactiveForeground", textInactiveText, "FormattedTextField.inactiveBackground", control, "FormattedTextField.margin", textInsets, "FormattedTextField.selectionForeground", textHighlightText, "FormattedTextField.selectionBackground", textHighlight, "Label.background", control, "Label.font", StyleConstants.getControlTextFont(table, "Label.font"), "Label.foreground", controlTextColor, "List.font", StyleConstants.getControlTextFont(table, "List.font"), "List.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(currentTheme.getFocusColor()), "List.selectionBackground", currentTheme.getFocusColor(), "List.selectionForeground", textHighlightText, "MainTable.border", Borders.MAIN_TABLE_BORDER, "MainTable.borderWithFooter", Borders.MAIN_TABLE_BORDER_WITH_FOOTER, "DarkMenu.acceleratorForeground", StyleConstants.DARK_MENU_ACCELERATOR_FOREGROUND, "DarkMenu.acceleratorSelectionForeground", StyleConstants.DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND, "DarkMenu.acceleratorFont", StyleConstants.getControlTextFont(table, "Menu.acceleratorFont"), "DarkMenu.arrowIcon", new ImageIconUIResource(StyleConstants.darkArrowRight.getImage()), "DarkMenu.background", StyleConstants.DARK_MENU_BACKGROUND, "DarkMenu.border", Borders.getMenuBorder(), "DarkMenu.borderPainted", Boolean.FALSE, "DarkMenu.font", StyleConstants.getControlTextFont(table, "Menu.font"), "DarkMenu.foreground", StyleConstants.DARK_MENU_FOREGROUND, "DarkMenu.margin", new InsetsUIResource(0, 0, 0, 0), "DarkMenu.selectionForeground", StyleConstants.DARK_MENU_SELECTED_FOREGROUND, "DarkMenu.selectionBackground", StyleConstants.DARK_MENU_SELECTED_BACKGROUND, "DarkMenu.disabledForeground", StyleConstants.DARK_MENU_DISABLED_FOREGROUND, "DarkMenu.textIconGap", 8, "DarkMenu.opaque", Boolean.TRUE, "DarkMenuItem.acceleratorForeground", StyleConstants.DARK_MENU_ACCELERATOR_FOREGROUND, "DarkMenuItem.acceleratorSelectionForeground", StyleConstants.DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND, "DarkMenuItem.acceleratorFont", StyleConstants.getControlTextFont(table, "MenuItem.acceleratorFont"), "DarkMenuItem.background", StyleConstants.DARK_MENU_BACKGROUND, "DarkMenuItem.borderPainted", Boolean.FALSE, "DarkMenuItem.border", new BorderUIResource(BorderFactory.createEmptyBorder(0, 0, 0, 0)), "DarkMenuItem.checkIcon", new MenuItemRenderer.MinimumSizedIcon(), "DarkMenuItem.font", StyleConstants.getControlTextFont(table, "MenuItem.font"), "DarkMenuItem.foreground", StyleConstants.DARK_MENU_FOREGROUND, "DarkMenuItem.margin", new InsetsUIResource(0, 0, 0, 0), "DarkMenuItem.selectionForeground", StyleConstants.DARK_MENU_SELECTED_FOREGROUND, "DarkMenuItem.selectionBackground", StyleConstants.DARK_MENU_SELECTED_BACKGROUND, "DarkMenuItem.disabledForeground", StyleConstants.DARK_MENU_DISABLED_FOREGROUND, "DarkMenuItem.textIconGap", 8, "DarkPopupMenuSeparator.background", StyleConstants.DARK_MENU_SEPARATOR_BACKGROUND, "Menu.acceleratorForeground", StyleConstants.MENU_ACCELERATOR_FOREGROUND, "Menu.acceleratorSelectionForeground", StyleConstants.MENU_ACCELERATOR_SELECTED_FOREGROUND, "Menu.acceleratorFont", StyleConstants.getControlTextFont(table, "Menu.acceleratorFont"), "Menu.arrowIcon", new ImageIconUIResource(StyleConstants.arrowRight.getImage()), "Menu.background", new ColorUIResource(currentTheme.getBackgroundColor()), "Menu.borderPainted", Boolean.FALSE, "Menu.border", Borders.getMenuBorder(), "Menu.font", StyleConstants.getControlTextFont(table, "Menu.font"), "Menu.foreground", controlTextColor, "Menu.margin", new InsetsUIResource(0, 0, 0, 0), "Menu.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "Menu.selectionForeground", menuSelectedForeground, "Menu.textIconGap", 8, "Menu.opaque", Boolean.FALSE, "Menu.useMenuBarBackgroundForTopLevel", Boolean.TRUE, "MenuBar.background", StyleConstants.MENU_BAR_BACKGROUND, "MenuBar.border", new BorderUIResource(BorderFactory.createEmptyBorder(15, 15, 15, 20)), "MenuBar.font", StyleConstants.getControlTextFont(table, "MenuBar.font"), "MenuItem.acceleratorForeground", StyleConstants.MENU_ACCELERATOR_FOREGROUND, "MenuItem.acceleratorSelectionForeground", StyleConstants.MENU_ACCELERATOR_SELECTED_FOREGROUND, "MenuItem.acceleratorFont", StyleConstants.getControlTextFont(table, "MenuItem.acceleratorFont"), "MenuItem.background", new ColorUIResource(currentTheme.getMenuBackground()), "MenuItem.borderPainted", Boolean.FALSE, "MenuItem.border", new BorderUIResource(BorderFactory.createEmptyBorder(0, 0, 0, 0)), "MenuItem.checkIcon", new MenuItemRenderer.MinimumSizedIcon(), "MenuItem.font", StyleConstants.getControlTextFont(table, "MenuItem.font"), "MenuItem.foreground", controlTextColor, "MenuItem.margin", new InsetsUIResource(0, 0, 0, 0), "MenuItem.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "MenuItem.selectionForeground", menuSelectedForeground, "MenuItem.textIconGap", 8, "OptionPane.background", currentTheme.getBackgroundColor(), "OptionPane.foreground", controlTextColor, "OptionPane.messageForeground", controlTextColor, "OptionPane.errorIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-error.png"), "OptionPane.informationIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-info.png"), "OptionPane.questionIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialog-question.png"), "OptionPane.warningIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/dialogWarning.png"), "OperationProgressBar.background", new ColorUIResource(new Color(204, 204, 204)), "OperationProgressBar.foreground", new ColorUIResource(93, 164, 44), "OperationProgressBar.border", new EmptyBorder(0, 0, 0, 0), "Panel.background", currentTheme.getBackgroundColor(), "PasswordField.border", textFieldBorder, "PasswordField.foreground", controlTextColor, "PasswordField.selectionBackground", textHighlight, "PasswordField.selectionForeground", textHighlightText, "PasswordField.inactiveBackground", currentTheme.getInactiveTextFieldColor(), "PasswordField.inactiveForeground", textInactiveText, "PasswordField.margin", textInsets, "PasswordField.inactiveForeground", textInactiveText, "PasswordField.disabledBackground", currentTheme.getInactiveTextFieldColor(), "ProgressBar.background", currentTheme.getAcceleratorSelectedForeground(), "ProgressBar.border", progressBarBorder, "ProgressBar.foreground", new ColorUIResource(currentTheme.getFocusColor()), "ProgressBar.font", StyleConstants.getControlTextFont(table, "ProgressBar.font"), "ProgressBar.selectionBackground", acceleratorForeground, "ProgressBar.selectionForeground", currentTheme.getAcceleratorSelectedForeground(), "PopupMenu.background", StyleConstants.POPUP_BACKGROUND, "PopupMenu.border", Borders.getPopupBorder(), "PopupMenu.font", StyleConstants.getControlTextFont(table, "PopupMenu.font"), "PopupMenuSeparator.background", StyleConstants.MENU_SEPARATOR_BACKGROUND, "RadioButton.background", currentTheme.getBackgroundColor(), "RadioButton.foreground", controlTextColor, "RadioButton.shapeBackground", currentTheme.getUnSelectedColor(), "RadioButton.font", StyleConstants.getControlTextFont(table, "RadioButton.font"), "RadioButton.focus", currentTheme.getFocusColor(), "RadioButtonMenuItem.acceleratorForeground", acceleratorForeground, "RadioButtonMenuItem.acceleratorSelectionForeground", acceleratorSelectedForeground, "RadioButtonMenuItem.background", new ColorUIResource(currentTheme.getMenuBackground()), "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.border", new BorderUIResource(new BasicBorders.MarginBorder()), "RadioButtonMenuItem.checkIcon", StyleConstants.getRadioButtonMenuItemIcon(), "RadioButtonMenuItem.font", StyleConstants.getControlTextFont(table, "RadioButtonMenuItem.font"), "RadioButtonMenuItem.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "RadioButtonMenuItem.selectionForeground", menuSelectedForeground, "RadioButtonMenuItem.textIconGap", 4, "ScrollBar.width", 18, "Slider.font", StyleConstants.getControlTextFont(table, "Slider.font"), "Slider.highlight", controlHighlight, "SplitPane.background", currentTheme.getBackgroundColor(), "SplitPane.dividerFocusColor", primaryControl, "SplitPane.highlight", controlHighlight, "SplitPane.horizontalDividerIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/hsplitter.png"), "SplitPane.verticalDividerIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/vsplitter.png"), "SplitPane.streamHorizontalDividerIcon", currentTheme.getHorizontalDividerIcon(), "SplitPane.streamVerticalDividerIcon", currentTheme.getVerticalDividerIcon(), "Spinner.background", control, "Spinner.defaultEditorInsets", new InsetsUIResource(1, 1, 1, 1), "Spinner.foreground", control, "Spinner.font", StyleConstants.getControlTextFont(table, "Spinner.font"), "ScrollPane.background", currentTheme.getBackgroundColor(), "ScrollPane.border", scrollPaneBorder, "ScrollPane.etchedBorder", scrollPaneBorder, "ScrollPane.foreground", controlTextColor, "TabbedPane.background", StyleConstants.TABBED_PANE_HEADER_UNSELECTED_COLOR, "TabbedPane.focus", controlTextColor, "TabbedPane.font", StyleConstants.getControlTextFont(table, "TabbedPane.font"), "TabbedPane.foreground", new ColorUIResource(119, 119, 119), "TabbedPane.selected", control, "TabbedPane.selectedForeground", currentTheme.getAcceleratorForeground(), "TabbedPane.selectHighlight", controlHighlight, "TabbedPane.tabInsets", tabbedPaneTabInsets, "TabbedPane.tabAreaInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.contentBorderInsets", new InsetsUIResource(0, 0, 0, 0), "ModulesTabbedPane.font", new Font("Default", 1, 11), "ModulesTabbedPane.foreground", StyleConstants.TEXT_COLOR, "ModulesTabbedPane.selectedForeground", StyleConstants.TEXT_SELECTED_COLOR, "ModulesTabbedPane.rolloverForeground", StyleConstants.TEXT_ROLLOVER_COLOR, "ModulesTabbedPane.background", StyleConstants.DARK_BACKGROUND, "ModulesTabbedPane.dashColor", new Color(43, 43, 43), "ModulesTabbedPane.dashOffset", 10, "ModulesTabbedPane.tabInsets", new InsetsUIResource(30, 5, 30, 5), "ModulesTabbedPane.tabAreaInsets", new InsetsUIResource(0, 0, 0, 0), "Table.ascendingSortIcon", new IconUIResource(StyleConstants.arrowUp), "Table.descendingSortIcon", new IconUIResource(StyleConstants.arrowDown), "Table.cellNoFocusBorder", tableCellBorder, "Table.dropLineShortColor", acceleratorForeground, "Table.focusSelectedCellHighlightBorder", tableCellBorder, "Table.focusCellHighlightBorder", tableCellBorder, "Table.focusCellForeground", controlTextColor, "Table.foreground", controlTextColor, "Table.font", StyleConstants.getControlTextFont(table, "Table.font"), "Table.gridColor", currentTheme.getTableGridColor(), "Table.rowHeight", TABLE_ROW_HEIGHT, "Table.selectionForeground", textHighlightText, "Table.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "Table.scrollPaneBorder", scrollPaneBorder, "TableHeader.ascIcon", new IconUIResource(StyleConstants.arrowUp), "TableHeader.background", currentTheme.getTableHeaderColor(), "TableHeader.backgroundSorted", new ColorUIResource(currentTheme.getTableHeaderSortedColor()), "TableHeader.cellBorder", new BorderUIResource(Borders.getTableHeaderBorder()), "TableHeader.descIcon", new IconUIResource(StyleConstants.arrowDown), "TableHeader.font", StyleConstants.getSmallControlTextFont(table.getFont("TableHeader.font")), "TableHeader.foreground", controlTextColor, "TextArea.font", StyleConstants.getControlTextFont(table, "TextArea.font"), "TextArea.selectionBackground", textHighlight, "TextArea.selectionForeground", textHighlightText, "TextArea.inactiveForeground", textInactiveText, "TextField.border", textFieldBorder, "TextField.font", StyleConstants.getControlTextFont(table, "TextField.font"), "TextField.foreground", controlTextColor, "TextField.margin", textInsets, "TextField.selectionBackground", textHighlight, "TextField.selectionForeground", textHighlightText, "TextField.highlight", controlHighlight, "TextField.inactiveForeground", textInactiveText, "TextField.disabledBackground", currentTheme.getInactiveTextFieldColor(), "TextField.inactiveBackground", currentTheme.getInactiveTextFieldColor(), "TextPane.inactiveForeground", textInactiveText, "TextPane.selectionForeground", textHighlightText, "TextPane.selectionBackground", textHighlight, "TitledBorder.font", StyleConstants.getControlTextFont(table, "TitledBorder.font"), "TitledBorder.titleColor", controlTextColor, "Tree.collapsedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/treeCollapsed.png"), "Tree.closedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/directory.png"), "Tree.expandedIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/treeExpanded.png"), "Tree.collapsedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/collapsedBranch.png"), "Tree.selectedCollapsedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/collapsedBranchWhite.png"), "Tree.expandedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/expandedBranch.png"), "Tree.selectedExpandedBranchIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/expandedBranchWhite.png"), "Tree.foreground", controlTextColor, "Tree.hash", primaryControl, "Tree.line", primaryControl, "Tree.openIcon", PureLookAndFeel.makeIcon(this.getClass(), "icons/openFolder.png"), "Tree.rowHeight", TABLE_ROW_HEIGHT, "Tree.selectionForeground", textHighlightText, "Tree.selectionBackground", new ColorUIResource(currentTheme.getFocusColor()), "Tree.selectionBorderColor", null, "Tree.font", StyleConstants.getControlTextFont(table, "Tree.font"), "ToolBar.background", currentTheme.getBackgroundColor(), "ToolBar.dockingForeground", acceleratorForeground, "ToolBar.dockingBackground", menuBackground, "ToolBar.font", StyleConstants.getControlTextFont(table, "ToolBar.font"), "ToolBar.foreground", controlTextColor, "ToolBar.floatingForeground", primaryControl, "ToolBar.floatingBackground", menuBackground, "ToolBar.highlight", controlHighlight, "ToolTip.background", currentTheme.getToolTipColor(), "ToolTip.border", BorderFactory.createLineBorder(currentTheme.getToolTipBorderColor(), 1), "ToolTip.font", StyleConstants.getSmallControlTextFont(table.getFont("ToolTip.font")), "ToolTip.foreground", controlTextColor, "ToggleButton.border", toggleButtonBorder, "ToggleButton.borderPaintsFocus", Boolean.TRUE, "ToggleButton.font", StyleConstants.getButtonTextFont(table.getFont("ToggleButton.font")), "ToggleButton.foreground", controlTextColor, "ToolBarButton.background", StyleConstants.DARK_BACKGROUND, "ToolBarButton.foreground", StyleConstants.TEXT_COLOR, "ToolBarButton.pressedBackground", StyleConstants.DARK_MENU_SELECTED_BACKGROUND, "ToolBarButton.pressedForeground", Color.WHITE, "ToolBarButton.rolloverBackground", StyleConstants.DARK_MENU_SELECTED_BACKGROUND, "ToolBarButton.rolloverForeground", Color.WHITE, "ToolBarButton.font", StyleConstants.getToolbarButtonTextFont(table.getFont("Button.font")), "ToolBarButton.border", toggleButtonBorder, "ToolBarButton.textIconGap", 6, "Viewport.background", control, "arrowright", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowright.png"), "arrowleft", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowleft.png"), "arrowright_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowrightRollover.png"), "arrowleft_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/arrowleftRollover.png"), "addtab", PureLookAndFeel.makeIcon(this.getClass(), "icons/add.png"), "addtab_rollover", PureLookAndFeel.makeIcon(this.getClass(), "icons/addRollover.png")};
        table.put("Table.scrollPaneCornerComponent", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new PureTableCorner();
            }
        });
        table.putDefaults(defaults);
    }

    public static ColorScheme getCurrentTheme() {
        return currentTheme;
    }

    public static void setCurrentTheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = colorScheme;
    }
}

