/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.utils.MenuItemRenderer;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class PureMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private String componentPropertyPrefix;
    private MenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent b) {
        return new PureMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.componentPropertyPrefix = this.getPropertyPrefix();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.componentPropertyPrefix = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(this.componentPropertyPrefix + ".arrowIcon");
        }
        this.renderer = new MenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer gap = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = gap != null ? gap : 5;
        LookAndFeel.installBorder(this.menuItem, this.getPropertyPrefix() + ".border");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    @Override
    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    protected String getSubmenuPropertyPrefix() {
        return SUBMENU_PROPERTY_PREFIX;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon aCheckIcon, Icon anArrowIcon, int textIconGap) {
        if (PureMenuUI.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            Dimension preferredMenuItemSize = this.renderer.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
            preferredMenuItemSize.height = 25;
            return preferredMenuItemSize;
        }
        Dimension preferredMenuItemSize = super.getPreferredMenuItemSize(c, aCheckIcon, anArrowIcon, textIconGap);
        preferredMenuItemSize.height = 25;
        return preferredMenuItemSize;
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon aCheckIcon, Icon anArrowIcon, Color background, Color foreground, int textIconGap) {
        if (PureMenuUI.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        } else {
            super.paintMenuItem(g, c, aCheckIcon, anArrowIcon, background, foreground, textIconGap);
        }
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else if (menuItem instanceof JMenu && model.isRollover()) {
                ((Graphics2D)g).setPaint(this.getMenuHoverColor(menuHeight));
                g.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
            }
            g.setColor(oldColor);
        } else if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(oldColor);
        }
    }

    protected Paint getMenuHoverColor(float menuHeight) {
        return StyleConstants.createButtonGradientNormal(0.0f, menuHeight);
    }

    private void ensureSubMenuInstalled() {
        if (this.propertyPrefix.equals(this.getSubmenuPropertyPrefix())) {
            return;
        }
        ButtonModel model = this.menuItem.getModel();
        boolean oldArmed = model.isArmed();
        boolean oldSelected = model.isSelected();
        this.uninstallRolloverListener();
        this.uninstallDefaults();
        this.propertyPrefix = this.getSubmenuPropertyPrefix();
        this.installDefaults();
        model.setArmed(oldArmed);
        model.setSelected(oldSelected);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mouseListener = new RolloverHandler();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    private static boolean isSubMenu(JMenuItem aMenuItem) {
        return !((JMenu)aMenuItem).isTopLevelMenu();
    }

    private static final class RolloverHandler
    extends MouseAdapter {
        private RolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.getModel().setRollover(true);
            b.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            b.getModel().setRollover(false);
            b.repaint();
        }
    }
}

