/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;

public class PureRadioButtonUI
extends MetalRadioButtonUI {
    public static final int ICON_SIDE = 11;
    private boolean rollover;
    private MouseAdapter mouseAdapter;
    private Color shapeColor;

    public static ComponentUI createUI(JComponent c) {
        return new PureRadioButtonUI();
    }

    @Override
    public void installDefaults(final AbstractButton b) {
        super.installDefaults(b);
        this.shapeColor = UIManager.getColor("RadioButton.shapeBackground");
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PureRadioButtonUI.this.rollover = true;
                b.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PureRadioButtonUI.this.rollover = false;
                b.repaint();
            }
        };
        b.addMouseListener(this.mouseAdapter);
        Icon defaultIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color border;
                Paint fillPaint;
                ButtonModel model = ((AbstractButton)c).getModel();
                if (model.isPressed()) {
                    fillPaint = new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor(), 0.0f, y + 11 - 2, PureLookAndFeel.getCurrentTheme().getGradientLightColor());
                    border = PureLookAndFeel.getCurrentTheme().getFocusColor();
                } else {
                    border = PureLookAndFeel.getCurrentTheme().getPrimaryControl();
                    fillPaint = PureRadioButtonUI.this.rollover ? new GradientPaint(0.0f, y + 1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y + 11 - 2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor()) : Color.WHITE;
                }
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(x, y, 11.0, 11.0, 11.0, 11.0);
                g2d.setPaint(fillPaint);
                g2d.fill(shape);
                g2d.setPaint(border);
                g2d.draw(shape);
                if (model.isSelected()) {
                    int iconD = 6;
                    shape = new RoundRectangle2D.Double(x + 3, y + 3, iconD, iconD, iconD, iconD);
                    g2d.setPaint(PureRadioButtonUI.this.shapeColor);
                    g2d.fill(shape);
                }
            }

            @Override
            public int getIconWidth() {
                return 13;
            }

            @Override
            public int getIconHeight() {
                return 11;
            }
        };
        b.setIcon(defaultIcon);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.removeMouseListener(this.mouseAdapter);
    }
}

