/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class PureScrollBarUI
extends BasicScrollBarUI {
    private boolean hover;
    private boolean isPressed;

    public static ComponentUI createUI(JComponent c) {
        return new PureScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Adjustable scrollBar = (Adjustable)((Object)c);
        int orientation = scrollBar.getOrientation();
        EmptyBorder border = orientation == 1 ? new EmptyBorder(1, 0, 1, 1) : new EmptyBorder(0, 1, 1, 1);
        c.setBorder(border);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (this.scrollbar.getOrientation() == 1) {
            preferredSize.width = 12;
        } else {
            preferredSize.height = 12;
        }
        return preferredSize;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        Graphics2D g2d = (Graphics2D)g;
        Color color = g2d.getColor();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setPaint(this.getTrackBackground());
        int height = trackBounds.height;
        int width = trackBounds.width;
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(color);
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.scrollbar.getOrientation() == 1) {
            g2d.setPaint(this.getFillRectThumbColor());
            g2d.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height);
            g2d.setPaint(this.getDrawRectThumbColor());
            g2d.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1);
        } else {
            g2d.setPaint(this.getFillRectThumbColor());
            g2d.fillRect(thumbBounds.x, thumbBounds.y + 1, thumbBounds.width, thumbBounds.height - 2);
            g2d.setPaint(this.getDrawRectThumbColor());
            g2d.drawRect(thumbBounds.x, thumbBounds.y + 1, thumbBounds.width - 1, thumbBounds.height - 2);
        }
    }

    protected Color getTrackBackground() {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor();
    }

    protected Paint getDrawRectThumbColor() {
        Color color = this.isPressed ? PureLookAndFeel.getCurrentTheme().getFocusColor() : (this.hover ? PureLookAndFeel.getCurrentTheme().getPrimaryControl() : PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor());
        return color;
    }

    protected Paint getFillRectThumbColor() {
        return this.hover ? PureLookAndFeel.getCurrentTheme().getPrimaryControl() : PureLookAndFeel.getCurrentTheme().getTableHeaderSortedColor();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new PureTrackListener();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.incrButton = new JButton();
        this.incrButton.setPreferredSize(new Dimension(0, 0));
        this.decrButton = new JButton();
        this.decrButton.setPreferredSize(new Dimension(0, 0));
    }

    protected class PureTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected PureTrackListener() {
            super(PureScrollBarUI.this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            PureScrollBarUI.this.hover = false;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            PureScrollBarUI.this.hover = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            PureScrollBarUI.this.isPressed = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            PureScrollBarUI.this.hover = true;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            PureScrollBarUI.this.isPressed = false;
            PureScrollBarUI.this.scrollbar.repaint(PureScrollBarUI.this.getThumbBounds());
        }
    }
}

