/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureDarkMenuItemUI;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;

public class PureScrollableMenuItemUI
extends PureDarkMenuItemUI {
    private Handler handler;

    public static ComponentUI createUI(JComponent b) {
        return new PureScrollableMenuItemUI();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateAcceleratorBinding();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return this.getHandler();
    }

    @Override
    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return this.getHandler();
    }

    @Override
    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return this.getHandler();
    }

    Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        InputMap windowInputMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (windowInputMap != null) {
            windowInputMap.clear();
        }
        if (accelerator != null) {
            if (windowInputMap == null) {
                windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, windowInputMap);
            }
            windowInputMap.put(accelerator, "doClick");
        }
    }

    InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    class Handler
    implements MenuDragMouseListener,
    MouseInputListener,
    PropertyChangeListener {
        Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < PureScrollableMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < PureScrollableMenuItemUI.this.menuItem.getHeight()) {
                PureScrollableMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                PureScrollableMenuItemUI.this.menuItem.setArmed(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                PureScrollableMenuItemUI.this.menuItem.setArmed(false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        @Override
        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        @Override
        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < PureScrollableMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < PureScrollableMenuItemUI.this.menuItem.getHeight()) {
                PureScrollableMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name == "labelFor" || name == "displayedMnemonic" || name == "accelerator") {
                PureScrollableMenuItemUI.this.updateAcceleratorBinding();
            } else if (name == "text" || "font" == name || "foreground" == name) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            } else if (name == "iconTextGap") {
                PureScrollableMenuItemUI.this.defaultTextIconGap = ((Number)e.getNewValue()).intValue();
            }
        }
    }
}

