/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureAbstractToggleButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import com.agilemind.utils.UIUtils;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class PureSimpleToggleButtonUI
extends PureAbstractToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new PureSimpleToggleButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFont(c.getFont().deriveFont(0, 11.0f));
    }

    @Override
    protected Paint getNormalColor(JComponent c) {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor();
    }

    @Override
    protected Paint getRolloverColor(JComponent c) {
        return StyleConstants.createButtonGradientHover(0.0f, c.getHeight());
    }

    @Override
    protected boolean paintBorderDefault() {
        return false;
    }

    @Override
    protected boolean paintRolloverPressed() {
        return true;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        ColorUIResource textColor = PureLookAndFeel.getCurrentTheme().getAcceleratorForeground();
        if (model.isEnabled()) {
            g.setColor(textColor);
            UIUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(b.getBackground());
            UIUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            g.setColor(b.getBackground().darker());
            UIUtils.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        }
    }
}

