/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureArrowButton;
import com.agilemind.plaf.PureSpinnerLayout;
import com.agilemind.plaf.PureTextFieldUI;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PureSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent b) {
        return new PureSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.spinner.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected Component createNextButton() {
        PureArrowButton nextButton = new PureArrowButton(1, false);
        this.installNextButtonListeners(nextButton);
        return nextButton;
    }

    @Override
    protected Component createPreviousButton() {
        PureArrowButton previousButton = new PureArrowButton(5, false);
        this.installPreviousButtonListeners(previousButton);
        return previousButton;
    }

    @Override
    protected LayoutManager createLayout() {
        return new PureSpinnerLayout();
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        PureSpinnerUI.configureEditorBorder(editor);
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        PureSpinnerUI.configureEditorBorder(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private static void configureEditorBorder(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            JFormattedTextField editorField = defaultEditor.getTextField();
            editorField.setUI(new PureTextFieldUI());
        } else if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
            JComponent editorField = (JComponent)editor.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PureArrowButton {
        private SpinnerArrowButton(int direction) {
            super(direction);
        }
    }
}

