/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.PureSliderUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class PureSplitPaneUI
extends BasicSplitPaneUI {
    private static final ImageIcon HORIZONTAL_SPLITTER = new ImageIcon(PureSliderUI.class.getResource("icons/hsplitter.png"));
    private static final ImageIcon VERTICAL_SPLITTER = new ImageIcon(PureSliderUI.class.getResource("icons/vsplitter.png"));
    public static final int DIVIDER_SIZE = 8;
    private Boolean dividerBorderVisible = Boolean.FALSE;
    private Border verticalDividerBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, PureLookAndFeel.getCurrentTheme().getTableHeaderColor());
    private Border horizontalDividerBorder = BorderFactory.createMatteBorder(0, 1, 0, 1, PureLookAndFeel.getCurrentTheme().getTableHeaderColor());

    public static ComponentUI createUI(JComponent c) {
        return new PureSplitPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSplitPane) {
            JSplitPane pane = (JSplitPane)c;
            pane.setDividerSize(8);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new Divider(this);
    }

    class Divider
    extends BasicSplitPaneDivider {
        private final BasicSplitPaneUI ui;

        Divider(BasicSplitPaneUI ui) {
            super(ui);
            this.ui = ui;
        }

        @Override
        public void paint(Graphics g) {
            if (this.ui.getOrientation() == 1) {
                int y = (this.getHeight() - VERTICAL_SPLITTER.getImage().getHeight(null)) / 2;
                g.drawImage(VERTICAL_SPLITTER.getImage(), (8 - VERTICAL_SPLITTER.getIconWidth()) / 2, y, null);
            } else {
                int x = (this.getWidth() - HORIZONTAL_SPLITTER.getImage().getWidth(null)) / 2;
                g.drawImage(HORIZONTAL_SPLITTER.getImage(), x, (8 - VERTICAL_SPLITTER.getIconWidth()) / 2, null);
            }
            if (PureSplitPaneUI.this.dividerBorderVisible.booleanValue()) {
                Dimension size = this.getSize();
                Border border = this.ui.getOrientation() == 1 ? PureSplitPaneUI.this.horizontalDividerBorder : PureSplitPaneUI.this.verticalDividerBorder;
                border.paintBorder(this, g, 0, 0, size.width, size.height);
            }
        }

        @Override
        public Border getBorder() {
            return BorderFactory.createEmptyBorder(0, 0, 0, 0);
        }
    }

    private class PropertyChangeHandler
    extends BasicSplitPaneUI.PropertyHandler {
        private PropertyChangeHandler() {
            super(PureSplitPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String changeName = e.getPropertyName();
            if ("dividerBorderVisible".equals(changeName)) {
                PureSplitPaneUI.this.dividerBorderVisible = (Boolean)e.getNewValue();
                this.updateSplitPane();
            } else {
                super.propertyChange(e);
            }
        }

        private void updateSplitPane() {
            PureSplitPaneUI.this.splitPane.revalidate();
            PureSplitPaneUI.this.splitPane.repaint();
        }
    }
}

