/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.LazyActionMap;
import com.agilemind.plaf.PureAbstractButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import com.agilemind.utils.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class PureTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int MAX_TAB_WIDTH = 250;
    private static final int BUTTON_SIZE = 25;
    private Color darkBackgroundColor;
    private Color selectedColor;
    private Color unSelectedColor;
    private static final Insets contentInsets = new Insets(0, 0, 0, 0);
    private Boolean hideTabArea = Boolean.FALSE;
    private Boolean linkTabs = Boolean.FALSE;
    private boolean showAddTabsButton = false;
    private ScrollableTabSupport tabScroller;
    private TabContainer tabContainer;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private Color borderColor;

    public static ComponentUI createUI(JComponent c) {
        return new PureTabbedPaneUI();
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("navigateNext"));
        map.put(new Actions("navigatePrevious"));
        map.put(new Actions("navigateRight"));
        map.put(new Actions("navigateLeft"));
        map.put(new Actions("navigateUp"));
        map.put(new Actions("navigateDown"));
        map.put(new Actions("navigatePageUp"));
        map.put(new Actions("navigatePageDown"));
        map.put(new Actions("requestFocus"));
        map.put(new Actions("requestFocusForVisibleComponent"));
        map.put(new Actions("setSelectedIndex"));
        map.put(new Actions("selectTabWithFocus"));
        map.put(new Actions("scrollTabsForwardAction"));
        map.put(new Actions("scrollTabsBackwardAction"));
        map.put(new Actions("addTabAction"));
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateBorder(c);
        c.setOpaque(true);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    @Override
    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
        this.installTabContainer();
    }

    private void installTabContainer() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Component tabComponent = this.tabPane.getTabComponentAt(i);
            if (tabComponent == null) continue;
            if (this.tabContainer == null) {
                this.tabContainer = new TabContainer();
            }
            this.tabContainer.add(tabComponent);
        }
        if (this.tabContainer == null) {
            return;
        }
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.add(this.tabContainer);
        } else {
            this.tabPane.add(this.tabContainer);
        }
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallTabContainer();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.abbButton);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    private void uninstallTabContainer() {
        if (this.tabContainer == null) {
            return;
        }
        this.tabContainer.notifyTabbedPane = false;
        this.tabContainer.removeAll();
        if (this.scrollableTabLayoutEnabled()) {
            this.tabScroller.tabPanel.remove(this.tabContainer);
        } else {
            this.tabPane.remove(this.tabContainer);
        }
        this.tabContainer = null;
    }

    @Override
    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        LazyActionMap.installLazyActionMap(this.tabPane, PureTabbedPaneUI.class, "TabbedPane.actionMap");
        this.updateMnemonics();
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.focusInputMap");
        }
        return null;
    }

    @Override
    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, null);
        this.mnemonicToIndexMap = null;
        this.mnemonicInputMap = null;
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(mnemonic, index);
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(g, tabPlacement, selectedIndex);
        }
        if (!UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
            this.paintContentBorder(g, tabPlacement, selectedIndex);
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point vpp = this.tabScroller.viewport.getLocation();
            Point viewp = this.tabScroller.viewport.getViewPosition();
            dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
            dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        } else {
            dest.x = this.rects[tabIndex].x;
            dest.y = this.rects[tabIndex].y;
        }
        return dest;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.darkBackgroundColor = UIManager.getColor("TabbedPane.background");
        this.selectedColor = PureLookAndFeel.getCurrentTheme().getBackgroundColor();
        this.unSelectedColor = StyleConstants.TABBED_PANE_HEADER_UNSELECTED_COLOR;
        this.borderColor = StyleConstants.TEXT_COLOR;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (!this.hideTabArea.booleanValue()) {
            super.paintTabArea(g, tabPlacement, selectedIndex);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (this.linkTabs.booleanValue()) {
            this.paintLinkTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        } else {
            this.paintDefaultTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    private void paintDefaultTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedColor == null ? this.unSelectedColor : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 1, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(isSelected ? x - 1 : x, y, w - 1, h);
                if (isSelected) {
                    g.setColor(StyleConstants.TEXT_SELECTED_COLOR);
                    g.fillRect(x - 1, y + h - 3, w - 1, 3);
                    break;
                }
                g.setColor(this.borderColor);
                g.drawLine(x + w - 1, 6, x + w - 1, h - 6);
                break;
            }
            default: {
                g.fillRect(isSelected ? x - 1 : x, y, w - 1, h);
                if (isSelected) {
                    g.setColor(StyleConstants.TEXT_SELECTED_COLOR);
                    g.fillRect(x - 1, y, w - 1, 3);
                    break;
                }
                g.setColor(this.borderColor);
                g.drawLine(x + w - 1, 6, x + w - 1, h - 6);
            }
        }
    }

    private void paintLinkTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(PureLookAndFeel.getCurrentTheme().getMenuBackground());
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return contentInsets;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        return contentInsets;
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        if (UIUtils.isJava7OrLate()) {
            Insets insets = this.getTabInsets(tabPlacement, tabIndex);
            if (tabRect.width <= textRect.width + iconRect.width + insets.left + insets.right) {
                textRect.width -= insets.left + insets.right;
                textRect.x += insets.left;
            }
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (this.linkTabs.booleanValue()) {
            this.paintLinkText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        } else {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        }
    }

    protected void paintLinkText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            Color fg = PureLookAndFeel.getCurrentTheme().getAcceleratorForeground();
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected && fg instanceof UIResource) {
                    fg = PureLookAndFeel.getCurrentTheme().getLinkColor();
                }
                g2.setColor(fg);
                UIUtils.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                fg = Color.GRAY;
                g2.setColor(fg);
                UIUtils.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
            if (!isSelected) {
                int textWidth = metrics.stringWidth(title);
                Line2D.Double underlineLine = new Line2D.Double(textRect.x, textRect.y + metrics.getAscent() + 3, textRect.x + textWidth, textRect.y + metrics.getAscent() + 3);
                g2.setPaint(fg);
                g2.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f));
                g2.draw(underlineLine);
            }
        }
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        return this.hideTabArea != false ? 0 : super.calculateTabAreaHeight(tabPlacement, horizRunCount, maxTabHeight);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        if (this.hideTabArea.booleanValue()) {
            return 0;
        }
        int tabWidth = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return UIUtils.isJava7OrLate() ? Math.min(tabWidth, 250) : tabWidth;
    }

    @Override
    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        return this.hideTabArea != false ? 0 : super.calculateTabAreaWidth(tabPlacement, vertRunCount, maxTabWidth);
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    private void updateBorder(JComponent c) {
        c.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected ChangeListener createChangeListener() {
        final ChangeListener delegate = super.createChangeListener();
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index;
                delegate.stateChanged(e);
                JTabbedPane tabPane = (JTabbedPane)e.getSource();
                tabPane.revalidate();
                tabPane.repaint();
                if (PureTabbedPaneUI.this.scrollableTabLayoutEnabled() && (index = tabPane.getSelectedIndex()) < PureTabbedPaneUI.this.rects.length && index != -1) {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible((Rectangle)PureTabbedPaneUI.this.rects[index].clone());
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    protected JButton createScrollButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    boolean requestFocusForVisibleComponent() {
        Component comp = this.getVisibleComponent();
        return comp != null && comp instanceof JComponent && ((JComponent)comp).requestDefaultFocus();
    }

    public boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        return this.tabForCoordinate(pane, x, y, true);
    }

    private int tabForCoordinate(JTabbedPane pane, int x, int y, boolean validateIfNecessary) {
        if (validateIfNecessary) {
            this.ensureCurrentLayout();
        }
        Point p = new Point(x, y);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(x, y, p);
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            if (!viewRect.contains(p)) {
                return -1;
            }
        }
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    private Point translatePointToTabPanel(int srcx, int srcy, Point dest) {
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = srcx - vpp.x + viewp.x;
        dest.y = srcy - vpp.y + viewp.y;
        return dest;
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD_ACTION = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD_ACTION = "scrollTabsBackwardAction";
        static final String ADD_TAB_ACTION = "addTabAction";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block18: {
                PureTabbedPaneUI ui;
                JTabbedPane pane;
                String key;
                block28: {
                    Integer index;
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block17: {
                                                            key = this.getName();
                                                            pane = (JTabbedPane)e.getSource();
                                                            ui = (PureTabbedPaneUI)PureTabbedPaneUI.getUIOfType(pane.getUI(), PureTabbedPaneUI.class);
                                                            if (ui == null) {
                                                                return;
                                                            }
                                                            if (key != NEXT) break block17;
                                                            ui.navigateSelectedTab(12);
                                                            break block18;
                                                        }
                                                        if (key != PREVIOUS) break block19;
                                                        ui.navigateSelectedTab(13);
                                                        break block18;
                                                    }
                                                    if (key != RIGHT) break block20;
                                                    ui.navigateSelectedTab(3);
                                                    break block18;
                                                }
                                                if (key != LEFT) break block21;
                                                ui.navigateSelectedTab(7);
                                                break block18;
                                            }
                                            if (key != UP) break block22;
                                            ui.navigateSelectedTab(1);
                                            break block18;
                                        }
                                        if (key != DOWN) break block23;
                                        ui.navigateSelectedTab(5);
                                        break block18;
                                    }
                                    if (key != PAGE_UP) break block24;
                                    int tabPlacement = pane.getTabPlacement();
                                    if (tabPlacement == 1 || tabPlacement == 3) {
                                        ui.navigateSelectedTab(7);
                                    } else {
                                        ui.navigateSelectedTab(1);
                                    }
                                    break block18;
                                }
                                if (key != PAGE_DOWN) break block25;
                                int tabPlacement = pane.getTabPlacement();
                                if (tabPlacement == 1 || tabPlacement == 3) {
                                    ui.navigateSelectedTab(3);
                                } else {
                                    ui.navigateSelectedTab(5);
                                }
                                break block18;
                            }
                            if (key != REQUEST_FOCUS) break block26;
                            pane.requestFocus();
                            break block18;
                        }
                        if (key != REQUEST_FOCUS_FOR_VISIBLE) break block27;
                        ui.requestFocusForVisibleComponent();
                        break block18;
                    }
                    if (key != SET_SELECTED) break block28;
                    String command = e.getActionCommand();
                    if (command == null || command.length() <= 0) break block18;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) == null || !pane.isEnabledAt(index)) break block18;
                    pane.setSelectedIndex(index);
                    break block18;
                }
                if (key == SELECT_FOCUSED) {
                    int focusIndex = ui.getFocusIndex();
                    if (focusIndex != -1) {
                        pane.setSelectedIndex(focusIndex);
                    }
                } else if (key == SCROLL_FORWARD_ACTION) {
                    if (ui.scrollableTabLayoutEnabled()) {
                        ui.tabScroller.scrollForward(pane.getTabPlacement());
                    }
                } else if (key == SCROLL_BACKWARD_ACTION) {
                    if (ui.scrollableTabLayoutEnabled()) {
                        ui.tabScroller.scrollBackward(pane.getTabPlacement());
                    }
                } else if (key.equals(ADD_TAB_ACTION) && ui.showAddTabsButton) {
                    PropertyChangeListener[] propertyChangeListeners;
                    for (PropertyChangeListener changeListener : propertyChangeListeners = pane.getPropertyChangeListeners(ADD_TAB_ACTION)) {
                        changeListener.propertyChange(new PropertyChangeEvent(((PureTabbedPaneUI)ui).tabScroller.abbButton, ADD_TAB_ACTION, null, null));
                    }
                }
            }
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
            Insets contentInsets = PureTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Insets tabAreaInsets = PureTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Dimension zeroSize = new Dimension(0, 0);
            int height = 0;
            int width = 0;
            int cWidth = 0;
            int cHeight = 0;
            for (int i = 0; i < PureTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Component component = PureTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension size = zeroSize;
                Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
                if (size == null) continue;
                cHeight = Math.max(size.height, cHeight);
                cWidth = Math.max(size.width, cWidth);
            }
            width += cWidth;
            height += cHeight;
            int tabExtent = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    height = Math.max(height, PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement));
                    tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                    width += tabExtent;
                    break;
                }
                default: {
                    width = Math.max(width, PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement));
                    tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                    height += tabExtent;
                }
            }
            return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            FontMetrics metrics = PureTabbedPaneUI.this.getFontMetrics();
            int tabCount = PureTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int rows = 1;
                int x = 0;
                int maxTabHeight = PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    int tabWidth = PureTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    if (x != 0 && x + tabWidth > width) {
                        ++rows;
                        x = 0;
                    }
                    x += tabWidth;
                }
                total = PureTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
            }
            return total;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            FontMetrics metrics = PureTabbedPaneUI.this.getFontMetrics();
            int tabCount = PureTabbedPaneUI.this.tabPane.getTabCount();
            int total = 0;
            if (tabCount > 0) {
                int columns = 1;
                int y = 0;
                int fontHeight = metrics.getHeight();
                PureTabbedPaneUI.this.maxTabWidth = PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                for (int i = 0; i < tabCount; ++i) {
                    int tabHeight = PureTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (y != 0 && y + tabHeight > height) {
                        ++columns;
                        y = 0;
                    }
                    y += tabHeight;
                }
                total = PureTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, columns, PureTabbedPaneUI.this.maxTabWidth);
            }
            return total;
        }

        @Override
        public void layoutContainer(Container parent) {
            PureTabbedPaneUI.this.setRolloverTab(-1);
            int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = PureTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = PureTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    PureTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = PureTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
            }
            int totalTabWidth = 0;
            int totalTabHeight = 0;
            Insets contentInsets = PureTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                PureTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            Rectangle bounds = PureTabbedPaneUI.this.tabPane.getBounds();
            int numChildren = PureTabbedPaneUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int cy;
                int cx;
                switch (tabPlacement) {
                    case 2: {
                        totalTabWidth = PureTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabWidth);
                        cx = insets.left + totalTabWidth + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 4: {
                        totalTabWidth = PureTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabWidth);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    case 3: {
                        totalTabHeight = PureTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        break;
                    }
                    default: {
                        totalTabHeight = PureTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabHeight);
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + totalTabHeight + contentInsets.top;
                    }
                }
                int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
                int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                for (int i = 0; i < numChildren; ++i) {
                    Component child = PureTabbedPaneUI.this.tabPane.getComponent(i);
                    if (child == PureTabbedPaneUI.this.tabContainer) {
                        int tabContainerWidth = totalTabWidth == 0 ? bounds.width : totalTabWidth + insets.left + insets.right + contentInsets.left + contentInsets.right;
                        int tabContainerHeight = totalTabHeight == 0 ? bounds.height : totalTabHeight + insets.top + insets.bottom + contentInsets.top + contentInsets.bottom;
                        int tabContainerX = 0;
                        int tabContainerY = 0;
                        if (tabPlacement == 3) {
                            tabContainerY = bounds.height - tabContainerHeight;
                        } else if (tabPlacement == 4) {
                            tabContainerX = bounds.width - tabContainerWidth;
                        }
                        child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
            }
            this.layoutTabComponents();
            if (shouldChangeFocus && !PureTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                PureTabbedPaneUI.this.tabPane.requestFocus();
            }
        }

        public void calculateLayoutInfo() {
            int tabCount = PureTabbedPaneUI.this.tabPane.getTabCount();
            PureTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(PureTabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        private void layoutTabComponents() {
            if (PureTabbedPaneUI.this.tabContainer == null) {
                return;
            }
            Point delta = new Point(-PureTabbedPaneUI.this.tabContainer.getX(), -PureTabbedPaneUI.this.tabContainer.getY());
            if (PureTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                PureTabbedPaneUI.this.translatePointToTabPanel(0, 0, delta);
            }
            Rectangle rect = new Rectangle();
            for (int i = 0; i < PureTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                Component c = PureTabbedPaneUI.this.tabPane.getTabComponentAt(i);
                if (c == null) continue;
                PureTabbedPaneUI.this.getTabBounds(i, rect);
                Dimension preferredSize = c.getPreferredSize();
                Insets insets = PureTabbedPaneUI.this.getTabInsets(PureTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                int outerX = rect.x + insets.left + delta.x;
                int outerY = rect.y + insets.top + delta.y;
                int outerWidth = rect.width - insets.left - insets.right;
                int outerHeight = rect.height - insets.top - insets.bottom;
                int x = outerX + (outerWidth - preferredSize.width) / 2;
                int y = outerY + (outerHeight - preferredSize.height) / 2;
                int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
                boolean isSeleceted = i == PureTabbedPaneUI.this.tabPane.getSelectedIndex();
                c.setBounds(x + PureTabbedPaneUI.this.getTabLabelShiftX(tabPlacement, i, isSeleceted), y + PureTabbedPaneUI.this.getTabLabelShiftY(tabPlacement, i, isSeleceted), preferredSize.width, preferredSize.height);
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = PureTabbedPaneUI.this.getFontMetrics();
            Dimension size = PureTabbedPaneUI.this.tabPane.getSize();
            Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = PureTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = PureTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = PureTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    PureTabbedPaneUI.this.maxTabWidth = PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    PureTabbedPaneUI.this.maxTabWidth = PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - PureTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    PureTabbedPaneUI.this.maxTabHeight = PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - PureTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    PureTabbedPaneUI.this.maxTabHeight = PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = PureTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            PureTabbedPaneUI.this.runCount = 0;
            PureTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = PureTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[0] = 0;
                        PureTabbedPaneUI.this.runCount = 1;
                        PureTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = PureTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    PureTabbedPaneUI.this.maxTabWidth = Math.max(PureTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (PureTabbedPaneUI.this.runCount > PureTabbedPaneUI.this.tabRuns.length - 1) {
                            PureTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[((PureTabbedPaneUI)PureTabbedPaneUI.this).runCount] = i;
                        PureTabbedPaneUI.this.runCount++;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = PureTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[0] = 0;
                        PureTabbedPaneUI.this.runCount = 1;
                        PureTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = PureTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    PureTabbedPaneUI.this.maxTabHeight = Math.max(PureTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (PureTabbedPaneUI.this.runCount > PureTabbedPaneUI.this.tabRuns.length - 1) {
                            PureTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[((PureTabbedPaneUI)PureTabbedPaneUI.this).runCount] = i;
                        PureTabbedPaneUI.this.runCount++;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = PureTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                PureTabbedPaneUI.this.selectedRun = PureTabbedPaneUI.this.runCount - 1;
            }
            if (PureTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                PureTabbedPaneUI.this.selectedRun = PureTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (PureTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, PureTabbedPaneUI.this.selectedRun);
                }
            }
            for (i = PureTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = PureTabbedPaneUI.this.tabRuns[i];
                int next = PureTabbedPaneUI.this.tabRuns[i == PureTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = PureTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += PureTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (PureTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= PureTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += PureTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = PureTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += PureTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (PureTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= PureTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += PureTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].x = rightMargin - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].x - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].width;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            for (int i = 0; i < selectedRun; ++i) {
                int save = PureTabbedPaneUI.this.tabRuns[0];
                for (int j = 1; j < PureTabbedPaneUI.this.runCount; ++j) {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[j - 1] = PureTabbedPaneUI.this.tabRuns[j];
                }
                ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[((PureTabbedPaneUI)PureTabbedPaneUI.this).runCount - 1] = save;
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            int run = PureTabbedPaneUI.this.runCount - 1;
            boolean keepAdjusting = true;
            double weight = 1.25;
            while (keepAdjusting) {
                int prevLastLen;
                int end;
                int last = PureTabbedPaneUI.this.lastTabInRun(tabCount, run);
                int prevLast = PureTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                if (!verticalTabRuns) {
                    end = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[last].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[last].width;
                    prevLastLen = (int)((double)PureTabbedPaneUI.this.maxTabWidth * weight);
                } else {
                    end = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[last].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[last].height;
                    prevLastLen = (int)((double)PureTabbedPaneUI.this.maxTabHeight * weight * 2.0);
                }
                if (max - end > prevLastLen) {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[run] = prevLast;
                    if (!verticalTabRuns) {
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[prevLast].x = start;
                    } else {
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[prevLast].y = start;
                    }
                    for (int i = prevLast + 1; i <= last; ++i) {
                        if (!verticalTabRuns) {
                            ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].x = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].width;
                            continue;
                        }
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].y = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].height;
                    }
                } else if (run == PureTabbedPaneUI.this.runCount - 1) {
                    keepAdjusting = false;
                }
                if (run - 1 > 0) {
                    --run;
                    continue;
                }
                run = PureTabbedPaneUI.this.runCount - 1;
                weight += 0.25;
            }
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            Rectangle lastRect = PureTabbedPaneUI.this.rects[end];
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = lastRect.x + lastRect.width - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[start].x;
                int deltaWidth = max - (lastRect.x + lastRect.width);
                float factor = (float)deltaWidth / (float)runWidth;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = PureTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.x = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[j - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[j - 1].width;
                    }
                    pastRect.width += Math.round((float)pastRect.width * factor);
                }
                lastRect.width = max - lastRect.x;
            } else {
                int runHeight = lastRect.y + lastRect.height - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[start].y;
                int deltaHeight = max - (lastRect.y + lastRect.height);
                float factor = (float)deltaHeight / (float)runHeight;
                for (int j = start; j <= end; ++j) {
                    Rectangle pastRect = PureTabbedPaneUI.this.rects[j];
                    if (j > start) {
                        pastRect.y = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[j - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[j - 1].height;
                    }
                    pastRect.height += Math.round((float)pastRect.height * factor);
                }
                lastRect.height = max - lastRect.y;
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            if (selectedIndex >= 0) {
                Rectangle selRect = PureTabbedPaneUI.this.rects[selectedIndex];
                Insets padInsets = PureTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
                selRect.x -= padInsets.left;
                selRect.width += padInsets.left + padInsets.right;
                selRect.y -= padInsets.top;
                selRect.height += padInsets.top + padInsets.bottom;
                if (!PureTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    Dimension size = PureTabbedPaneUI.this.tabPane.getSize();
                    Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
                    if (tabPlacement == 2 || tabPlacement == 4) {
                        int bottom;
                        int top = insets.top - selRect.y;
                        if (top > 0) {
                            selRect.y += top;
                            selRect.height -= top;
                        }
                        if ((bottom = selRect.y + selRect.height + insets.bottom - size.height) > 0) {
                            selRect.height -= bottom;
                        }
                    } else {
                        int right;
                        int left = insets.left - selRect.x;
                        if (left > 0) {
                            selRect.x += left;
                            selRect.width -= left;
                        }
                        if ((right = selRect.x + selRect.width + insets.right - size.width) > 0) {
                            selRect.width -= right;
                        }
                    }
                }
            }
        }
    }

    private class TabContainer
    extends JPanel
    implements UIResource {
        private boolean notifyTabbedPane;

        private TabContainer() {
            super(null);
            this.notifyTabbedPane = true;
            this.setOpaque(false);
        }

        @Override
        public void remove(Component comp) {
            int index = PureTabbedPaneUI.this.tabPane.indexOfTabComponent(comp);
            super.remove(comp);
            if (this.notifyTabbedPane && index != -1) {
                PureTabbedPaneUI.this.tabPane.setTabComponentAt(index, null);
            }
        }

        private void removeUnusedTabComponents() {
            for (Component c : this.getComponents()) {
                int index;
                if (c instanceof UIResource || (index = PureTabbedPaneUI.this.tabPane.indexOfTabComponent(c)) != -1) continue;
                super.remove(c);
            }
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return PureTabbedPaneUI.this.tabScroller != null;
        }

        @Override
        public void doLayout() {
            if (PureTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.tabPanel.repaint();
                PureTabbedPaneUI.this.tabScroller.updateView();
            } else {
                PureTabbedPaneUI.this.tabPane.repaint(this.getBounds());
            }
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        private ScrollableTabPanel() {
            super(null);
            this.setOpaque(PureTabbedPaneUI.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = PureTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            PureTabbedPaneUI.this.paintTabArea(g, PureTabbedPaneUI.this.tabPane.getTabPlacement(), PureTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        @Override
        public void doLayout() {
            if (this.getComponentCount() > 0) {
                Component child = this.getComponent(0);
                child.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        private ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(PureTabbedPaneUI.this.tabPane.isOpaque());
            Color bgColor = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (bgColor == null) {
                bgColor = PureTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(bgColor);
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton abbButton;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.createButtons();
        }

        void createButtons() {
            int tabPlacement;
            if (this.scrollForwardButton != null) {
                PureTabbedPaneUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                PureTabbedPaneUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
                this.tabPanel.remove(this.abbButton);
                this.abbButton.removeActionListener(this);
            }
            if ((tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement()) == 1 || tabPlacement == 3) {
                this.scrollForwardButton = PureTabbedPaneUI.this.createScrollButton(3);
                this.scrollBackwardButton = PureTabbedPaneUI.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = PureTabbedPaneUI.this.createScrollButton(5);
                this.scrollBackwardButton = PureTabbedPaneUI.this.createScrollButton(1);
            }
            this.abbButton = new AddTabButton();
            this.abbButton.addActionListener(this);
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            PureTabbedPaneUI.this.tabPane.add(this.abbButton);
            PureTabbedPaneUI.this.tabPane.add(this.scrollForwardButton);
            PureTabbedPaneUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            switch (tabPlacement) {
                case 1: 
                case 3: {
                    int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[this.leadingTabIndex].x;
                    if (viewSize.width - this.tabViewPosition.x >= viewRect.width) break;
                    Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                    this.viewport.setExtentSize(extentSize);
                    break;
                }
                case 2: 
                case 4: {
                    int n = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[this.leadingTabIndex].y;
                    if (viewSize.height - this.tabViewPosition.y >= viewRect.height) break;
                    Dimension extentSize = new Dimension(viewRect.width, viewSize.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(extentSize);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateView();
        }

        private void updateView() {
            int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = PureTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = this.viewport.getBounds();
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            this.leadingTabIndex = this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount) {
                switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        if (((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[this.leadingTabIndex].x >= viewRect.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[this.leadingTabIndex].y >= viewRect.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets contentInsets = PureTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            switch (tabPlacement) {
                case 2: {
                    PureTabbedPaneUI.this.tabPane.repaint(vpRect.x + vpRect.width, vpRect.y, contentInsets.left, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 4: {
                    PureTabbedPaneUI.this.tabPane.repaint(vpRect.x - contentInsets.right, vpRect.y, contentInsets.right, vpRect.height);
                    this.scrollBackwardButton.setEnabled(viewRect.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.height - viewRect.y > viewRect.height);
                    break;
                }
                case 3: {
                    PureTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y - contentInsets.bottom, vpRect.width, contentInsets.bottom);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                    break;
                }
                default: {
                    PureTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
                    this.scrollBackwardButton.setEnabled(viewRect.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
                }
            }
        }

        private int getClosestTab(int x, int y) {
            int want;
            int tabCount;
            int min = 0;
            int max = tabCount = Math.min(PureTabbedPaneUI.this.rects.length, PureTabbedPaneUI.this.tabPane.getTabCount());
            int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean useX = tabPlacement == 1 || tabPlacement == 3;
            int n = want = useX ? x : y;
            while (min != max) {
                int maxLoc;
                int minLoc;
                int current = (max + min) / 2;
                if (useX) {
                    minLoc = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[current].x;
                    maxLoc = minLoc + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[current].width;
                } else {
                    minLoc = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[current].y;
                    maxLoc = minLoc + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[current].height;
                }
                if (want < minLoc) {
                    max = current;
                    if (min != max) continue;
                    return Math.max(0, current - 1);
                }
                if (want >= maxLoc) {
                    min = current;
                    if (max - min > 1) continue;
                    return Math.max(current + 1, tabCount - 1);
                }
                return current;
            }
            return min;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionKey;
            Action action;
            ActionMap map = PureTabbedPaneUI.this.tabPane.getActionMap();
            if (map != null && (action = map.get(actionKey = e.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : (e.getSource() == this.scrollBackwardButton ? "scrollTabsBackwardAction" : "addTabAction"))) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(PureTabbedPaneUI.this.tabPane, 1001, null, e.getWhen(), e.getModifiers()));
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        @Override
        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        @Override
        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        @Override
        public void layoutContainer(Container parent) {
            PureTabbedPaneUI.this.setRolloverTab(-1);
            int tabPlacement = PureTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = PureTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = PureTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = PureTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            Component selectedComponent = null;
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    PureTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                selectedComponent = PureTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
            }
            if (PureTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollForwardButton.setVisible(false);
                ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollBackwardButton.setVisible(false);
                return;
            }
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                PureTabbedPaneUI.this.setVisibleComponent(selectedComponent);
            }
            Insets contentInsets = PureTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            Rectangle bounds = PureTabbedPaneUI.this.tabPane.getBounds();
            int numChildren = PureTabbedPaneUI.this.tabPane.getComponentCount();
            if (numChildren > 0) {
                int ch;
                int cw;
                int cy;
                int cx;
                int ty;
                int tx;
                int th;
                int tw;
                switch (tabPlacement) {
                    case 2: {
                        tw = PureTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + tw + contentInsets.left;
                        cy = ty + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 4: {
                        tw = PureTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabWidth);
                        th = bounds.height - insets.top - insets.bottom;
                        tx = bounds.width - insets.right - tw;
                        ty = insets.top;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - tw - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    case 3: {
                        tw = bounds.width - insets.left - insets.right;
                        th = PureTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = bounds.height - insets.bottom - th;
                        cx = insets.left + contentInsets.left;
                        cy = insets.top + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                        break;
                    }
                    default: {
                        tw = bounds.width - insets.left - insets.right;
                        th = PureTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, PureTabbedPaneUI.this.runCount, PureTabbedPaneUI.this.maxTabHeight);
                        tx = insets.left;
                        ty = insets.top;
                        cx = tx + contentInsets.left;
                        cy = ty + th + contentInsets.top;
                        cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                        ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    }
                }
                for (int i = 0; i < numChildren; ++i) {
                    Component child = PureTabbedPaneUI.this.tabPane.getComponent(i);
                    if (PureTabbedPaneUI.this.tabScroller != null && child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.viewport) {
                        JViewport viewport = (JViewport)child;
                        Rectangle viewRect = viewport.getViewRect();
                        int vw = tw;
                        int vh = th;
                        Dimension butSize = ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollForwardButton.getPreferredSize();
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].height;
                                if (totalTabHeight <= th - (PureTabbedPaneUI.this.showAddTabsButton ? 25 : 0)) break;
                                int n = vh = th > this.getButtonsCont() * butSize.height ? th - this.getButtonsCont() * butSize.height : 0;
                                if (totalTabHeight - viewRect.y > vh) break;
                                vh = totalTabHeight - viewRect.y;
                                break;
                            }
                            default: {
                                int totalTabWidth = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].width;
                                if (totalTabWidth <= tw - (PureTabbedPaneUI.this.showAddTabsButton ? 25 : 0)) break;
                                int n = vw = tw > this.getButtonsCont() * butSize.width ? tw - this.getButtonsCont() * butSize.width : 0;
                                if (totalTabWidth - viewRect.x > vw) break;
                                vw = totalTabWidth - viewRect.x;
                            }
                        }
                        child.setBounds(tx, ty, vw, vh);
                        continue;
                    }
                    if (PureTabbedPaneUI.this.tabScroller != null && (child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollForwardButton || child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollBackwardButton || child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.abbButton)) {
                        Dimension bsize = child.getPreferredSize();
                        int bx = 0;
                        int by = 0;
                        int bw = bsize.width;
                        int bh = bsize.height;
                        boolean visible = child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.abbButton && PureTabbedPaneUI.this.showAddTabsButton;
                        switch (tabPlacement) {
                            case 2: 
                            case 4: {
                                int totalTabHeight;
                                by = totalTabHeight = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].height;
                                if (totalTabHeight <= th - (PureTabbedPaneUI.this.showAddTabsButton ? 25 : 0)) break;
                                visible = true;
                                int n = bx = tabPlacement == 2 ? tx + tw - bsize.width : tx;
                                if (child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollForwardButton) {
                                    by = bounds.height - insets.bottom - bsize.height;
                                    break;
                                }
                                if (child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollBackwardButton) {
                                    by = bounds.height - insets.bottom - 2 * bsize.height;
                                    break;
                                }
                                by = bounds.height - insets.bottom - 3 * bsize.height;
                                visible = PureTabbedPaneUI.this.showAddTabsButton;
                                break;
                            }
                            default: {
                                int totalTabWidth;
                                bx = totalTabWidth = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[tabCount - 1].width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                                if (totalTabWidth <= tw - (PureTabbedPaneUI.this.showAddTabsButton ? 25 : 0)) break;
                                visible = true;
                                if (child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollForwardButton) {
                                    bx = bounds.width - insets.left - bsize.width;
                                    break;
                                }
                                if (child == ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.scrollBackwardButton) {
                                    bx = bounds.width - insets.left - 2 * bsize.width;
                                    break;
                                }
                                bx = bounds.width - insets.left - 3 * bsize.width;
                                visible = PureTabbedPaneUI.this.showAddTabsButton;
                            }
                        }
                        child.setVisible(visible);
                        if (!visible) continue;
                        child.setBounds(bx, by, bw, bh);
                        continue;
                    }
                    child.setBounds(cx, cy, cw, ch);
                }
                ((TabbedPaneLayout)this).layoutTabComponents();
                if (shouldChangeFocus && !PureTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    PureTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        private int getButtonsCont() {
            return PureTabbedPaneUI.this.showAddTabsButton ? 3 : 2;
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            int i;
            FontMetrics metrics = PureTabbedPaneUI.this.getFontMetrics();
            Dimension size = PureTabbedPaneUI.this.tabPane.getSize();
            Insets insets = PureTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = PureTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = PureTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = PureTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            int x = tabAreaInsets.left;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    PureTabbedPaneUI.this.maxTabWidth = PureTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    break;
                }
                default: {
                    PureTabbedPaneUI.this.maxTabHeight = PureTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                }
            }
            PureTabbedPaneUI.this.runCount = 0;
            PureTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            PureTabbedPaneUI.this.selectedRun = 0;
            PureTabbedPaneUI.this.runCount = 1;
            for (i = 0; i < tabCount; ++i) {
                Rectangle rect = PureTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].x + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[0] = 0;
                        PureTabbedPaneUI.this.maxTabWidth = 0;
                        totalHeight += PureTabbedPaneUI.this.maxTabHeight;
                        rect.x = x;
                    }
                    rect.width = PureTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    totalWidth = rect.x + rect.width;
                    PureTabbedPaneUI.this.maxTabWidth = Math.max(PureTabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = PureTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (i > 0) {
                    rect.y = ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].y + ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i - 1].height;
                } else {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabRuns[0] = 0;
                    PureTabbedPaneUI.this.maxTabHeight = 0;
                    totalWidth = PureTabbedPaneUI.this.maxTabWidth;
                    rect.y = y;
                }
                rect.height = PureTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                totalHeight = rect.y + rect.height;
                PureTabbedPaneUI.this.maxTabHeight = Math.max(PureTabbedPaneUI.this.maxTabHeight, rect.height);
                rect.x = x;
                rect.width = PureTabbedPaneUI.this.maxTabWidth;
            }
            if (UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
                this.padSelectedTab(tabPlacement, selectedIndex);
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].x = rightMargin - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].x - ((PureTabbedPaneUI)PureTabbedPaneUI.this).rects[i].width;
                }
            }
            ((PureTabbedPaneUI)PureTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }

    private static class AddTabButton
    extends TabButton {
        private AddTabButton() {
            super(5);
        }

        @Override
        Icon getIcon(int direction) {
            return UIManager.getIcon("addtab");
        }

        @Override
        Icon getRolloverIcon(int direction) {
            return UIManager.getIcon("addtab_rollover");
        }
    }

    private static class ScrollableTabButton
    extends TabButton {
        private ScrollableTabButton(int direction) {
            super(direction);
        }

        @Override
        Icon getIcon(int direction) {
            Icon icon = null;
            if (direction == 3 || direction == 1) {
                icon = UIManager.getIcon("arrowright");
            }
            if (direction == 7 || direction == 5) {
                icon = UIManager.getIcon("arrowleft");
            }
            return icon;
        }

        @Override
        Icon getRolloverIcon(int direction) {
            Icon icon = null;
            if (direction == 3 || direction == 1) {
                icon = UIManager.getIcon("arrowright_rollover");
            } else if (direction == 7 || direction == 5) {
                icon = UIManager.getIcon("arrowleft_rollover");
            }
            return icon;
        }
    }

    private static abstract class TabButton
    extends JButton
    implements UIResource,
    SwingConstants {
        private TabButton(int direction) {
            this.checkDirection(direction);
            this.setUI(new PureAbstractButtonUI(){

                @Override
                protected void paintButtonPressed(Graphics g, AbstractButton b) {
                }
            });
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setIcon(this.getIcon(direction));
            this.setRolloverIcon(this.getRolloverIcon(direction));
            this.setRolloverEnabled(true);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        abstract Icon getIcon(int var1);

        abstract Icon getRolloverIcon(int var1);

        private void checkDirection(int direction) {
            if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
                throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(25, 25);
        }
    }

    private class PropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        private PropertyChangeHandler() {
            super(PureTabbedPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pName = evt.getPropertyName();
            if (null == pName) {
                return;
            }
            if (pName.equals("hideTabArea")) {
                this.hideTabsPropertyChanged((Boolean)evt.getNewValue());
            } else if (pName.equals("linkTabs")) {
                this.linkTabs((Boolean)evt.getNewValue());
            } else if (pName.equals("showAddTabsButton")) {
                this.showAddTabsButton((Boolean)evt.getNewValue());
            } else if (pName.equals("indexForTabComponent")) {
                Component c;
                if (PureTabbedPaneUI.this.tabContainer != null) {
                    PureTabbedPaneUI.this.tabContainer.removeUnusedTabComponents();
                }
                if ((c = PureTabbedPaneUI.this.tabPane.getTabComponentAt((Integer)evt.getNewValue())) != null) {
                    if (PureTabbedPaneUI.this.tabContainer == null) {
                        PureTabbedPaneUI.this.installTabContainer();
                    } else {
                        PureTabbedPaneUI.this.tabContainer.add(c);
                    }
                }
                PureTabbedPaneUI.this.tabPane.revalidate();
                PureTabbedPaneUI.this.tabPane.repaint();
            } else {
                super.propertyChange(evt);
            }
        }

        private void hideTabsPropertyChanged(Boolean newValue) {
            PureTabbedPaneUI.this.hideTabArea = newValue;
            this.updateTabPane();
        }

        private void linkTabs(Boolean newValue) {
            PureTabbedPaneUI.this.linkTabs = newValue;
            PureTabbedPaneUI.this.tabPane.setBackground(PureLookAndFeel.getCurrentTheme().getMenuBackground());
            PureTabbedPaneUI.this.tabPane.setFocusable(false);
            this.updateTabPane();
        }

        private void showAddTabsButton(Boolean newValue) {
            PureTabbedPaneUI.this.showAddTabsButton = newValue;
            this.updateTabPane();
        }

        private void updateTabPane() {
            PureTabbedPaneUI.this.tabPane.revalidate();
            PureTabbedPaneUI.this.tabPane.repaint();
        }
    }
}

