/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureAbstractToggleButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class PureToggleButtonUI
extends PureAbstractToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new PureToggleButtonUI();
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.getPressedColor(b));
        g2d.fillRect(0, 0, b.getWidth(), b.getHeight());
    }

    protected Color getPressedColor(AbstractButton b) {
        return PureLookAndFeel.getCurrentTheme().getFocusColor();
    }

    @Override
    protected Paint getNormalColor(JComponent c) {
        return StyleConstants.createButtonGradientNormal(0.0f, c.getHeight());
    }

    @Override
    protected Paint getRolloverColor(JComponent c) {
        return StyleConstants.createButtonGradientHover(0.0f, c.getHeight());
    }

    @Override
    protected boolean paintBorderDefault() {
        return true;
    }

    @Override
    protected boolean paintRolloverPressed() {
        return false;
    }
}

