/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureAbstractButtonUI;
import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.utils.StyleConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class PureToolBarButtonUI
extends PureAbstractButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new PureToolBarButtonUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setFont(this.getFont(c));
    }

    protected Font getFont(JComponent c) {
        return c.getFont().deriveFont(0, 11.0f);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        if (model.isPressed() && model.isEnabled()) {
            this.paintButtonPressed(g, button);
        } else if (model.isRollover() && model.isEnabled()) {
            Paint gradient = this.getRolloverGradient(c);
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, c.getWidth(), c.getHeight());
            g2d.setPaint(this.getStrokeColor());
            g2d.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        } else if (c.isOpaque()) {
            Paint gradient = this.getNormalGradient(c);
            g2d.setPaint(gradient);
            g2d.fillRect(0, 0, button.getWidth(), button.getHeight());
        }
        this.paint(g2d, c);
        View htmlView = (View)c.getClientProperty("html");
        if (htmlView != null) {
            Color color = !model.isEnabled() ? button.getBackground().darker() : UIManager.getColor("Label.foreground");
            c.setForeground(color);
        }
    }

    protected Color getStrokeColor() {
        return PureLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    protected Paint getNormalGradient(JComponent c) {
        return PureLookAndFeel.getCurrentTheme().getBackgroundColor();
    }

    public static Paint getRolloverPaint(JComponent c) {
        return StyleConstants.createButtonGradientHover(0.0f, c.getHeight());
    }

    protected Paint getRolloverGradient(JComponent c) {
        return PureToolBarButtonUI.getRolloverPaint(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        return BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
    }
}

