/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.utils.UIUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.text.View;

public class PureTooltipUI
extends BasicToolTipUI {
    private static final int PADDING = 11;

    public static ComponentUI createUI(JComponent c) {
        return new PureTooltipUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        View v;
        Font font = c.getFont();
        FontMetrics metrics = c.getFontMetrics(font);
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        if ((v = (View)c.getClientProperty("html")) != null) {
            v.paint(g, new Rectangle(11, 9, size.width, size.height));
        } else {
            g.setFont(font);
            UIUtils.drawString(c, g, tipText, 11, metrics.getAscent() + 9);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        Dimension prefSize = new Dimension();
        String text = ((JToolTip)c).getTipText();
        if (text == null || text.length() == 0) {
            text = "";
        } else {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                prefSize.width += (int)v.getPreferredSpan(0) + 11 + 11;
                prefSize.height += (int)v.getPreferredSpan(1) + 11 + 8;
            } else {
                prefSize.width += fm.stringWidth(text) + 11 + 11;
                prefSize.height += fm.getHeight() + 11 + 8;
            }
        }
        return prefSize;
    }
}

