/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.plaf;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.PureScrollBarUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class StreamScrollBarUI
extends PureScrollBarUI {
    private static final ImageIcon SCROLL_BAR_ICON = new ImageIcon(StreamScrollBarUI.class.getResource("icons/scroll-lines.png"));

    public static ComponentUI createUI(JComponent c) {
        return new StreamScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setPaint(PureLookAndFeel.getCurrentTheme().getDarkGrayColor());
        int height = trackBounds.height;
        int width = trackBounds.width;
        g2d.fillRect(0, 0, width, height);
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setPaint(this.getFillRectThumbColor());
        g2d.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        g2d.setPaint(this.getDrawRectThumbColor());
        g2d.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width - 1, thumbBounds.height - 1);
        int imgX = thumbBounds.x + (thumbBounds.width - SCROLL_BAR_ICON.getIconWidth()) / 2;
        int imgY = thumbBounds.y + (thumbBounds.height - SCROLL_BAR_ICON.getIconHeight()) / 2;
        if (this.scrollbar.getOrientation() == 0) {
            g2d.translate(0, 0);
        }
        g2d.drawImage(SCROLL_BAR_ICON.getImage(), imgX, imgY, SCROLL_BAR_ICON.getImageObserver());
    }
}

