/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.utils.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.View;

public class MenuItemRenderer {
    protected static final String HTML_KEY = "html";
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();
    static ImageIcon invertedArrowIcon;
    private final JMenuItem menuItem;
    private final boolean iconBorderEnabled;
    private final Font acceleratorFont;
    private final Color selectionForeground;
    private final Color disabledForeground;
    private final Color acceleratorForeground;
    private final Color acceleratorSelectionForeground;
    private final String acceleratorDelimiter;
    private final Icon fillerIcon;

    public MenuItemRenderer(JMenuItem menuItem, boolean iconBorderEnabled, Font acceleratorFont, Color selectionForeground, Color disabledForeground, Color acceleratorForeground, Color acceleratorSelectionForeground) {
        this.menuItem = menuItem;
        this.iconBorderEnabled = iconBorderEnabled;
        this.acceleratorFont = acceleratorFont;
        this.selectionForeground = selectionForeground;
        this.disabledForeground = disabledForeground;
        this.acceleratorForeground = acceleratorForeground;
        this.acceleratorSelectionForeground = acceleratorSelectionForeground;
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        this.fillerIcon = new MinimumSizedIcon();
    }

    private static Icon getIcon(JMenuItem aMenuItem, Icon defaultIcon) {
        Icon icon = aMenuItem.getIcon();
        if (icon == null) {
            return defaultIcon;
        }
        ButtonModel model = aMenuItem.getModel();
        if (!model.isEnabled()) {
            return model.isSelected() ? aMenuItem.getDisabledSelectedIcon() : aMenuItem.getDisabledIcon();
        }
        if (model.isPressed() && model.isArmed()) {
            Icon pressedIcon = aMenuItem.getPressedIcon();
            return pressedIcon != null ? pressedIcon : icon;
        }
        if (model.isSelected()) {
            Icon selectedIcon = aMenuItem.getSelectedIcon();
            return selectedIcon != null ? selectedIcon : icon;
        }
        if (model.isArmed()) {
            Icon rolloverSelectedIcon = aMenuItem.getRolloverSelectedIcon();
            return rolloverSelectedIcon != null ? rolloverSelectedIcon : icon;
        }
        return icon;
    }

    private boolean hasCustomIcon() {
        return MenuItemRenderer.getIcon(this.menuItem, null) != null;
    }

    private Icon getWrappedIcon(Icon icon) {
        if (icon == null) {
            return this.fillerIcon;
        }
        return this.iconBorderEnabled && this.hasCustomIcon() ? new MinimumSizedCheckIcon(icon, this.menuItem) : new MinimumSizedIcon(icon);
    }

    private static void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    public Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        FontMetrics fmAccel = b.getFontMetrics(this.acceleratorFont);
        MenuItemRenderer.resetRects();
        Icon wrappedIcon = this.getWrappedIcon(MenuItemRenderer.getIcon(this.menuItem, checkIcon));
        Icon icon = wrappedIcon.getIconHeight() > this.fillerIcon.getIconHeight() ? wrappedIcon : null;
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, wrappedIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MenuItemRenderer.iconRect.x, MenuItemRenderer.iconRect.y, MenuItemRenderer.iconRect.width, MenuItemRenderer.iconRect.height, r);
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxTextValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty(MAX_TEXT_WIDTH);
            int n = maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            if (MenuItemRenderer.r.width < maxTextValue) {
                MenuItemRenderer.r.width = maxTextValue;
            } else {
                p.putClientProperty(MAX_TEXT_WIDTH, new Integer(MenuItemRenderer.r.width));
            }
            MenuItemRenderer.r.width += MenuItemRenderer.acceleratorRect.width;
            MenuItemRenderer.r.width += 10;
        }
        if (this.useCheckAndArrow()) {
            MenuItemRenderer.r.width += MenuItemRenderer.checkIconRect.width;
            MenuItemRenderer.r.width += defaultTextIconGap;
            MenuItemRenderer.r.width += defaultTextIconGap;
            MenuItemRenderer.r.width += MenuItemRenderer.arrowIconRect.width;
        }
        MenuItemRenderer.r.width += 4 * defaultTextIconGap;
        Insets insets = b.getInsets();
        if (insets != null) {
            MenuItemRenderer.r.width += insets.left + insets.right;
            MenuItemRenderer.r.height += insets.top + insets.bottom;
        }
        if (MenuItemRenderer.r.height % 2 == 1) {
            ++MenuItemRenderer.r.height;
        }
        return r.getSize();
    }

    public void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        MenuItemRenderer.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        MenuItemRenderer.viewRect.x += i.left;
        MenuItemRenderer.viewRect.y += i.top;
        MenuItemRenderer.viewRect.width -= i.right + MenuItemRenderer.viewRect.x;
        MenuItemRenderer.viewRect.height -= i.bottom + MenuItemRenderer.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Icon wrappedIcon = this.getWrappedIcon(MenuItemRenderer.getIcon(this.menuItem, checkIcon));
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, null, wrappedIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap);
        MenuItemRenderer.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
            g.setColor(foreground);
        }
        wrappedIcon.paintIcon(c, g, MenuItemRenderer.checkIconRect.x, MenuItemRenderer.checkIconRect.y);
        g.setColor(holdc);
        if (text != null) {
            View v = (View)c.getClientProperty(HTML_KEY);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (!acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                int maxValue = MenuItemRenderer.acceleratorRect.width + defaultTextIconGap;
                accOffset = MenuItemRenderer.isLeftToRight(this.menuItem) ? maxValue - MenuItemRenderer.acceleratorRect.width : MenuItemRenderer.acceleratorRect.width - maxValue;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                g.setColor(this.disabledForeground);
                UIUtils.drawStringUnderlineCharAt(c, g, acceleratorText, -1, MenuItemRenderer.acceleratorRect.x - accOffset, MenuItemRenderer.acceleratorRect.y + fmAccel.getAscent());
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                UIUtils.drawStringUnderlineCharAt(c, g, acceleratorText, -1, MenuItemRenderer.acceleratorRect.x - accOffset, MenuItemRenderer.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
                arrowIcon = this.getInvertedIcon(arrowIcon);
            }
            if (!model.isEnabled()) {
                arrowIcon = UIUtils.getColorizedIcon(arrowIcon, this.menuItem.getForeground(), this.disabledForeground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c, g, MenuItemRenderer.arrowIconRect.x, MenuItemRenderer.arrowIconRect.y);
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    private Icon getInvertedIcon(Icon arrowIcon) {
        return UIUtils.getColorizedIcon(arrowIcon, this.menuItem.getForeground(), this.selectionForeground);
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRectangle, Rectangle iconRectangle, Rectangle textRectangle, Rectangle acceleratorRectangle, Rectangle checkIconRectangle, Rectangle arrowIconRectangle, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRectangle, iconRectangle, textRectangle, textIconGap);
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRectangle.height = 0;
            acceleratorRectangle.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRectangle.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRectangle.height = fmAccel.getHeight();
        }
        boolean useCheckAndArrow = this.useCheckAndArrow();
        if (useCheckAndArrow) {
            if (checkIcon != null) {
                checkIconRectangle.width = checkIcon.getIconWidth();
                checkIconRectangle.height = checkIcon.getIconHeight();
            } else {
                checkIconRectangle.height = 0;
                checkIconRectangle.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRectangle.width = arrowIcon.getIconWidth();
                arrowIconRectangle.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRectangle.height = 0;
                arrowIconRectangle.width = 0;
            }
        }
        Rectangle labelRect = iconRectangle.union(textRectangle);
        if (MenuItemRenderer.isLeftToRight(this.menuItem)) {
            textRectangle.x += menuItemGap;
            iconRectangle.x += menuItemGap;
            int arrowWith = arrowIconRectangle.width + menuItemGap;
            acceleratorRectangle.x = viewRectangle.x + viewRectangle.width - arrowWith - acceleratorRectangle.width - 5;
            if (useCheckAndArrow) {
                checkIconRectangle.x = viewRectangle.x + menuItemGap;
                textRectangle.x += checkIconRectangle.width + menuItemGap;
                iconRectangle.x += checkIconRectangle.width + MenuItemRenderer.checkIconRect.x;
                arrowIconRectangle.x = viewRectangle.x + viewRectangle.width - menuItemGap - arrowIconRectangle.width - 5;
            }
        } else {
            textRectangle.x -= menuItemGap;
            iconRectangle.x -= menuItemGap;
            acceleratorRectangle.x = viewRectangle.x + arrowIconRectangle.width + menuItemGap;
            if (useCheckAndArrow) {
                checkIconRectangle.x = viewRectangle.x + viewRectangle.width - checkIconRectangle.width;
                textRectangle.x -= menuItemGap + checkIconRectangle.width;
                iconRectangle.x -= menuItemGap + checkIconRectangle.width;
                arrowIconRectangle.x = viewRectangle.x + menuItemGap;
            }
        }
        acceleratorRectangle.y = labelRect.y + labelRect.height / 2 - acceleratorRectangle.height / 2;
        if (useCheckAndArrow) {
            arrowIconRectangle.y = labelRect.y + labelRect.height / 2 - arrowIconRectangle.height / 2;
            checkIconRectangle.y = labelRect.y + labelRect.height / 2 - checkIconRectangle.height / 2;
        }
        return text;
    }

    private boolean useCheckAndArrow() {
        boolean isTopLevelMenu = this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu();
        return !isTopLevelMenu;
    }

    private static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    private static void paintBackground(Graphics g, JMenuItem aMenuItem, Color bgColor) {
        ButtonModel model = aMenuItem.getModel();
        if (aMenuItem.isOpaque()) {
            int menuWidth = aMenuItem.getWidth();
            int menuHeight = aMenuItem.getHeight();
            Color c = model.isArmed() || aMenuItem instanceof JMenu && model.isSelected() ? bgColor : aMenuItem.getBackground();
            Color oldColor = g.getColor();
            g.setColor(c);
            g.fillRect(0, 0, menuWidth, menuHeight);
            g.setColor(aMenuItem.getBackground());
            g.fillRect(0, 0, 0, menuHeight);
            g.fillRect(menuWidth, 0, 0, menuHeight);
            g.setColor(oldColor);
        }
    }

    private void paintText(Graphics g, JMenuItem aMenuItem, Rectangle textRectangle, String text) {
        --textRectangle.y;
        ButtonModel model = aMenuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = aMenuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            g.setColor(this.disabledForeground);
            UIUtils.drawStringUnderlineCharAt(aMenuItem, g, text, mnemIndex, textRectangle.x, textRectangle.y + fm.getAscent());
        } else {
            if (model.isArmed() || aMenuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            UIUtils.drawStringUnderlineCharAt(aMenuItem, g, text, mnemIndex, textRectangle.x, textRectangle.y + fm.getAscent());
        }
    }

    private static final class MinimumSizedCheckIcon
    extends MinimumSizedIcon {
        private final JMenuItem menuItem;

        public MinimumSizedCheckIcon(Icon icon, JMenuItem menuItem) {
            super(icon);
            this.menuItem = menuItem;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.paintState(g, x, y);
            super.paintIcon(c, g, x, y);
        }

        private void paintState(Graphics g, int x, int y) {
            ButtonModel model = this.menuItem.getModel();
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            g.translate(x, y);
            if (model.isSelected() || model.isArmed()) {
                Color background = model.isArmed() ? UIManager.getColor("MenuItem.background") : UIManager.getColor("ScrollBar.track");
                Color upColor = UIManager.getColor("controlLtHighlight");
                Color downColor = UIManager.getColor("controlDkShadow");
                g.setColor(background);
                g.fillRect(0, 0, w, h);
                g.setColor(model.isSelected() ? downColor : upColor);
                g.drawLine(0, 0, w - 2, 0);
                g.drawLine(0, 0, 0, h - 2);
                g.setColor(model.isSelected() ? upColor : downColor);
                g.drawLine(0, h - 1, w - 1, h - 1);
                g.drawLine(w - 1, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
            g.setColor(UIManager.getColor("textText"));
        }
    }

    public static class MinimumSizedIcon
    implements Icon {
        private final Icon icon;
        private final int width;
        private final int height;
        private final int xOffset;
        private final int yOffset;

        public MinimumSizedIcon() {
            this(null);
        }

        public MinimumSizedIcon(Icon icon) {
            Dimension minimumSize = new Dimension(12, 12);
            this.icon = icon;
            int iconWidth = icon == null ? 0 : icon.getIconWidth();
            int iconHeight = icon == null ? 0 : icon.getIconHeight();
            this.width = Math.max(iconWidth, Math.max(12, minimumSize.width));
            this.height = Math.max(iconHeight, Math.max(12, minimumSize.height));
            this.xOffset = Math.max(0, (this.width - iconWidth) / 2);
            this.yOffset = Math.max(0, (this.height - iconHeight) / 2);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.icon != null) {
                this.icon.paintIcon(c, g, x + this.xOffset, y + this.yOffset);
            }
        }
    }
}

