/*
 * Decompiled with CFR 0.152.
 */
package com.agilemind.utils;

import com.agilemind.plaf.PureLookAndFeel;
import com.agilemind.plaf.RadioButtonMenuItemIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleConstants {
    private static final Logger LOG = LoggerFactory.getLogger(StyleConstants.class);
    public static ImageIcon arrowLeft;
    public static ImageIcon arrowRight;
    public static ImageIcon arrowUp;
    public static ImageIcon arrowDown;
    public static ImageIcon darkArrowLeft;
    public static ImageIcon darkArrowRight;
    public static ImageIcon darkArrowUp;
    public static ImageIcon darkArrowDown;
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxMenuItemIcon;
    private static FontUIResource ARIAL_PLAIN_12;
    private static FontUIResource ARIAL_BOLD_12;
    private static FontUIResource ARIAL_PLAIN_11;
    private static boolean useCustomFont;
    private static Font customFont;
    public static final Color TRANSPARENT_COLOR;
    public static final Color DARK_BACKGROUND;
    public static final Color DARK_BACKGROUND2;
    public static final Color TEXT_COLOR;
    public static final Color TEXT_DESCRIPTION_COLOR;
    public static final Color TABBED_PANE_HEADER_UNSELECTED_COLOR;
    public static final Color TEXT_ROLLOVER_COLOR;
    public static final Color TEXT_SELECTED_COLOR;
    public static final Color MENU_BAR_BACKGROUND;
    public static final Color MENU_ACCELERATOR_FOREGROUND;
    public static final Color MENU_ACCELERATOR_SELECTED_FOREGROUND;
    public static final Color MENU_SEPARATOR_BACKGROUND;
    public static final Color DARK_MENU_BACKGROUND;
    public static final Color DARK_MENU_FOREGROUND;
    public static final Color DARK_MENU_SELECTED_FOREGROUND;
    public static final Color DARK_MENU_SELECTED_BACKGROUND;
    public static final Color DARK_MENU_DISABLED_FOREGROUND;
    public static final Color DARK_MENU_ACCELERATOR_FOREGROUND;
    public static final Color DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND;
    public static final Color DARK_MENU_SEPARATOR_BACKGROUND;
    public static final Color POPUP_BACKGROUND;

    private StyleConstants() {
    }

    public static GradientPaint createButtonGradientNormal(float y1, float y2) {
        return new GradientPaint(0.0f, y1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y2, PureLookAndFeel.getCurrentTheme().getGradientDarkColor());
    }

    public static GradientPaint createButtonGradientHover(float y1, float y2) {
        return new GradientPaint(0.0f, y1, PureLookAndFeel.getCurrentTheme().getGradientLightColor(), 0.0f, y2, PureLookAndFeel.getCurrentTheme().getGradientLessLightColor());
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static FontUIResource getControlTextFont(UIDefaults table, String uiId) {
        if (table.contains(uiId)) {
            return StyleConstants.getFont(table.getFont(uiId), 0, 12);
        }
        return StyleConstants.getFont(new Font("Default", 0, 12), 0, 12);
    }

    public static FontUIResource getSmallControlTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 0, 11);
    }

    public static FontUIResource getButtonTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 1, 12);
    }

    public static FontUIResource getToolbarButtonTextFont(Font uiId) {
        return StyleConstants.getFont(uiId, 0, 11);
    }

    private static FontUIResource getFont(Font oldFont, int style, int size) {
        Font newFont = null;
        if (useCustomFont) {
            if (customFont == null) {
                String customFontName = System.getProperty("customFont");
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                for (Font font : graphicsEnvironment.getAllFonts()) {
                    if (!font.getName().equalsIgnoreCase(customFontName)) continue;
                    customFont = font;
                    if (!LOG.isWarnEnabled()) break;
                    LOG.warn("Set custom font " + customFont.getName());
                    break;
                }
                useCustomFont = customFont != null;
            }
            newFont = customFont;
        }
        if (newFont == null) {
            newFont = oldFont;
        }
        return new FontUIResource(newFont.getName(), style, size);
    }

    static {
        ARIAL_PLAIN_12 = new FontUIResource("Arial", 0, 12);
        ARIAL_BOLD_12 = new FontUIResource("Arial", 1, 12);
        ARIAL_PLAIN_11 = new FontUIResource("Arial", 0, 11);
        useCustomFont = System.getProperty("customFont") != null;
        customFont = null;
        TRANSPARENT_COLOR = new ColorUIResource(new Color(255, 255, 255, 0));
        DARK_BACKGROUND = new ColorUIResource(62, 62, 62);
        DARK_BACKGROUND2 = new ColorUIResource(43, 43, 43);
        TEXT_COLOR = new ColorUIResource(162, 162, 162);
        TEXT_DESCRIPTION_COLOR = new ColorUIResource(125, 125, 125);
        TABBED_PANE_HEADER_UNSELECTED_COLOR = new ColorUIResource(196, 196, 196);
        TEXT_ROLLOVER_COLOR = new ColorUIResource(210, 210, 210);
        TEXT_SELECTED_COLOR = new ColorUIResource(100, 165, 49);
        MENU_BAR_BACKGROUND = DARK_BACKGROUND;
        MENU_ACCELERATOR_FOREGROUND = new ColorUIResource(158, 158, 158);
        MENU_ACCELERATOR_SELECTED_FOREGROUND = new ColorUIResource(144, 176, 219);
        MENU_SEPARATOR_BACKGROUND = new ColorUIResource(213, 213, 213);
        DARK_MENU_BACKGROUND = new ColorUIResource(73, 73, 73);
        DARK_MENU_FOREGROUND = new ColorUIResource(196, 196, 196);
        DARK_MENU_SELECTED_FOREGROUND = new ColorUIResource(Color.WHITE);
        DARK_MENU_SELECTED_BACKGROUND = DARK_BACKGROUND2;
        DARK_MENU_DISABLED_FOREGROUND = TEXT_DESCRIPTION_COLOR;
        DARK_MENU_ACCELERATOR_FOREGROUND = DARK_MENU_FOREGROUND;
        DARK_MENU_ACCELERATOR_SELECTED_FOREGROUND = DARK_MENU_SELECTED_FOREGROUND;
        DARK_MENU_SEPARATOR_BACKGROUND = new ColorUIResource(59, 59, 59);
        POPUP_BACKGROUND = new ColorUIResource(251, 251, 251);
        BufferedImage image = new BufferedImage(3, 5, 6);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setPaint(Color.BLACK);
        g.drawLine(0, 2, 0, 2);
        g.drawLine(1, 1, 1, 3);
        g.drawLine(2, 0, 2, 4);
        arrowLeft = new ImageIcon(image);
        image = new BufferedImage(3, 5, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(Color.BLACK);
        g.drawLine(0, 0, 0, 4);
        g.drawLine(1, 1, 1, 3);
        g.drawLine(2, 2, 2, 2);
        arrowRight = new ImageIcon(image);
        image = new BufferedImage(5, 3, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(Color.BLACK);
        g.drawLine(2, 0, 2, 0);
        g.drawLine(1, 1, 3, 1);
        g.drawLine(0, 2, 4, 2);
        arrowUp = new ImageIcon(image);
        image = new BufferedImage(5, 3, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(Color.BLACK);
        g.drawLine(0, 0, 4, 0);
        g.drawLine(1, 1, 3, 1);
        g.drawLine(2, 2, 2, 2);
        arrowDown = new ImageIcon(image);
        image = new BufferedImage(3, 5, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(DARK_MENU_FOREGROUND);
        g.drawLine(0, 2, 0, 2);
        g.drawLine(1, 1, 1, 3);
        g.drawLine(2, 0, 2, 4);
        darkArrowLeft = new ImageIcon(image);
        image = new BufferedImage(3, 5, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(DARK_MENU_FOREGROUND);
        g.drawLine(0, 0, 0, 4);
        g.drawLine(1, 1, 1, 3);
        g.drawLine(2, 2, 2, 2);
        darkArrowRight = new ImageIcon(image);
        image = new BufferedImage(5, 3, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(DARK_MENU_FOREGROUND);
        g.drawLine(2, 0, 2, 0);
        g.drawLine(1, 1, 3, 1);
        g.drawLine(0, 2, 4, 2);
        darkArrowUp = new ImageIcon(image);
        image = new BufferedImage(5, 3, 6);
        g = (Graphics2D)image.getGraphics();
        g.setPaint(DARK_MENU_FOREGROUND);
        g.drawLine(0, 0, 4, 0);
        g.drawLine(1, 1, 3, 1);
        g.drawLine(2, 2, 2, 2);
        darkArrowDown = new ImageIcon(image);
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final int SIZE = 12;

        private CheckBoxMenuItemIcon() {
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            if (b.isSelected()) {
                CheckBoxMenuItemIcon.drawCheck(g, x, y + 1);
            }
        }

        private static void drawCheck(Graphics g, int x, int y) {
            g.translate(x, y);
            g.drawLine(3, 5, 3, 5);
            g.fillRect(3, 6, 2, 2);
            g.drawLine(4, 8, 9, 3);
            g.drawLine(5, 8, 9, 4);
            g.drawLine(5, 9, 9, 5);
            g.translate(-x, -y);
        }
    }
}

